/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.util.datatype.XSDDatetime;
import com.siemens.ct.exi.values.AbstractValue;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTimeValue
extends AbstractValue {
    protected final DatetimeType type;
    protected final int year;
    protected final int monthDay;
    protected final int time;
    protected final int fractionalSecs;
    protected final int timeZone;
    protected Calendar cal;

    public DateTimeValue(DatetimeType type, int year, int monthDay, int time, int fractionalSecs, int timeZone) {
        this.type = type;
        this.year = year;
        this.monthDay = monthDay;
        this.time = time;
        this.fractionalSecs = fractionalSecs;
        this.timeZone = timeZone;
    }

    public Calendar toCalendar() {
        if (this.cal == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            switch (this.type) {
                case gYear: {
                    cal.set(1, this.year);
                    DateTimeValue.setTimezone(cal, this.timeZone);
                    break;
                }
                case gYearMonth: 
                case date: {
                    cal.set(1, this.year);
                    XSDDatetime.setMonthDay(this.monthDay, cal);
                    DateTimeValue.setTimezone(cal, this.timeZone);
                    break;
                }
                case dateTime: {
                    cal.set(1, this.year);
                    XSDDatetime.setMonthDay(this.monthDay, cal);
                    XSDDatetime.setTime(this.time, cal);
                    cal.set(14, this.fractionalSecs);
                    DateTimeValue.setTimezone(cal, this.timeZone);
                    break;
                }
                case gMonth: 
                case gMonthDay: 
                case gDay: {
                    XSDDatetime.setMonthDay(this.monthDay, cal);
                    DateTimeValue.setTimezone(cal, this.timeZone);
                    break;
                }
                case time: {
                    XSDDatetime.setTime(this.time, cal);
                    cal.set(14, this.fractionalSecs);
                    DateTimeValue.setTimezone(cal, this.timeZone);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this.cal;
    }

    public char[] toCharacters() {
        if (this.characters == null) {
            int index = 0;
            switch (this.type) {
                case gYear: {
                    this.characters = new char[(this.year < 0 ? 5 : 4) + (this.timeZone == 0 ? 0 : 6)];
                    index += DateTimeValue.appendYear(this.characters, index, this.year);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case gYearMonth: {
                    this.characters = new char[(this.year < 0 ? 5 : 4) + 3 + (this.timeZone == 0 ? 0 : 6)];
                    index += DateTimeValue.appendYear(this.characters, index, this.year);
                    index += DateTimeValue.appendMonth(this.characters, index, this.monthDay);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case date: {
                    this.characters = new char[(this.year < 0 ? 5 : 4) + 6 + (this.timeZone == 0 ? 0 : 6)];
                    index += DateTimeValue.appendYear(this.characters, index, this.year);
                    index += DateTimeValue.appendMonthDay(this.characters, index, this.monthDay);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case dateTime: {
                    int sizeFractionalSecs = this.fractionalSecs == 0 ? 0 : MethodsBag.getStringSize(this.fractionalSecs) + 1;
                    this.characters = new char[(this.year < 0 ? 5 : 4) + 6 + 9 + sizeFractionalSecs + (this.timeZone == 0 ? 0 : 6)];
                    index += DateTimeValue.appendYear(this.characters, index, this.year);
                    index += DateTimeValue.appendMonthDay(this.characters, index, this.monthDay);
                    this.characters[index++] = 84;
                    index += DateTimeValue.appendTime(this.characters, index, this.time);
                    index += DateTimeValue.appendFractionalSeconds(this.characters, index, this.fractionalSecs, sizeFractionalSecs - 1);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case gMonth: {
                    this.characters = new char[4 + (this.timeZone == 0 ? 0 : 6)];
                    this.characters[index++] = 45;
                    index += DateTimeValue.appendMonth(this.characters, index, this.monthDay);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case gMonthDay: {
                    this.characters = new char[7 + (this.timeZone == 0 ? 0 : 6)];
                    this.characters[index++] = 45;
                    index += DateTimeValue.appendMonthDay(this.characters, index, this.monthDay);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case gDay: {
                    this.characters = new char[5 + (this.timeZone == 0 ? 0 : 6)];
                    this.characters[index++] = 45;
                    this.characters[index++] = 45;
                    this.characters[index++] = 45;
                    index += DateTimeValue.appendDay(this.characters, index, this.monthDay);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                case time: {
                    int sizeFractionalSecs = this.fractionalSecs == 0 ? 0 : MethodsBag.getStringSize(this.fractionalSecs) + 1;
                    this.characters = new char[8 + sizeFractionalSecs + (this.timeZone == 0 ? 0 : 6)];
                    index += DateTimeValue.appendTime(this.characters, index, this.time);
                    index += DateTimeValue.appendFractionalSeconds(this.characters, index, this.fractionalSecs, sizeFractionalSecs - 1);
                    DateTimeValue.appendTimezone(this.characters, index, this.timeZone);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this.characters;
    }

    private static void setTimezone(Calendar cal, int tz) {
        TimeZone tzO = TimeZone.getTimeZone("GMT+00:00");
        tzO.setRawOffset(tz);
        cal.setTimeZone(tzO);
    }

    private static void appendTimezone(char[] ca, int index, int tz) {
        if (tz != 0) {
            if (tz < 0) {
                ca[index++] = 45;
                tz *= -1;
            } else {
                ca[index++] = 43;
            }
            int hours = tz / 60;
            index += DateTimeValue.appendTwoDigits(ca, index, hours);
            ca[index++] = 58;
            int minutes = tz - hours * 60;
            DateTimeValue.appendTwoDigits(ca, index, minutes);
        }
    }

    private static int appendFractionalSeconds(char[] ca, int index, int fracSecs, int sLen) {
        if (fracSecs > 0) {
            ca[index++] = 46;
            int chars = MethodsBag.itosReverse(fracSecs, index, ca);
            return chars + 1;
        }
        return 0;
    }

    private static int appendTwoDigits(char[] ca, int index, int i) {
        if (i > 9) {
            MethodsBag.itos(i, index + 2, ca);
        } else {
            ca[index++] = 48;
            MethodsBag.itos(i, index + 1, ca);
        }
        return 2;
    }

    private static int appendYear(char[] ca, int index, int year) {
        int sLen = 4;
        if (year < 0) {
            ca[index] = 45;
            ++index;
            year = -year;
            ++sLen;
        }
        if (year > 999) {
            MethodsBag.itos(year, index + 4, ca);
        } else if (year > 99) {
            ca[index++] = 48;
            MethodsBag.itos(year, index + 3, ca);
        } else if (year > 9) {
            ca[index++] = 48;
            ca[index++] = 48;
            MethodsBag.itos(year, index + 2, ca);
        } else {
            ca[index++] = 48;
            ca[index++] = 48;
            ca[index++] = 48;
            MethodsBag.itos(year, index + 1, ca);
        }
        return sLen;
    }

    private static int appendMonth(char[] ca, int index, int monthDay) {
        int month = monthDay / 32;
        assert (monthDay - month * 32 == 0);
        ca[index++] = 45;
        return DateTimeValue.appendTwoDigits(ca, index, month) + 1;
    }

    private static int appendMonthDay(char[] ca, int index, int monthDay) {
        int month = monthDay / 32;
        int day = monthDay - month * 32;
        ca[index++] = 45;
        index += DateTimeValue.appendTwoDigits(ca, index, month);
        ca[index++] = 45;
        DateTimeValue.appendTwoDigits(ca, index, day);
        return 6;
    }

    private static int appendDay(char[] ca, int index, int day) {
        assert (day < 31);
        DateTimeValue.appendTwoDigits(ca, index, day);
        return 2;
    }

    private static int appendTime(char[] ca, int index, int time) {
        int secHour = 3600;
        int secMinute = 60;
        int hour = time / 3600;
        int minutes = (time -= hour * 3600) / 60;
        int seconds = time - minutes * 60;
        index += DateTimeValue.appendTwoDigits(ca, index, hour);
        ca[index++] = 58;
        index += DateTimeValue.appendTwoDigits(ca, index, minutes);
        ca[index++] = 58;
        index += DateTimeValue.appendTwoDigits(ca, index, seconds);
        return 8;
    }
}

