/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.event.AttributeGeneric;
import com.siemens.ct.exi.grammar.event.CharactersGeneric;
import com.siemens.ct.exi.grammar.event.EndElement;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.event.StartElementGeneric;
import com.siemens.ct.exi.grammar.event.StartElementNS;
import com.siemens.ct.exi.grammar.rule.SchemaInformedElement;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.util.sort.LexicographicSort;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSWildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EXIContentModelBuilder
extends CMBuilder
implements XMLErrorHandler {
    private static final boolean DEBUG = false;
    protected static final Event END_ELEMENT = new EndElement();
    protected static final Event START_ELEMENT_GENERIC = new StartElementGeneric();
    protected static final Event ATTRIBUTE_GENERIC = new AttributeGeneric();
    protected static final Event CHARACTERS_GENERIC = new CharactersGeneric();
    protected static final boolean forUPA = false;
    protected static final LexicographicSort lexSort = new LexicographicSort();
    protected SubstitutionGroupHandler subGroupHandler;
    protected XSModel xsModel;
    protected List<String> schemaParsingErrors;
    protected List<XSElementDeclaration> remainingElements;
    protected Map<XSElementDeclaration, StartElement> elementPool;

    public EXIContentModelBuilder() {
        super(new CMNodeFactory());
    }

    protected void initOnce() {
        this.remainingElements = new ArrayList<XSElementDeclaration>();
        this.elementPool = new HashMap<XSElementDeclaration, StartElement>();
        this.schemaParsingErrors = new ArrayList<String>();
    }

    protected void initEachRun() {
        this.remainingElements.clear();
        this.elementPool.clear();
        this.schemaParsingErrors.clear();
    }

    public void loadGrammar(XMLInputSource xsdSource) throws EXIException {
        try {
            this.initEachRun();
            XMLSchemaLoader sl = new XMLSchemaLoader();
            sl.setErrorHandler((XMLErrorHandler)this);
            SchemaGrammar g = (SchemaGrammar)sl.loadGrammar(xsdSource);
            this.xsModel = g.toXSModel();
            XSGrammarBucket grammarBucket = new XSGrammarBucket();
            grammarBucket.putGrammar(g, true);
            this.subGroupHandler = new SubstitutionGroupHandler(grammarBucket);
        }
        catch (Exception e) {
            throw new EXIException(e);
        }
    }

    public void loadGrammar(String xsdLocation) throws EXIException {
        String publicId = null;
        String systemId = xsdLocation;
        String baseSystemId = null;
        XMLInputSource xsdSource = new XMLInputSource(publicId, systemId, baseSystemId);
        this.loadGrammar(xsdSource);
    }

    public void loadGrammar(InputStream xsdInputStream) throws EXIException {
        String publicId = null;
        String systemId = null;
        String baseSystemId = null;
        String encoding = null;
        XMLInputSource xsdSource = new XMLInputSource(publicId, systemId, baseSystemId, xsdInputStream, encoding);
        this.loadGrammar(xsdSource);
    }

    public XSModel getXSModel() {
        return this.xsModel;
    }

    XSCMValidator createAllCM(XSParticleDecl particle) {
        assert (particle.getMaxOccurs() == 1);
        assert (particle.getMinOccurs() == 0 || particle.getMinOccurs() == 1);
        return super.createAllCM(particle);
    }

    private static SchemaInformedRule addNewState(Map<CMState, SchemaInformedRule> states, CMState key, boolean isMixedContent) {
        SchemaInformedElement val = new SchemaInformedElement();
        if (key.end) {
            val.addTerminalRule(END_ELEMENT);
        }
        if (isMixedContent) {
            val.addRule(CHARACTERS_GENERIC, val);
        }
        states.put(key, val);
        return val;
    }

    protected SchemaInformedRule handleParticle(XSComplexTypeDefinition ctd, boolean isMixedContent) throws EXIException {
        XSCMValidator xscmVal = this.getContentModel((XSComplexTypeDecl)ctd, false);
        int[] state = xscmVal.startContentModel();
        Vector possibleElements = xscmVal.whatCanGoHere(state);
        boolean isEnd = xscmVal.endContentModel(state);
        CMState startState = new CMState(possibleElements, isEnd, state);
        HashMap<CMState, SchemaInformedRule> knownStates = new HashMap<CMState, SchemaInformedRule>();
        EXIContentModelBuilder.addNewState(knownStates, startState, isMixedContent);
        this.handleStateEntries(possibleElements, xscmVal, state, startState, knownStates, isMixedContent);
        return (SchemaInformedRule)knownStates.get(startState);
    }

    protected StartElement getStartElement(XSElementDeclaration elementDecl) {
        StartElement se;
        if (this.elementPool.containsKey(elementDecl)) {
            se = this.elementPool.get(elementDecl);
        } else {
            QName qname = new QName(elementDecl.getNamespace(), elementDecl.getName());
            se = new StartElement(qname);
            this.elementPool.put(elementDecl, se);
        }
        return se;
    }

    private void handleStateEntries(Vector<XSObject> possibleElements, XSCMValidator xscmVal, int[] originalState, CMState startState, Map<CMState, SchemaInformedRule> knownStates, boolean isMixedContent) throws EXIException {
        assert (knownStates.containsKey(startState));
        for (XSObject xs : possibleElements) {
            int i;
            int[] cstate = new int[originalState.length];
            System.arraycopy(originalState, 0, cstate, 0, originalState.length);
            if (xs.getType() == 2) {
                XSElementDeclaration nextEl = (XSElementDeclaration)xs;
                org.apache.xerces.xni.QName qname = new org.apache.xerces.xni.QName(null, nextEl.getName(), null, nextEl.getNamespace());
                Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
                assert (xs == nextRet);
                Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
                boolean isEnd = xscmVal.endContentModel(cstate);
                CMState nextState = new CMState(nextPossibleElements, isEnd, cstate);
                EXIContentModelBuilder.printTransition(startState, xs, nextState);
                if (!this.remainingElements.contains(nextEl)) {
                    this.remainingElements.add(nextEl);
                }
                List<XSElementDeclaration> elements = this.getPossibleElementDeclarations(nextEl);
                assert (elements.size() > 0);
                boolean isNewState = false;
                i = 0;
                while (i < elements.size()) {
                    XSElementDeclaration nextEN = elements.get(i);
                    StartElement xsEvent = this.getStartElement(nextEN);
                    if (i == 0) {
                        isNewState = this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                    } else {
                        this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                    }
                    ++i;
                }
                if (!isNewState) continue;
                this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent);
                continue;
            }
            assert (xs.getType() == 9);
            XSWildcard nextWC = (XSWildcard)xs;
            short constraintType = nextWC.getConstraintType();
            if (constraintType == 1 || constraintType == 2) {
                org.apache.xerces.xni.QName qname = new org.apache.xerces.xni.QName(null, "##wc", null, "");
                Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
                assert (xs == nextRet);
                Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
                boolean isEnd = xscmVal.endContentModel(cstate);
                CMState nextState = new CMState(nextPossibleElements, isEnd, cstate);
                EXIContentModelBuilder.printTransition(startState, xs, nextState);
                Event xsEvent = START_ELEMENT_GENERIC;
                boolean isNewState = this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                if (!isNewState) continue;
                this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent);
                continue;
            }
            assert (constraintType == 3);
            StringList sl = nextWC.getNsConstraintList();
            org.apache.xerces.xni.QName qname = new org.apache.xerces.xni.QName(null, "##wc", null, sl.item(0));
            Object nextRet = xscmVal.oneTransition(qname, cstate, this.subGroupHandler);
            assert (xs == nextRet);
            Vector nextPossibleElements = xscmVal.whatCanGoHere(cstate);
            boolean isEnd = xscmVal.endContentModel(cstate);
            CMState nextState = new CMState(nextPossibleElements, isEnd, cstate);
            EXIContentModelBuilder.printTransition(startState, xs, nextState);
            i = 0;
            while (i < sl.getLength()) {
                StartElementNS xsEvent = new StartElementNS(sl.item(i));
                boolean isNewState = this.handleStateEntry(startState, knownStates, xsEvent, nextState, isMixedContent);
                if (isNewState) {
                    this.handleStateEntries(nextPossibleElements, xscmVal, cstate, nextState, knownStates, isMixedContent);
                }
                ++i;
            }
        }
    }

    private boolean handleStateEntry(CMState startState, Map<CMState, SchemaInformedRule> knownStates, Event xsEvent, CMState nextState, boolean isMixedContent) {
        SchemaInformedRule startRule = knownStates.get(startState);
        if (knownStates.containsKey(nextState)) {
            startRule.addRule(xsEvent, knownStates.get(nextState));
            return false;
        }
        EXIContentModelBuilder.addNewState(knownStates, nextState, isMixedContent);
        startRule.addRule(xsEvent, knownStates.get(nextState));
        return true;
    }

    private List<XSElementDeclaration> getPossibleElementDeclarations(XSElementDeclaration el) {
        ArrayList<XSElementDeclaration> listElements = new ArrayList<XSElementDeclaration>();
        listElements.add(el);
        XSObjectList listSG = this.xsModel.getSubstitutionGroup(el);
        if (listSG != null && listSG.getLength() > 0) {
            int i = 0;
            while (i < listSG.getLength()) {
                XSElementDeclaration ed = (XSElementDeclaration)listSG.item(i);
                listElements.add(ed);
                ++i;
            }
        }
        Collections.sort(listElements, lexSort);
        return listElements;
    }

    private static void printTransition(CMState startState, XSObject xs, CMState nextState) {
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-error] " + exception.getMessage());
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-fatalError] " + exception.getMessage());
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.schemaParsingErrors.add("[xs-warning] " + exception.getMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CMState {
        protected final Vector<XSObject> states;
        protected final boolean end;
        protected int[] state;

        public CMState(Vector<XSObject> states, boolean end, int[] state) {
            this.states = states;
            this.end = end;
            this.state = new int[state.length];
            System.arraycopy(state, 0, this.state, 0, state.length);
        }

        public boolean equals(Object o) {
            if (o instanceof CMState) {
                CMState other = (CMState)o;
                if (this.end == other.end && this.states.equals(other.states)) {
                    assert (this.state.length > 1 && other.state.length > 1);
                    if (this.state[0] == other.state[0] && this.state[1] == other.state[1]) {
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.end ? "F" : "N") + this.stateToString() + this.states.toString();
        }

        protected String stateToString() {
            StringBuffer s = new StringBuffer();
            s.append('(');
            int i = 0;
            while (i < this.state.length) {
                s.append(this.state[i]);
                if (i < this.state.length - 1) {
                    s.append(',');
                }
                ++i;
            }
            s.append(')');
            return s.toString();
        }

        public int hashCode() {
            return this.end ? this.states.hashCode() : -this.states.hashCode();
        }
    }
}

