/*
 * Copyright, 2009 Koichi Takahashi. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.nec.exi.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.siemens.ct.exi.CodingMode;

/**
 * @author Koichi Takahashi
 */
public class Activator extends AbstractUIPlugin {

	public static final String PLUGIN_ID = "com.nec.exi.editor"; //$NON-NLS-1$
	private static Activator plugin;
	public static final String CODING_MODE_N = "CodingMode"; //$NON-NLS-1$
	public static final String[][] CODING_MODE_NV
		= new String[][]{
			{Resources.get("Activator.1"), ""}, //$NON-NLS-1$ //$NON-NLS-2$
			{Resources.get("Activator.2"), CodingMode.BIT_PACKED.toString()}, //$NON-NLS-1$
			{Resources.get("Activator.3"), CodingMode.BYTE_PACKED.toString()}, //$NON-NLS-1$
			{Resources.get("Activator.4"), CodingMode.PRE_COMPRESSION.toString()}, //$NON-NLS-1$
			{Resources.get("Activator.5"), CodingMode.COMPRESSION.toString()} //$NON-NLS-1$
		};
	
	public Activator() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	public static Activator getDefault() {
		return plugin;
	}

	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
}
