/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.seasar.extension.jta.xa.XAResourceStatus;
import org.seasar.framework.exception.SXAException;

public abstract class AbstractXAResource
implements XAResource,
XAResourceStatus {
    private Xid currentXid_;
    private int status_ = 0;
    private int timeout_ = 0;

    public void start(Xid xid, int flags) throws XAException {
        switch (flags) {
            case 0: {
                this.begin(xid);
                break;
            }
            case 0x8000000: {
                this.resume(xid);
                break;
            }
            default: {
                throw new SXAException("ESSR0032", new Object[]{String.valueOf(flags)});
            }
        }
    }

    private void begin(Xid xid) throws XAException {
        this.assertCurrentXidNull();
        this.doBegin(xid);
        this.currentXid_ = xid;
        this.status_ = 1;
    }

    private void assertCurrentXidNull() throws XAException {
        if (this.currentXid_ != null) {
            throw new SXAException("ESSR0316", null);
        }
    }

    protected abstract void doBegin(Xid var1) throws XAException;

    private void resume(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuspended();
        this.doResume(xid);
        this.status_ = 1;
    }

    private void assertCurrentXidSame(Xid xid) throws XAException {
        if (this.currentXid_ != xid) {
            throw new SXAException("ESSR0319", new Object[]{xid, this.currentXid_});
        }
    }

    private void assertStatusSuspended() throws XAException {
        if (this.status_ != 2) {
            throw new SXAException("ESSR0323", null);
        }
    }

    protected abstract void doResume(Xid var1) throws XAException;

    public void end(Xid xid, int flags) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusActive();
        switch (flags) {
            case 0x2000000: {
                this.suspend(xid);
                break;
            }
            case 0x20000000: {
                this.fail(xid);
                break;
            }
            case 0x4000000: {
                this.success(xid);
                break;
            }
            default: {
                throw new SXAException("ESSR0032", new Object[]{String.valueOf(flags)});
            }
        }
    }

    private void assertStatusActive() throws XAException {
        if (this.status_ != 1) {
            throw new SXAException("ESSR0324", null);
        }
    }

    private void suspend(Xid xid) throws XAException {
        this.doSuspend(xid);
        this.status_ = 2;
    }

    protected abstract void doSuspend(Xid var1) throws XAException;

    private void fail(Xid xid) throws XAException {
        this.doFail(xid);
        this.status_ = 3;
    }

    protected abstract void doFail(Xid var1) throws XAException;

    private void success(Xid xid) throws XAException {
        this.doSuccess(xid);
        this.status_ = 4;
    }

    protected abstract void doSuccess(Xid var1) throws XAException;

    public int prepare(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuccess();
        int ret = this.doPrepare(xid);
        this.status_ = ret == 0 ? 5 : 0;
        return ret;
    }

    private void assertStatusSuccess() throws XAException {
        if (this.status_ != 4) {
            throw new SXAException("ESSR0320", null);
        }
    }

    protected abstract int doPrepare(Xid var1) throws XAException;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.assertCurrentXidSame(xid);
        if (onePhase) {
            this.assertStatusSuccess();
        } else {
            this.assertStatusPrepared();
        }
        this.doCommit(xid, onePhase);
        this.init();
    }

    private void assertStatusPrepared() throws XAException {
        if (this.status_ != 5) {
            throw new SXAException("ESSR0321", null);
        }
    }

    protected abstract void doCommit(Xid var1, boolean var2) throws XAException;

    private void init() {
        this.currentXid_ = null;
        this.status_ = 0;
    }

    public void forget(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.doForget(xid);
        this.init();
    }

    protected abstract void doForget(Xid var1) throws XAException;

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        this.assertCurrentXidSame(xid);
        this.assertStatusSuccessOrFailOrPrepared();
        this.doRollback(xid);
        this.init();
    }

    private void assertStatusSuccessOrFailOrPrepared() throws XAException {
        switch (this.status_) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new SXAException("ESSR0322", null);
            }
        }
    }

    protected abstract void doRollback(Xid var1) throws XAException;

    public boolean isSameRM(XAResource xar) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout_;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout_ = timeout;
        return true;
    }

    public Xid getCurrentXid() {
        return this.currentXid_;
    }

    public int getStatus() {
        return this.status_;
    }
}

