/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.MnemonicText;
import application.Resource;
import application.ResourceConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap {
    private static Logger logger;
    private static final Object nullResource;
    private final ClassLoader classLoader;
    private final ResourceMap parent;
    private final List<String> bundleNames;
    private final String resourcesDir;
    private Map<String, Object> bundlesMapP = null;
    private Set<String> bundlesMapKeysP = null;
    private boolean bundlesLoaded = false;

    public ResourceMap(ResourceMap parent, ClassLoader classLoader, List<String> bundleNames) {
        if (classLoader == null) {
            throw new IllegalArgumentException("null ClassLoader");
        }
        if (bundleNames == null || bundleNames.size() == 0) {
            throw new IllegalArgumentException("no bundle specified");
        }
        for (String bn : bundleNames) {
            if (bn != null && bn.length() != 0) continue;
            throw new IllegalArgumentException("invalid bundleName: \"" + bn + "\"");
        }
        String bpn = this.bundlePackageName(bundleNames.get(0));
        for (String bn : bundleNames) {
            if (bpn.equals(this.bundlePackageName(bn))) continue;
            throw new IllegalArgumentException("bundles not colocated: \"" + bn + "\" != \"" + bpn + "\"");
        }
        this.parent = parent;
        this.classLoader = classLoader;
        this.bundleNames = Collections.unmodifiableList(new ArrayList<String>(bundleNames));
        this.resourcesDir = bpn.replace(".", "/") + "/";
    }

    private String bundlePackageName(String bundleName) {
        int i = bundleName.lastIndexOf(".");
        return i == -1 ? "" : bundleName.substring(0, i);
    }

    public ResourceMap(ResourceMap parent, ClassLoader classLoader, String ... bundleNames) {
        this(parent, classLoader, Arrays.asList(bundleNames));
    }

    public ResourceMap getParent() {
        return this.parent;
    }

    public List<String> getBundleNames() {
        return this.bundleNames;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getResourcesDir() {
        return this.resourcesDir;
    }

    private synchronized Map<String, Object> getBundlesMap() {
        if (!this.bundlesLoaded) {
            ConcurrentHashMap<String, Object> bundlesMap = new ConcurrentHashMap<String, Object>();
            for (int i = this.bundleNames.size() - 1; i >= 0; --i) {
                try {
                    Locale locale = Locale.getDefault();
                    String bundleName = this.bundleNames.get(i);
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, this.classLoader);
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        bundlesMap.put(key, bundle.getObject(key));
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.bundlesMapP = bundlesMap;
            this.bundlesLoaded = true;
        }
        return this.bundlesMapP;
    }

    private void checkNullKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
    }

    private synchronized Set<String> getBundlesMapKeys() {
        if (this.bundlesMapKeysP == null) {
            HashSet<String> allKeys = new HashSet<String>(this.getResourceKeySet());
            ResourceMap parent = this.getParent();
            if (parent != null) {
                allKeys.addAll(parent.keySet());
            }
            this.bundlesMapKeysP = Collections.unmodifiableSet(allKeys);
        }
        return this.bundlesMapKeysP;
    }

    public Set<String> keySet() {
        return this.getBundlesMapKeys();
    }

    public boolean containsKey(String key) {
        this.checkNullKey(key);
        if (this.containsResourceKey(key)) {
            return true;
        }
        ResourceMap parent = this.getParent();
        return parent != null ? parent.containsKey(key) : false;
    }

    protected Set<String> getResourceKeySet() {
        Map<String, Object> bundlesMap = this.getBundlesMap();
        if (bundlesMap == null) {
            return Collections.emptySet();
        }
        return bundlesMap.keySet();
    }

    protected boolean containsResourceKey(String key) {
        this.checkNullKey(key);
        Map<String, Object> bundlesMap = this.getBundlesMap();
        return bundlesMap != null && bundlesMap.containsKey(key);
    }

    protected Object getResource(String key) {
        this.checkNullKey(key);
        Map<String, Object> bundlesMap = this.getBundlesMap();
        Object value = bundlesMap != null ? bundlesMap.get(key) : null;
        return value == nullResource ? null : value;
    }

    protected void putResource(String key, Object value) {
        this.checkNullKey(key);
        Map<String, Object> bundlesMap = this.getBundlesMap();
        if (bundlesMap != null) {
            bundlesMap.put(key, value == null ? nullResource : value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(String key, Class type) {
        ResourceMap resourceMapNode;
        this.checkNullKey(key);
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        Object value = null;
        for (resourceMapNode = this; resourceMapNode != null; resourceMapNode = resourceMapNode.getParent()) {
            if (!resourceMapNode.containsResourceKey(key)) continue;
            value = resourceMapNode.getResource(key);
            break;
        }
        if (value instanceof String && ((String)value).contains("${")) {
            value = this.evaluateStringExpression((String)value);
            resourceMapNode.putResource(key, value);
        }
        if (value == null) return value;
        Class<?> valueClass = value.getClass();
        if (type.isAssignableFrom(valueClass)) return value;
        if (!(value instanceof String)) {
            String msg = "named resource has wrong type";
            throw new LookupException(msg, key, type);
        }
        ResourceConverter stringConverter = ResourceConverter.forType(type);
        if (stringConverter == null) {
            String msg = "no StringConverter for required type";
            throw new LookupException(msg, key, type);
        }
        String sValue = (String)value;
        try {
            value = stringConverter.parseString(sValue, resourceMapNode);
            resourceMapNode.putResource(key, value);
            return value;
        }
        catch (ResourceConverter.ResourceConverterException e) {
            String msg = "string conversion failed";
            LookupException lfe = new LookupException(msg, key, type);
            lfe.initCause(e);
            throw lfe;
        }
    }

    private String evaluateStringExpression(String expr) {
        if (expr.trim().equals("${null}")) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        int i0 = 0;
        int i1 = 0;
        while ((i1 = expr.indexOf("${", i0)) != -1) {
            if (i1 == 0 || i1 > 0 && expr.charAt(i1 - 1) != '\\') {
                int i2 = expr.indexOf("}", i1);
                if (i2 != -1 && i2 > i1 + 2) {
                    String k = expr.substring(i1 + 2, i2);
                    String v = this.getString(k, new Object[0]);
                    value.append(expr.substring(i0, i1));
                    if (v == null) {
                        String msg = String.format("no value for \"%s\" in \"%s\"", k, expr);
                        throw new LookupException(msg, k, String.class);
                    }
                    value.append(v);
                    i0 = i2 + 1;
                    continue;
                }
                String msg = String.format("no closing brace in \"%s\"", expr);
                throw new LookupException(msg, "<not found>", String.class);
            }
            value.append(expr.substring(i0, i1 - 1));
            value.append("${");
            i0 = i1 + 2;
        }
        value.append(expr.substring(i0));
        return value.toString();
    }

    public String getString(String key, Object ... args) {
        if (args.length == 0) {
            return (String)this.getObject(key, String.class);
        }
        String format = (String)this.getObject(key, String.class);
        return format == null ? null : String.format(format, args);
    }

    public final Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key, Boolean.class);
    }

    public final Integer getInteger(String key) {
        return (Integer)this.getObject(key, Integer.class);
    }

    public final Long getLong(String key) {
        return (Long)this.getObject(key, Long.class);
    }

    public final Short getShort(String key) {
        return (Short)this.getObject(key, Short.class);
    }

    public final Byte getByte(String key) {
        return (Byte)this.getObject(key, Byte.class);
    }

    public final Float getFloat(String key) {
        return (Float)this.getObject(key, Float.class);
    }

    public final Double getDouble(String key) {
        return (Double)this.getObject(key, Double.class);
    }

    public final Icon getIcon(String key) {
        return (Icon)this.getObject(key, Icon.class);
    }

    public final ImageIcon getImageIcon(String key) {
        return (ImageIcon)this.getObject(key, ImageIcon.class);
    }

    public final Font getFont(String key) {
        return (Font)this.getObject(key, Font.class);
    }

    public final Color getColor(String key) {
        return (Color)this.getObject(key, Color.class);
    }

    public final KeyStroke getKeyStroke(String key) {
        return (KeyStroke)this.getObject(key, KeyStroke.class);
    }

    public Integer getKeyCode(String key) {
        KeyStroke ks = this.getKeyStroke(key);
        return ks != null ? new Integer(ks.getKeyCode()) : null;
    }

    private void injectComponentProperty(Component component, PropertyDescriptor pd, String key) {
        Method setter = pd.getWriteMethod();
        Class<?> type = pd.getPropertyType();
        if (setter != null && type != null && this.containsKey(key)) {
            Object value = this.getObject(key, type);
            String propertyName = pd.getName();
            try {
                if ("text".equals(propertyName) && component instanceof AbstractButton) {
                    MnemonicText.configure(component, (String)value);
                }
                if ("text".equals(propertyName) && component instanceof JLabel) {
                    MnemonicText.configure(component, (String)value);
                }
                setter.invoke((Object)component, value);
            }
            catch (Exception e) {
                String pdn = pd.getName();
                String msg = "property setter failed";
                PropertyInjectionException re = new PropertyInjectionException(msg, key, component, pdn);
                re.initCause(e);
                throw re;
            }
        } else {
            if (type != null) {
                String pdn = pd.getName();
                String msg = "no value specified for resource";
                throw new PropertyInjectionException(msg, key, component, pdn);
            }
            if (setter == null) {
                String pdn = pd.getName();
                String msg = "can't set read-only property";
                throw new PropertyInjectionException(msg, key, component, pdn);
            }
        }
    }

    private void injectComponentProperties(Component component) {
        String componentName = component.getName();
        if (componentName != null) {
            boolean matchingResourceFound = false;
            for (String key : this.keySet()) {
                int i = key.lastIndexOf(".");
                if (i == -1 || !componentName.equals(key.substring(0, i))) continue;
                matchingResourceFound = true;
                break;
            }
            if (!matchingResourceFound) {
                return;
            }
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(component.getClass());
            }
            catch (IntrospectionException e) {
                String msg = "introspection failed";
                PropertyInjectionException re = new PropertyInjectionException(msg, null, component, null);
                re.initCause(e);
                throw re;
            }
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            if (pds != null || pds.length > 0) {
                for (String key : this.keySet()) {
                    int i = key.lastIndexOf(".");
                    String keyComponentName = i == -1 ? null : key.substring(0, i);
                    if (!componentName.equals(keyComponentName)) continue;
                    if (i + 1 == key.length()) {
                        String msg = "component resource lacks property name suffix";
                        logger.warning(msg);
                        break;
                    }
                    String propertyName = key.substring(i + 1);
                    boolean matchingPropertyFound = false;
                    for (PropertyDescriptor pd : pds) {
                        if (!pd.getName().equals(propertyName)) continue;
                        this.injectComponentProperty(component, pd, key);
                        matchingPropertyFound = true;
                        break;
                    }
                    if (matchingPropertyFound) continue;
                    String msg = String.format("[resource %s] component named %s doesn't have a property named %s", key, componentName, propertyName);
                    logger.warning(msg);
                }
            }
        }
    }

    public void injectComponent(Component target) {
        if (target == null) {
            throw new IllegalArgumentException("null target");
        }
        this.injectComponentProperties(target);
    }

    public void injectComponents(Component root) {
        block3: {
            block2: {
                this.injectComponent(root);
                if (!(root instanceof JMenu)) break block2;
                JMenu menu = (JMenu)root;
                for (Component child : menu.getMenuComponents()) {
                    this.injectComponents(child);
                }
                break block3;
            }
            if (!(root instanceof Container)) break block3;
            Container container = (Container)root;
            for (Component child : container.getComponents()) {
                this.injectComponents(child);
            }
        }
    }

    private void injectField(Field field, Object target, String key) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            type = type.getComponentType();
            Pattern p = Pattern.compile(key + "\\[([\\d]+)\\]");
            ArrayList arrayKeys = new ArrayList();
            for (String arrayElementKey : this.keySet()) {
                Matcher m = p.matcher(arrayElementKey);
                if (!m.matches()) continue;
                Object value = this.getObject(arrayElementKey, type);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    int index = Integer.parseInt(m.group(1));
                    Array.set(field.get(target), index, value);
                }
                catch (Exception e) {
                    String msg = "unable to set array element";
                    InjectFieldException ife = new InjectFieldException(msg, field, target, key);
                    ife.initCause(e);
                    throw ife;
                }
            }
        } else {
            Object value = this.getObject(key, type);
            if (value != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(target, value);
                }
                catch (Exception e) {
                    String msg = "unable to set field's value";
                    InjectFieldException ife = new InjectFieldException(msg, field, target, key);
                    ife.initCause(e);
                    throw ife;
                }
            }
        }
    }

    public void injectFields(Object target) {
        if (target == null) {
            throw new IllegalArgumentException("null target");
        }
        Class<?> targetType = target.getClass();
        if (targetType.isArray()) {
            throw new IllegalArgumentException("array target");
        }
        String keyPrefix = targetType.getSimpleName() + ".";
        for (Field field : targetType.getDeclaredFields()) {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource == null) continue;
            String rKey = resource.key();
            String key = rKey.length() > 0 ? rKey : keyPrefix + field.getName();
            this.injectField(field, target, key);
        }
    }

    private static String resourcePath(String path, ResourceMap resourceMap) {
        String rPath = path;
        rPath = path == null ? null : (path.startsWith("/") ? (path.length() > 1 ? path.substring(1) : null) : resourceMap.getResourcesDir() + path);
        return rPath;
    }

    private static ImageIcon loadImageIcon(String s, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
        String rPath = ResourceMap.resourcePath(s, resourceMap);
        if (rPath == null) {
            String msg = String.format("invalid image/icon path \"%s\"", s);
            throw new ResourceConverter.ResourceConverterException(msg, s);
        }
        URL url = resourceMap.getClassLoader().getResource(rPath);
        if (url != null) {
            return new ImageIcon(url);
        }
        String msg = String.format("couldn't find Icon resource \"%s\"", s);
        throw new ResourceConverter.ResourceConverterException(msg, s);
    }

    private static List<Double> parseDoubles(String s, int n, String errorMsg) throws ResourceConverter.ResourceConverterException {
        String[] doubleStrings = s.split(",", n + 1);
        if (doubleStrings.length != n) {
            throw new ResourceConverter.ResourceConverterException(errorMsg, s);
        }
        ArrayList<Double> doubles = new ArrayList<Double>(n);
        for (String doubleString : doubleStrings) {
            try {
                doubles.add(Double.valueOf(doubleString));
            }
            catch (NumberFormatException e) {
                throw new ResourceConverter.ResourceConverterException(errorMsg, s, e);
            }
        }
        return doubles;
    }

    static {
        ResourceConverter[] stringConverters;
        logger = Logger.getLogger(ResourceMap.class.getName());
        nullResource = new String("null resource");
        for (ResourceConverter sc : stringConverters = new ResourceConverter[]{new ColorStringConverter(), new IconStringConverter(), new ImageStringConverter(), new FontStringConverter(), new KeyStrokeStringConverter(), new DimensionStringConverter(), new PointStringConverter(), new RectangleStringConverter(), new InsetsStringConverter(), new EmptyBorderStringConverter()}) {
            ResourceConverter.register(sc);
        }
    }

    private static class EmptyBorderStringConverter
    extends ResourceConverter {
        EmptyBorderStringConverter() {
            super(EmptyBorder.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            List tlbr = ResourceMap.parseDoubles(s, 4, "invalid top,left,bottom,right EmptyBorder string");
            return new EmptyBorder(((Double)tlbr.get(0)).intValue(), ((Double)tlbr.get(1)).intValue(), ((Double)tlbr.get(2)).intValue(), ((Double)tlbr.get(3)).intValue());
        }
    }

    private static class InsetsStringConverter
    extends ResourceConverter {
        InsetsStringConverter() {
            super(Insets.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            List tlbr = ResourceMap.parseDoubles(s, 4, "invalid top,left,bottom,right Insets string");
            return new Insets(((Double)tlbr.get(0)).intValue(), ((Double)tlbr.get(1)).intValue(), ((Double)tlbr.get(2)).intValue(), ((Double)tlbr.get(3)).intValue());
        }
    }

    private static class RectangleStringConverter
    extends ResourceConverter {
        RectangleStringConverter() {
            super(Rectangle.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            List xywh = ResourceMap.parseDoubles(s, 4, "invalid x,y,width,height Rectangle string");
            Rectangle r = new Rectangle();
            r.setFrame((Double)xywh.get(0), (Double)xywh.get(1), (Double)xywh.get(2), (Double)xywh.get(3));
            return r;
        }
    }

    private static class PointStringConverter
    extends ResourceConverter {
        PointStringConverter() {
            super(Point.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            List xy = ResourceMap.parseDoubles(s, 2, "invalid x,y Point string");
            Point p = new Point();
            p.setLocation((Double)xy.get(0), (Double)xy.get(1));
            return p;
        }
    }

    private static class DimensionStringConverter
    extends ResourceConverter {
        DimensionStringConverter() {
            super(Dimension.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            List xy = ResourceMap.parseDoubles(s, 2, "invalid x,y Dimension string");
            Dimension d = new Dimension();
            d.setSize((Double)xy.get(0), (Double)xy.get(1));
            return d;
        }
    }

    private static class KeyStrokeStringConverter
    extends ResourceConverter {
        KeyStrokeStringConverter() {
            super(KeyStroke.class);
        }

        public Object parseString(String s, ResourceMap ignore) {
            if (s.contains("shortcut")) {
                int k = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                s = s.replaceAll("shortcut", k == 4 ? "meta" : "control");
            }
            return KeyStroke.getKeyStroke(s);
        }
    }

    private static class ImageStringConverter
    extends ResourceConverter {
        ImageStringConverter() {
            super(Image.class);
        }

        public Object parseString(String s, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            return ResourceMap.loadImageIcon(s, resourceMap).getImage();
        }
    }

    private static class IconStringConverter
    extends ResourceConverter {
        IconStringConverter() {
            super(Icon.class);
        }

        public Object parseString(String s, ResourceMap resourceMap) throws ResourceConverter.ResourceConverterException {
            return ResourceMap.loadImageIcon(s, resourceMap);
        }

        public boolean supportsType(Class testType) {
            return testType.equals(Icon.class) || testType.equals(ImageIcon.class);
        }
    }

    private static class ColorStringConverter
    extends ResourceConverter {
        ColorStringConverter() {
            super(Color.class);
        }

        private void error(String msg, String s, Exception e) throws ResourceConverter.ResourceConverterException {
            throw new ResourceConverter.ResourceConverterException(msg, s, e);
        }

        private void error(String msg, String s) throws ResourceConverter.ResourceConverterException {
            this.error(msg, s, null);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            Color color = null;
            if (s.startsWith("#")) {
                switch (s.length()) {
                    case 7: {
                        color = Color.decode(s);
                        break;
                    }
                    case 9: {
                        int alpha = Integer.decode(s.substring(0, 3));
                        int rgb = Integer.decode("#" + s.substring(3));
                        color = new Color(alpha << 24 | rgb, true);
                        break;
                    }
                    default: {
                        throw new ResourceConverter.ResourceConverterException("invalid #RRGGBB or #AARRGGBB color string", s);
                    }
                }
            } else {
                String[] parts = s.split(",");
                if (parts.length < 3 || parts.length > 4) {
                    throw new ResourceConverter.ResourceConverterException("invalid R, G, B[, A] color string", s);
                }
                try {
                    if (parts.length == 4) {
                        int r = Integer.parseInt(parts[0].trim());
                        int g = Integer.parseInt(parts[1].trim());
                        int b = Integer.parseInt(parts[2].trim());
                        int a = Integer.parseInt(parts[3].trim());
                        color = new Color(r, g, b, a);
                    } else {
                        int r = Integer.parseInt(parts[0].trim());
                        int g = Integer.parseInt(parts[1].trim());
                        int b = Integer.parseInt(parts[2].trim());
                        color = new Color(r, g, b);
                    }
                }
                catch (NumberFormatException e) {
                    throw new ResourceConverter.ResourceConverterException("invalid R, G, B[, A] color string", s, e);
                }
            }
            return color;
        }
    }

    private static class FontStringConverter
    extends ResourceConverter {
        FontStringConverter() {
            super(Font.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverter.ResourceConverterException {
            return Font.decode(s);
        }
    }

    public static class InjectFieldException
    extends RuntimeException {
        private final Field field;
        private final Object target;
        private final String key;

        public InjectFieldException(String msg, Field field, Object target, String key) {
            super(String.format("%s: resource %s, field %s, target %s", msg, key, field, target));
            this.field = field;
            this.target = target;
            this.key = key;
        }

        public Field getField() {
            return this.field;
        }

        public Object getTarget() {
            return this.target;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class PropertyInjectionException
    extends RuntimeException {
        private final String key;
        private final Component component;
        private final String propertyName;

        public PropertyInjectionException(String msg, String key, Component component, String propertyName) {
            super(String.format("%s: resource %s, property %s, component %s", msg, key, propertyName, component));
            this.key = key;
            this.component = component;
            this.propertyName = propertyName;
        }

        public String getKey() {
            return this.key;
        }

        public Component getComponent() {
            return this.component;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class LookupException
    extends RuntimeException {
        private final Class type;
        private final String key;

        public LookupException(String msg, String key, Class type) {
            super(String.format("%s: resource %s, type %s", msg, key, type));
            this.key = key;
            this.type = type;
        }

        public Class getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }
    }
}

