/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataHolderPropertyEditor;
import jp.gr.javacons.jim.PropertyCanvas;
import jp.gr.javacons.jim.PropertyDialog;
import jp.gr.javacons.jim.PropertySelector;
import jp.gr.javacons.jim.PropertyText;
import jp.gr.javacons.jim.Utility;

class PropertyListPanelForDataHolder
extends Panel {
    private static final long serialVersionUID = 1239183728480515111L;
    private static final String[] notPropertyNames = new String[]{"dataHolderName", "dataProvider", "valueClass"};
    private Object target;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private Button[] buttons;
    private Label[] labels;
    private Frame frame;
    private static final int hPad = 4;
    private static final int vPad = 2;

    public PropertyListPanelForDataHolder() {
        this.setLayout(null);
    }

    public void doLayout() {
        this.doLayout(false);
    }

    private void doLayout(boolean doSetSize) {
        if (this.views == null || this.labels == null) {
            return;
        }
        int labelWidth = 100;
        int viewWidth = 150;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.labels[i] == null || this.views[i] == null) continue;
            int w = this.labels[i].getPreferredSize().width;
            if (w > labelWidth) {
                labelWidth = w;
            }
            if ((w = this.views[i].getPreferredSize().width) <= viewWidth) continue;
            viewWidth = w;
        }
        int width = 12 + labelWidth + viewWidth;
        int y = 10;
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.labels[i] == null || this.views[i] == null) continue;
            this.labels[i].setBounds(4, y, labelWidth, 25);
            Dimension viewSize = this.views[i].getPreferredSize();
            int h = viewSize.height;
            if (h < 25) {
                h = 25;
            }
            if (this.views[i] instanceof PropertyCanvas && this.buttons[i] != null) {
                this.buttons[i].setBounds(labelWidth + 8, y + 1, 15, h - 2);
                this.views[i].setBounds(labelWidth + 8 + 15, y, viewWidth - 15, h);
            } else {
                this.views[i].setBounds(labelWidth + 8, y, viewWidth, h);
            }
            y += h + 2;
        }
        y += 2;
        if (doSetSize) {
            this.setSize(width, y);
        }
    }

    private void error(String message, Throwable th) {
        String mess = message + ":\n" + th;
        System.err.println(message);
        th.printStackTrace();
        Utility.showMessage(Utility.getRootFrame(this), "Error: " + mess);
    }

    private Frame getFrame() {
        if (this.frame == null) {
            this.frame = Utility.getRootFrame(this);
        }
        return this.frame;
    }

    public static void main(String[] argv) {
        PropertyListPanelForDataHolder p = new PropertyListPanelForDataHolder();
        class MyDataHolder
        extends DataHolder {
            private static final long serialVersionUID = 543561926557063907L;
            Color color = Color.red;
            String string = "";
            int count = 1;

            MyDataHolder() {
            }

            public Color getColor() {
                return this.color;
            }

            public void setColor(Color c) {
                this.color = c;
            }

            public String getString() {
                return this.string;
            }

            public void setString(String s) {
                this.string = s;
            }

            public int getCount() {
                return this.count;
            }

            public void setCount(int c) {
                this.count = c;
            }
        }
        MyDataHolder dh = new MyDataHolder();
        final Frame f = new Frame();
        f.setSize(200, 500);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.dispose();
                System.exit(0);
            }
        });
        f.add(p);
        p.setTarget(dh);
        f.setVisible(true);
    }

    public synchronized void setTarget(DataHolder dhBean) {
        if (dhBean == this.target) {
            return;
        }
        this.removeAll();
        if (this.target != null) {
            this.setVisible(false);
        }
        this.target = dhBean;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.target.getClass());
            this.properties = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            this.error("DataHolderPropertyListPanel: Couldn't introspect", ex);
            return;
        }
        this.editors = new PropertyEditor[this.properties.length];
        this.values = new Object[this.properties.length];
        this.views = new Component[this.properties.length];
        this.labels = new Label[this.properties.length];
        this.buttons = new Button[this.properties.length];
        PropertyChangeListener adaptor = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PropertyListPanelForDataHolder.this.wasModified(evt);
            }
        };
        for (int i = 0; i < this.properties.length; ++i) {
            Component view;
            String name;
            block23: {
                if (this.properties[i].isHidden() || this.properties[i].isExpert()) continue;
                name = this.properties[i].getDisplayName();
                Class<?> type = this.properties[i].getPropertyType();
                Method getter = this.properties[i].getReadMethod();
                Method setter = this.properties[i].getWriteMethod();
                boolean flag = true;
                for (int ii = 0; ii < notPropertyNames.length; ++ii) {
                    if (!notPropertyNames[ii].equals(name)) continue;
                    flag = false;
                    break;
                }
                if (!flag || getter == null || setter == null) continue;
                view = null;
                try {
                    String getterClass;
                    Object value;
                    Object[] args = new Object[]{};
                    this.values[i] = value = getter.invoke(this.target, args);
                    PropertyEditor editor = null;
                    Class<?> pec = this.properties[i].getPropertyEditorClass();
                    if (pec != null) {
                        try {
                            editor = (PropertyEditor)pec.newInstance();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (editor == null) {
                        editor = PropertyEditorManager.findEditor(type);
                    }
                    if (editor instanceof DataHolderPropertyEditor) {
                        ((DataHolderPropertyEditor)((Object)editor)).setDataHolder(dhBean);
                    }
                    this.editors[i] = editor;
                    if (editor == null) {
                        getterClass = this.properties[i].getReadMethod().getDeclaringClass().getName();
                        if (getterClass.indexOf("java.") == 0) continue;
                        System.err.println("Warning: Can't find public property editor for DataHolder property \"" + name + "\".  Skipping.");
                        continue;
                    }
                    if (value == null && (getterClass = this.properties[i].getReadMethod().getDeclaringClass().getName()).indexOf("java.") != 0) {
                        try {
                            value = type.newInstance();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (value == null) {
                            System.err.println("Warning: DataHolder Property \"" + name + "\" has null initial value and tried to create an initial value by newInstance(). But failed, so skipping.");
                            continue;
                        }
                    }
                    editor.setValue(value);
                    editor.addPropertyChangeListener(adaptor);
                    if (editor.isPaintable() && editor.supportsCustomEditor()) {
                        view = new PropertyCanvas(editor);
                        final Button b = new Button();
                        final PropertyEditor ed = editor;
                        b.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ev) {
                                int x = ((PropertyListPanelForDataHolder)PropertyListPanelForDataHolder.this).getFrame().getLocation().x - 30;
                                int y = ((PropertyListPanelForDataHolder)PropertyListPanelForDataHolder.this).getFrame().getLocation().y + 50;
                                new PropertyDialog(PropertyListPanelForDataHolder.this.getFrame(), ed, x, y);
                                b.requestFocus();
                            }
                        });
                        b.setLabel(" ");
                        this.buttons[i] = b;
                        break block23;
                    }
                    if (editor.getTags() != null) {
                        view = new PropertySelector(editor);
                        break block23;
                    }
                    if (editor.getAsText() != null) {
                        view = new PropertyText(editor);
                        break block23;
                    }
                    System.err.println("Warning: DataHolder Property \"" + name + "\" has non-displayabale editor.  Skipping.");
                }
                catch (InvocationTargetException ex) {
                    System.err.println("Skipping DataHolder property " + name + " ; exception on target: " + ex.getTargetException());
                    ex.getTargetException().printStackTrace();
                }
                catch (Exception ex) {
                    System.err.println("Skipping DataHolder property " + name + " ; exception: " + ex);
                    ex.printStackTrace();
                }
                continue;
            }
            this.labels[i] = new Label(name, 2);
            this.add(this.labels[i]);
            this.views[i] = view;
            if (this.buttons[i] != null) {
                this.add(this.buttons[i]);
            }
            this.add(this.views[i]);
        }
        this.doLayout(true);
        this.setVisible(true);
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            for (int i = 0; i < this.editors.length; ++i) {
                Object value;
                if (this.editors[i] != editor) continue;
                PropertyDescriptor property = this.properties[i];
                this.values[i] = value = editor.getValue();
                Method setter = property.getWriteMethod();
                try {
                    Object[] args = new Object[]{value};
                    setter.invoke(this.target, args);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof PropertyVetoException) {
                        System.err.println("WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage());
                    } else {
                        ex.printStackTrace();
                        this.error("InvocationTargetException while updating " + property.getName(), ex.getTargetException());
                    }
                }
                catch (Exception ex) {
                    this.error("Unexpected exception while updating " + property.getName(), ex);
                }
                if (this.views[i] == null || !(this.views[i] instanceof PropertyCanvas)) break;
                this.views[i].repaint();
                break;
            }
        }
        for (int i = 0; i < this.properties.length; ++i) {
            Object o;
            try {
                Method getter = this.properties[i].getReadMethod();
                Object[] args = new Object[]{};
                o = getter.invoke(this.target, args);
            }
            catch (Exception ex) {
                o = null;
            }
            if (o == this.values[i] || o != null && o.equals(this.values[i])) continue;
            this.values[i] = o;
            if (this.editors[i] == null) continue;
            this.editors[i].setValue(o);
            if (this.views[i] == null) continue;
            this.views[i].repaint();
        }
        if (Beans.isInstanceOf(this.target, Component.class)) {
            ((Component)Beans.getInstanceOf(this.target, Component.class)).repaint();
        }
    }
}

