/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.cyclicread;

import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jimx.cyclicread.CyclicReadRequestorEditor;
import jp.gr.javacons.jimx.cyclicread.Utility;

class EditorPanel
extends Panel {
    private static final long serialVersionUID = 6344578684061837473L;
    private CyclicReadRequestorEditor editor;
    private Vector providerNames;
    private int selectedIndex;
    private Vector existingPNames;
    private Choice providerChoice;
    private List sourceList;
    private List targetList;
    private Vector targetDHNames;
    private Button addOneButton;
    private Button addAllButton;
    private Button removeOneButton;
    private Button removeAllButton;
    private Button upButton;
    private Button downButton;

    public EditorPanel(CyclicReadRequestorEditor ed) {
        this.editor = ed;
        this.prepareGUI();
        this.setProviderNames();
    }

    void addAllItems() {
        String[] items = this.sourceList.getItems();
        this.sourceList.removeAll();
        int index = this.targetList.getSelectedIndex() + 1;
        for (int i = items.length - 1; i >= 0; --i) {
            this.targetList.add(items[i], index);
            this.targetDHNames.insertElementAt(items[i], index);
        }
        this.targetList.select(index);
        this.storeDataHolders();
        this.updateProviderChoice();
    }

    void addItem() {
        int index = this.sourceList.getSelectedIndex();
        if (index >= 0) {
            String item = this.sourceList.getItem(index);
            this.sourceList.remove(index);
            int i = this.sourceList.getItemCount();
            if (index < i) {
                this.sourceList.select(index);
            } else {
                this.sourceList.select(i - 1);
            }
            index = this.targetList.getSelectedIndex() + 1;
            this.targetList.add(item, index);
            this.targetList.select(index);
            this.targetDHNames.insertElementAt(item, index);
            this.storeDataHolders();
            this.updateProviderChoice();
        }
    }

    void downItem() {
        int index = this.targetList.getSelectedIndex();
        if (index >= 0 && index < this.targetList.getItemCount() - 1) {
            String old = this.targetList.getItem(index);
            this.targetList.replaceItem(this.targetList.getItem(index + 1), index);
            this.targetList.replaceItem(old, index + 1);
            this.targetList.select(index + 1);
            old = (String)this.targetDHNames.elementAt(index);
            this.targetDHNames.setElementAt(this.targetDHNames.elementAt(index + 1), index);
            this.targetDHNames.setElementAt(old, index + 1);
            this.storeDataHolders();
        }
    }

    void prepareGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        Panel p = new Panel(new FlowLayout(0));
        Label l = new Label("DataProvider ", 2);
        p.add(l);
        this.providerChoice = new Choice();
        this.providerChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int selix = ((Choice)e.getSource()).getSelectedIndex();
                if (EditorPanel.this.selectedIndex != selix) {
                    EditorPanel.this.selectedIndex = selix;
                    EditorPanel.this.updateDataHolderLists();
                }
            }
        });
        p.add(this.providerChoice);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 17;
        c.insets = new Insets(10, 5, 5, 0);
        gbl.setConstraints(p, c);
        this.add(p);
        this.sourceList = new List(10);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 20, 10, 5);
        gbl.setConstraints(this.sourceList, c);
        this.add(this.sourceList);
        GridBagLayout gbl2 = new GridBagLayout();
        p = new Panel(gbl2);
        c.gridx = 0;
        c.gridy = -1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.addOneButton = new Button(">");
        this.addOneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.addItem();
            }
        });
        c.anchor = 15;
        gbl2.setConstraints(this.addOneButton, c);
        p.add(this.addOneButton);
        this.addAllButton = new Button(">>");
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.addAllItems();
            }
        });
        c.anchor = 11;
        gbl2.setConstraints(this.addAllButton, c);
        p.add(this.addAllButton);
        this.removeOneButton = new Button("<");
        this.removeOneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.removeItem();
            }
        });
        c.anchor = 15;
        gbl2.setConstraints(this.removeOneButton, c);
        p.add(this.removeOneButton);
        this.removeAllButton = new Button("<<");
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.removeAllItems();
            }
        });
        c.anchor = 11;
        gbl2.setConstraints(this.removeAllButton, c);
        p.add(this.removeAllButton);
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.insets = new Insets(5, 0, 10, 0);
        gbl.setConstraints(p, c);
        this.add(p);
        this.targetList = new List(10);
        c.gridx = 2;
        c.gridy = 1;
        c.gridheight = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 10, 20);
        gbl.setConstraints(this.targetList, c);
        this.add(this.targetList);
        p = new Panel(new FlowLayout(1));
        this.upButton = new Button("Up");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.upItem();
            }
        });
        p.add(this.upButton);
        this.downButton = new Button("Down");
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.downItem();
            }
        });
        p.add(this.downButton);
        c.gridy = 5;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 10, 20);
        gbl.setConstraints(p, c);
        this.add(p);
    }

    void removeAllItems() {
        this.targetList.removeAll();
        for (int i = 0; i < this.targetDHNames.size(); ++i) {
            this.sourceList.add((String)this.targetDHNames.elementAt(i));
        }
        this.targetDHNames = new Vector();
        String[] items = this.sourceList.getItems();
        this.updateSourceList(items, "");
        this.storeDataHolders();
        this.updateProviderChoice();
    }

    void removeItem() {
        int index = this.targetList.getSelectedIndex();
        if (index >= 0) {
            String item = (String)this.targetDHNames.elementAt(index);
            this.targetList.remove(index);
            this.targetDHNames.removeElementAt(index);
            this.targetList.select(index);
            this.sourceList.add(item);
            String[] items = this.sourceList.getItems();
            this.updateSourceList(items, item);
            this.storeDataHolders();
            if (this.targetList.getItemCount() == 0) {
                this.updateProviderChoice();
            }
        }
    }

    void setProviderNames() {
        DataProvider[] dps = Manager.getInstance().getDataProviders();
        int size = dps.length;
        this.existingPNames = new Vector();
        for (int i = 0; i < size; ++i) {
            this.existingPNames.addElement(dps[i].getDataProviderName());
        }
        this.providerNames = new Vector();
        Enumeration<Object> e = this.editor.holders.keys();
        while (e.hasMoreElements()) {
            this.providerNames.addElement(e.nextElement());
        }
        e = this.existingPNames.elements();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            if (this.providerNames.contains(str)) continue;
            this.providerNames.addElement(str);
        }
        this.updateProviderChoice();
        if (this.providerNames.size() > 0) {
            this.selectedIndex = 0;
            this.updateDataHolderLists();
        }
    }

    void storeDataHolders() {
        if (this.providerNames.size() == 0) {
            return;
        }
        String providerName = (String)this.providerNames.elementAt(this.selectedIndex);
        if (this.targetDHNames.size() == 0) {
            this.editor.holders.remove(providerName);
            return;
        }
        Vector v = (Vector)this.editor.holders.get(providerName);
        if (v == null) {
            v = new Vector();
        } else {
            v.removeAllElements();
        }
        for (int i = 0; i < this.targetDHNames.size(); ++i) {
            v.addElement(this.targetDHNames.elementAt(i));
        }
        this.editor.holders.put(providerName, v);
        this.editor.firePropertyChange();
    }

    void updateDataHolderLists() {
        Vector v;
        String providerName = (String)this.providerNames.elementAt(this.selectedIndex);
        DataProvider dp = Manager.getInstance().getDataProvider(providerName);
        Vector<String> dhNames = new Vector<String>();
        if (dp != null) {
            DataHolder[] dhs = dp.getDataHolders();
            for (int i = 0; i < dhs.length; ++i) {
                dhNames.addElement(dhs[i].getDataHolderName());
            }
        }
        if ((v = (Vector)this.editor.holders.get(providerName)) == null) {
            v = new Vector();
        }
        Vector source = new Vector();
        for (int i = 0; i < dhNames.size(); ++i) {
            if (v.contains(dhNames.elementAt(i))) continue;
            source.addElement(dhNames.elementAt(i));
        }
        Object[] strs = new String[source.size()];
        source.copyInto(strs);
        this.updateSourceList((String[])strs, "");
        this.targetList.removeAll();
        this.targetDHNames = new Vector();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String orgStr = (String)e.nextElement();
            String str = orgStr;
            if (!dhNames.contains(str)) {
                str = str + " (Not Exists)";
            }
            this.targetList.add(str);
            this.targetDHNames.addElement(orgStr);
        }
    }

    void updateProviderChoice() {
        int index = this.providerChoice.getSelectedIndex();
        this.providerChoice.removeAll();
        for (int i = 0; i < this.providerNames.size(); ++i) {
            Vector dhns;
            String orgStr;
            String str = orgStr = (String)this.providerNames.elementAt(i);
            if (!this.existingPNames.contains(orgStr)) {
                str = str + " (Not Exists)";
            }
            if ((dhns = (Vector)this.editor.holders.get(orgStr)) != null && dhns.size() != 0) {
                str = "* " + str;
            }
            this.providerChoice.add(str);
        }
        if (index >= 0) {
            this.providerChoice.select(index);
        }
    }

    void updateSourceList(String[] items, String defaultName) {
        int i;
        items = Utility.sort(items);
        this.sourceList.removeAll();
        String providerName = (String)this.providerNames.elementAt(this.selectedIndex);
        DataProvider dp = Manager.getInstance().getDataProvider(providerName);
        Vector<String> dhNames = new Vector<String>();
        if (dp != null) {
            DataHolder[] dhs = dp.getDataHolders();
            for (i = 0; i < dhs.length; ++i) {
                dhNames.addElement(dhs[i].getDataHolderName());
            }
        }
        Vector<String> temp = new Vector<String>();
        for (i = 0; i < items.length; ++i) {
            if (!dhNames.contains(items[i])) continue;
            temp.addElement(items[i]);
        }
        String[] newItems = new String[temp.size()];
        for (int i2 = 0; i2 < newItems.length; ++i2) {
            newItems[i2] = (String)temp.elementAt(i2);
        }
        int index = 0;
        for (int i3 = 0; i3 < newItems.length; ++i3) {
            this.sourceList.add(newItems[i3]);
            if (!newItems[i3].equals(defaultName)) continue;
            index = i3;
        }
        this.sourceList.select(index);
    }

    void upItem() {
        int index = this.targetList.getSelectedIndex();
        if (index >= 1) {
            String old = this.targetList.getItem(index);
            this.targetList.replaceItem(this.targetList.getItem(index - 1), index);
            this.targetList.replaceItem(old, index - 1);
            this.targetList.select(index - 1);
            old = (String)this.targetDHNames.elementAt(index);
            this.targetDHNames.setElementAt(this.targetDHNames.elementAt(index - 1), index);
            this.targetDHNames.setElementAt(old, index - 1);
            this.storeDataHolders();
        }
    }
}

