/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class FieldDaoAnnotationReader
implements DaoAnnotationReader {
    public String BEAN = "BEAN";
    public String PROCEDURE_SUFFIX = "_PROCEDURE";
    public String ARGS_SUFFIX = "_ARGS";
    public String SQL_SUFFIX = "_SQL";
    public String QUERY_SUFFIX = "_QUERY";
    public String NO_PERSISTENT_PROPS_SUFFIX = "_NO_PERSISTENT_PROPS";
    public String PERSISTENT_PROPS_SUFFIX = "_PERSISTENT_PROPS";
    protected BeanDesc daoBeanDesc;

    public FieldDaoAnnotationReader(BeanDesc daoBeanDesc) {
        this.daoBeanDesc = daoBeanDesc;
    }

    public String[] getArgNames(Method method) {
        String argsKey = method.getName() + this.ARGS_SUFFIX;
        if (this.daoBeanDesc.hasField(argsKey)) {
            Field argNamesField = this.daoBeanDesc.getField(argsKey);
            String argNames = (String)FieldUtil.get((Field)argNamesField, null);
            return StringUtil.split((String)argNames, (String)" ,");
        }
        return new String[0];
    }

    public String getQuery(Method method) {
        String key = method.getName() + this.QUERY_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public String getStoredProcedureName(Method method) {
        String key = method.getName() + this.PROCEDURE_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public Class getBeanClass() {
        Field beanField = this.daoBeanDesc.getField(this.BEAN);
        return (Class)FieldUtil.get((Field)beanField, null);
    }

    public String[] getNoPersistentProps(Method method) {
        return this.getProps(method, method.getName() + this.NO_PERSISTENT_PROPS_SUFFIX);
    }

    public String[] getPersistentProps(Method method) {
        return this.getProps(method, method.getName() + this.PERSISTENT_PROPS_SUFFIX);
    }

    private String[] getProps(Method method, String fieldName) {
        if (this.daoBeanDesc.hasField(fieldName)) {
            Field field = this.daoBeanDesc.getField(fieldName);
            String s = (String)FieldUtil.get((Field)field, null);
            return StringUtil.split((String)s, (String)", ");
        }
        return null;
    }

    public String getSQL(Method method, String dbmsSuffix) {
        String key = method.getName() + dbmsSuffix + this.SQL_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        key = method.getName() + this.SQL_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }
}

