/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.util.Stack;
import org.seasar.dao.pager.PagerCondition;

class PagerContext {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new PagerContext();
        }
    };
    private Stack argsStack = new Stack();

    private PagerContext() {
    }

    public static PagerContext getContext() {
        return (PagerContext)threadLocal.get();
    }

    public void pushArgs(Object[] args) {
        this.argsStack.push(args);
    }

    public Object[] popArgs() {
        return (Object[])this.argsStack.pop();
    }

    public Object[] peekArgs() {
        if (this.argsStack.size() == 0) {
            return EMPTY_ARGS;
        }
        return (Object[])this.argsStack.peek();
    }

    public static boolean isPagerCondition(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof PagerCondition)) continue;
            return true;
        }
        return false;
    }

    public static PagerCondition getPagerCondition(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof PagerCondition)) continue;
            return (PagerCondition)arg;
        }
        return null;
    }
}

