/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import javax.servlet.ServletContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.DisposableUtil;

public final class SingletonS2ContainerFactory {
    private static String configPath = "app.dicon";
    private static ServletContext servletContext;
    private static S2Container container;

    private SingletonS2ContainerFactory() {
    }

    public static String getConfigPath() {
        return configPath;
    }

    public static void setConfigPath(String path) {
        configPath = path;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext context) {
        servletContext = context;
    }

    public static void init() {
        container = S2ContainerFactory.create(configPath);
        container.setServletContext(servletContext);
        container.init();
    }

    public static void destroy() {
        if (container == null) {
            return;
        }
        container.destroy();
        container = null;
        DisposableUtil.dispose();
    }

    public static S2Container getContainer() {
        if (container == null) {
            throw new EmptyRuntimeException("S2Container");
        }
        return container;
    }

    public static void setContainer(S2Container c) {
        container = c;
    }

    public static boolean hasContainer() {
        return container != null;
    }
}

