/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.co.frdm.Vamp.VampBundle;
import jp.co.frdm.Vamp.emulator.PlcControl;

public class EditMemoryPanel
extends JPanel {
    private PlcControl plc;
    private Frame parent;
    ButtonGroup btnGroup1 = new ButtonGroup();
    ButtonGroup btnGroup2 = new ButtonGroup();
    JPanel jPanel22 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JRadioButton decRadio = new JRadioButton();
    JPanel jPanel2 = new JPanel();
    JRadioButton hexRadio = new JRadioButton();
    JComboBox memoryKind = new JComboBox();
    JPanel jPanel1 = new JPanel();
    JButton writeButton = new JButton();
    JTextField inputData = new JTextField();
    JTextField memoryAddress = new JTextField();
    JLabel viewData = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel21 = new JPanel();
    JLabel jLabel5 = new JLabel();
    JRadioButton word2Radio = new JRadioButton();
    JRadioButton word1Radio = new JRadioButton();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel1 = new JLabel();
    GridLayout gridLayout2 = new GridLayout();
    JButton stepDecButton = new JButton();
    JButton decButton = new JButton();
    JButton incButton = new JButton();
    JButton stepIncButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    JPanel jPanel4 = new JPanel();
    JLabel jLabel4 = new JLabel();
    JLabel bitView3 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel bitView2 = new JLabel();
    JLabel bitView1 = new JLabel();
    JLabel bitView0 = new JLabel();
    JLabel jLabel11 = new JLabel();

    public EditMemoryPanel(Frame parent, PlcControl plc) {
        this.parent = parent;
        try {
            this.jbInit();
            this.plc = plc;
            List list = plc.getPlcMemNames();
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.memoryKind.addItem(it.next());
                }
            }
            this.word1Radio.setSelected(true);
            this.hexRadio.setSelected(true);
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.decRadio.setText("HEX");
        this.decRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.decRadio_actionPerformed(e);
            }
        });
        this.hexRadio.setText("BCD");
        this.hexRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.hexRadio_actionPerformed(e);
            }
        });
        this.memoryKind.setPreferredSize(new Dimension(70, 21));
        this.memoryKind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.memoryKind_actionPerformed(e);
            }
        });
        this.writeButton.setText(VampBundle.getString("commit"));
        this.inputData.setPreferredSize(new Dimension(80, 21));
        this.memoryAddress.setPreferredSize(new Dimension(64, 21));
        this.memoryAddress.setText("0");
        this.viewData.setBorder(BorderFactory.createLoweredBevelBorder());
        this.viewData.setPreferredSize(new Dimension(80, 21));
        this.gridLayout1.setRows(3);
        this.gridLayout1.setHgap(1);
        this.gridLayout1.setVgap(1);
        this.jLabel5.setText(VampBundle.getString("newvalue"));
        this.word2Radio.setText("2 W");
        this.word2Radio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.word2Radio_actionPerformed(e);
            }
        });
        this.word1Radio.setText("1 W");
        this.word1Radio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.word1Radio_actionPerformed(e);
            }
        });
        this.jLabel3.setText(VampBundle.getString("mem_type"));
        this.jLabel2.setText(VampBundle.getString("mem_value"));
        this.jLabel1.setText(VampBundle.getString("mem_add"));
        this.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(4);
        this.jPanel21.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel21.setLayout(this.flowLayout1);
        this.jPanel22.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel22.setLayout(this.flowLayout2);
        this.stepDecButton.setMargin(new Insets(0, 0, 0, 0));
        this.stepDecButton.setText("<<");
        this.stepDecButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.stepDecButton_actionPerformed(e);
            }
        });
        this.decButton.setPreferredSize(new Dimension(21, 23));
        this.decButton.setMargin(new Insets(0, 0, 0, 0));
        this.decButton.setText("<");
        this.decButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.decButton_actionPerformed(e);
            }
        });
        this.incButton.setPreferredSize(new Dimension(21, 23));
        this.incButton.setMargin(new Insets(0, 0, 0, 0));
        this.incButton.setText(">");
        this.incButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.incButton_actionPerformed(e);
            }
        });
        this.stepIncButton.setMargin(new Insets(0, 0, 0, 0));
        this.stepIncButton.setText(">>");
        this.stepIncButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.stepIncButton_actionPerformed(e);
            }
        });
        this.flowLayout1.setVgap(0);
        this.flowLayout2.setVgap(0);
        this.jLabel4.setText("15");
        this.bitView3.setBackground(Color.white);
        this.bitView3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bitView3.setOpaque(true);
        this.bitView3.setText("\u25a1\u25a1\u25a1\u25a1");
        this.bitView3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EditMemoryPanel.this.bitView3_mouseClicked(e);
            }
        });
        this.jLabel7.setText("00");
        this.bitView2.setBackground(Color.white);
        this.bitView2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bitView2.setOpaque(true);
        this.bitView2.setText("\u25a1\u25a1\u25a1\u25a1");
        this.bitView2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EditMemoryPanel.this.bitView2_mouseClicked(e);
            }
        });
        this.bitView1.setBackground(Color.white);
        this.bitView1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bitView1.setOpaque(true);
        this.bitView1.setText("\u25a1\u25a1\u25a1\u25a1");
        this.bitView1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EditMemoryPanel.this.bitView1_mouseClicked(e);
            }
        });
        this.bitView0.setBackground(Color.white);
        this.bitView0.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bitView0.setOpaque(true);
        this.bitView0.setText("\u25a1\u25a1\u25a1\u25a1");
        this.bitView0.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                EditMemoryPanel.this.bitView0_mouseClicked(e);
            }
        });
        this.jLabel11.setText(VampBundle.getString("click_bit"));
        this.jPanel22.add((Component)this.hexRadio, null);
        this.jPanel22.add((Component)this.decRadio, null);
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.viewData, null);
        this.jPanel3.add((Component)this.jLabel5, null);
        this.jPanel3.add((Component)this.inputData, null);
        this.jPanel3.add((Component)this.writeButton, null);
        this.jPanel21.add((Component)this.word1Radio, null);
        this.jPanel21.add((Component)this.word2Radio, null);
        this.jPanel2.add((Component)this.jPanel21, null);
        this.jPanel2.add((Component)this.jPanel22, null);
        this.jPanel1.add((Component)this.jLabel3, null);
        this.jPanel1.add((Component)this.memoryKind, null);
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.memoryAddress, null);
        this.jPanel1.add((Component)this.stepDecButton, null);
        this.jPanel1.add((Component)this.decButton, null);
        this.jPanel1.add((Component)this.incButton, null);
        this.jPanel1.add((Component)this.stepIncButton, null);
        this.jPanel4.add((Component)this.jLabel4, null);
        this.jPanel4.add((Component)this.bitView3, null);
        this.jPanel4.add((Component)this.bitView2, null);
        this.jPanel4.add((Component)this.bitView1, null);
        this.jPanel4.add((Component)this.bitView0, null);
        this.jPanel4.add((Component)this.jLabel7, null);
        this.jPanel4.add((Component)this.jLabel11, null);
        this.btnGroup1.add(this.word1Radio);
        this.btnGroup1.add(this.word2Radio);
        this.btnGroup2.add(this.hexRadio);
        this.btnGroup2.add(this.decRadio);
        this.add((Component)this.jPanel1, null);
        this.add((Component)this.jPanel4, null);
        this.add((Component)this.jPanel2, null);
        this.add((Component)this.jPanel3, null);
        this.writeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditMemoryPanel.this.writeButton_actionPerformed(e);
            }
        });
    }

    void bitView3_mouseClicked(MouseEvent e) {
        this.xorPlcData(32768 >>> e.getX() * 4 / this.bitView3.getWidth());
        this.refresh();
    }

    void bitView2_mouseClicked(MouseEvent e) {
        this.xorPlcData(2048 >>> e.getX() * 4 / this.bitView2.getWidth());
        this.refresh();
    }

    void bitView1_mouseClicked(MouseEvent e) {
        this.xorPlcData(128 >>> e.getX() * 4 / this.bitView1.getWidth());
        this.refresh();
    }

    void bitView0_mouseClicked(MouseEvent e) {
        this.xorPlcData(8 >>> e.getX() * 4 / this.bitView0.getWidth());
        this.refresh();
    }

    void stepDecButton_actionPerformed(ActionEvent e) {
        this.addMemotyAddress(-10L);
        this.refresh();
    }

    void decButton_actionPerformed(ActionEvent e) {
        if (this.word2Radio.isSelected()) {
            this.addMemotyAddress(-2L);
        } else {
            this.addMemotyAddress(-1L);
        }
        this.refresh();
    }

    void incButton_actionPerformed(ActionEvent e) {
        if (this.word2Radio.isSelected()) {
            this.addMemotyAddress(2L);
        } else {
            this.addMemotyAddress(1L);
        }
        this.refresh();
    }

    void stepIncButton_actionPerformed(ActionEvent e) {
        this.addMemotyAddress(10L);
        this.refresh();
    }

    void word1Radio_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    void word2Radio_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    void hexRadio_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    void decRadio_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    private void writeButton_actionPerformed(ActionEvent e) {
        String text = this.inputData.getText();
        if (text == null) {
            return;
        }
        long data = 0L;
        try {
            data = this.hexRadio.isSelected() ? Long.parseLong(text, 16) : Long.parseLong(text);
        }
        catch (Exception ex) {
            return;
        }
        this.setPlcData(data);
        this.inputData.setText(text.toUpperCase());
        this.refresh();
    }

    void memoryKind_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    public void refresh() {
        byte[] data = this.getPlcData();
        if (data == null) {
            this.bitView0.setText(HexStat.valueOf(-1));
            this.bitView1.setText(HexStat.valueOf(-1));
            this.bitView2.setText(HexStat.valueOf(-1));
            this.bitView3.setText(HexStat.valueOf(-1));
            this.viewData.setText("Addr Over!");
            return;
        }
        this.bitView0.setText(HexStat.valueOf(data[1] & 0xF));
        this.bitView1.setText(HexStat.valueOf(data[1] >>> 4 & 0xF));
        this.bitView2.setText(HexStat.valueOf(data[0] & 0xF));
        this.bitView3.setText(HexStat.valueOf(data[0] >>> 4 & 0xF));
        if (this.hexRadio.isSelected()) {
            String hexstr = "00000000" + Integer.toHexString(this.plcDataConvToInt(data)).toUpperCase();
            if (this.word2Radio.isSelected()) {
                this.viewData.setText(hexstr.substring(hexstr.length() - 8));
            } else {
                this.viewData.setText(hexstr.substring(hexstr.length() - 4));
            }
        } else {
            this.viewData.setText(String.valueOf(this.plcDataConvToInt(data)));
        }
    }

    private void addMemotyAddress(long offset) {
        long addr = 0L;
        try {
            addr = Long.parseLong(this.memoryAddress.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        addr += offset;
        long addrMax = this.plc.getPlcMemMax((String)this.memoryKind.getSelectedItem());
        if (this.word2Radio.isSelected()) {
            --addrMax;
        }
        if (addrMax < addr) {
            addr = addrMax;
        }
        if (addr < 0L) {
            addr = 0L;
        }
        this.memoryAddress.setText(String.valueOf(addr));
    }

    private void xorPlcData(int mask) {
        byte[] data = this.getPlcData();
        if (data != null) {
            int srcdata = this.plcDataConvToInt(data) ^ mask;
            this.setPlcData(srcdata);
        }
    }

    private byte[] getPlcData() {
        String memkind = (String)this.memoryKind.getSelectedItem();
        int addr = 0;
        try {
            addr = Integer.parseInt(this.memoryAddress.getText());
        }
        catch (Exception e) {
            return null;
        }
        int len = 1;
        if (this.word2Radio.isSelected()) {
            len = 2;
        }
        return this.plc.readPlcMem(memkind, addr, len);
    }

    private void setPlcData(long data) {
        int len = 1;
        if (this.word2Radio.isSelected()) {
            len = 2;
        }
        byte[] bdata = this.plcDataConvToByteArray(data, len * 2);
        String memkind = (String)this.memoryKind.getSelectedItem();
        int addr = 0;
        try {
            addr = Integer.parseInt(this.memoryAddress.getText());
            this.plc.writePlcMem(memkind, addr, bdata);
        }
        catch (Exception e) {
            return;
        }
    }

    private int plcDataConvToInt(byte[] data) {
        if (4 <= data.length) {
            byte[] bb = new byte[2];
            System.arraycopy(data, 0, bb, 0, 2);
            System.arraycopy(data, 2, data, 0, 2);
            System.arraycopy(bb, 0, data, 2, 2);
        }
        BigInteger bi = new BigInteger(data);
        return bi.intValue();
    }

    private byte[] plcDataConvToByteArray(long data, int byteLen) {
        byte[] ret = new byte[byteLen];
        for (int i = byteLen - 1; 0 <= i; --i) {
            ret[i] = (byte)(data & 0xFFL);
            data >>= 8;
        }
        if (4 <= ret.length) {
            byte[] bb = new byte[2];
            System.arraycopy(ret, 0, bb, 0, 2);
            System.arraycopy(ret, 2, ret, 0, 2);
            System.arraycopy(bb, 0, ret, 2, 2);
        }
        return ret;
    }

    static class HexStat {
        static HexStat instance = new HexStat();
        static final String[] STR_STAT = new String[]{"\u25a1\u25a1\u25a1\u25a1", "\u25a1\u25a1\u25a1\u25a0", "\u25a1\u25a1\u25a0\u25a1", "\u25a1\u25a1\u25a0\u25a0", "\u25a1\u25a0\u25a1\u25a1", "\u25a1\u25a0\u25a1\u25a0", "\u25a1\u25a0\u25a0\u25a1", "\u25a1\u25a0\u25a0\u25a0", "\u25a0\u25a1\u25a1\u25a1", "\u25a0\u25a1\u25a1\u25a0", "\u25a0\u25a1\u25a0\u25a1", "\u25a0\u25a1\u25a0\u25a0", "\u25a0\u25a0\u25a1\u25a1", "\u25a0\u25a0\u25a1\u25a0", "\u25a0\u25a0\u25a0\u25a1", "\u25a0\u25a0\u25a0\u25a0"};
        static final String ERR_STAT = "\uff3f\uff3f\uff3f\uff3f";

        private HexStat() {
        }

        static String valueOf(int index) {
            if (index < 0) {
                return ERR_STAT;
            }
            return STR_STAT[index %= 16];
        }
    }
}

