/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.StringTokenizer;
import jp.co.frdm.Vamp.emulator.PlcClock;
import jp.co.frdm.Vamp.emulator.PlcControl;
import jp.co.frdm.Vamp.receiver.RecvListener;
import program.PlcRunnable;

public abstract class AbstractPlc
implements ActionListener,
PlcControl,
RecvListener,
Serializable {
    private transient PlcClock timer;
    private boolean enable = true;
    private String name;
    private int portNo;
    private int commCount;
    private Calendar calendar = Calendar.getInstance();
    private boolean stoped = false;
    private String progName;
    private transient PlcRunnable runprogram;

    public abstract void setPlcParam(StringTokenizer var1);

    public abstract String getPlcParam();

    public abstract String getPlcInfo();

    public void startPlc() {
        this.calendar = Calendar.getInstance();
        this.timer = PlcClock.getInstance();
        this.timer.addActionListener(this);
    }

    public void stopPlc() {
        if (this.timer != null) {
            this.timer.removeActionListener(this);
        }
        this.timer = null;
        this.runprogram = null;
        this.stoped = true;
    }

    public boolean isStoped() {
        return this.stoped;
    }

    public boolean getStat() {
        return this.enable;
    }

    public void setStat(boolean enable) {
        this.enable = enable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public int getCommCount() {
        return this.commCount;
    }

    protected void incCount() {
        ++this.commCount;
    }

    public Calendar getPlcTime() {
        return this.calendar;
    }

    public void setRunProgram(String progName) throws Exception {
        if (progName != null && progName.length() > 0) {
            String className = "program." + progName;
            this.runprogram = (PlcRunnable)Class.forName(className).newInstance();
            try {
                this.runprogram.startUpCall(this);
                this.progName = progName;
            }
            catch (Exception e) {
                this.progName = null;
                this.runprogram = null;
            }
        } else {
            this.progName = null;
            this.runprogram = null;
        }
    }

    public String getRunProgram() {
        if (this.runprogram == null) {
            return null;
        }
        return this.runprogram.getClass().getName().substring(8);
    }

    public void actionPerformed(ActionEvent evt) {
        this.calendar.add(13, 1);
        if (this.runprogram != null) {
            try {
                this.runprogram.cycleCall(this);
            }
            catch (Exception ex) {
                System.out.println(this.runprogram.getClass().getName() + " Error!!");
                System.out.println(ex.toString());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.setRunProgram(this.progName);
    }
}

