/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator.converter;

import java.io.Serializable;
import java.util.Calendar;

public class FINS
implements Serializable {
    private byte btNetNo;
    private byte btNodeNo;
    private byte btUnitNo;
    private byte[] recvBuffer;
    private byte[] sendBuffer;

    public FINS(int netNo, int nodeNo, int unitNo) {
        this.btNetNo = (byte)netNo;
        this.btNodeNo = (byte)nodeNo;
        this.btUnitNo = (byte)unitNo;
    }

    public String getInfo() {
        return Integer.toString(this.btNetNo & 0xFF) + "." + Integer.toString(this.btNodeNo & 0xFF) + "." + Integer.toString(this.btUnitNo & 0xFF);
    }

    public String getParam() {
        return Integer.toString(this.btNetNo & 0xFF) + "\t" + Integer.toString(this.btNodeNo & 0xFF);
    }

    public boolean checkCommand(byte[] data) {
        if (data.length < 12) {
            return false;
        }
        if (-128 != data[0] || 0 != data[1] || 2 != data[2] || this.btNetNo != data[3] || this.btNodeNo != data[4] || this.btUnitNo != data[5]) {
            return false;
        }
        this.recvBuffer = data;
        return true;
    }

    public int getCommandKind() {
        return (this.recvBuffer[10] & 0xFF) << 8 | this.recvBuffer[11] & 0xFF;
    }

    public int getMemoryKind() {
        return this.recvBuffer[12] & 0xFF;
    }

    public int getMemoryAdder() {
        return (this.recvBuffer[13] & 0xFF) << 8 | this.recvBuffer[14] & 0xFF;
    }

    public int getWordLength() {
        return (this.recvBuffer[16] & 0xFF) << 8 | this.recvBuffer[17] & 0xFF;
    }

    public byte[] getData() {
        if (this.recvBuffer.length <= 18) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] rData = new byte[this.recvBuffer.length - 18];
        System.arraycopy(this.recvBuffer, 18, rData, 0, rData.length);
        return rData;
    }

    public byte[] getErrorResponse(int errCode) {
        byte[] sendData = this.createSendBuff(14);
        sendData[12] = (byte)(errCode >> 8 & 0xFF);
        sendData[13] = (byte)(errCode & 0xFF);
        return sendData;
    }

    public byte[] getResponse(byte[] data) {
        byte[] sendData = this.createSendBuff(14 + data.length);
        System.arraycopy(data, 0, sendData, 14, data.length);
        return sendData;
    }

    public byte[] getTimeResponse(Calendar cal) {
        byte[] sendData = this.createSendBuff(21);
        sendData[14] = this.toBcd(cal.get(1) % 100);
        sendData[15] = this.toBcd(cal.get(2) + 1);
        sendData[16] = this.toBcd(cal.get(5));
        sendData[17] = this.toBcd(cal.get(11));
        sendData[18] = this.toBcd(cal.get(12));
        sendData[19] = this.toBcd(cal.get(13));
        switch (cal.get(7)) {
            case 1: {
                sendData[20] = 0;
                break;
            }
            case 2: {
                sendData[20] = 1;
                break;
            }
            case 3: {
                sendData[20] = 2;
                break;
            }
            case 4: {
                sendData[20] = 3;
                break;
            }
            case 5: {
                sendData[20] = 4;
                break;
            }
            case 6: {
                sendData[20] = 5;
                break;
            }
            case 7: {
                sendData[20] = 6;
                break;
            }
            default: {
                sendData[20] = 0;
            }
        }
        return sendData;
    }

    public byte[] setTimeResponse(Calendar cal) {
        if (this.recvBuffer.length < 17 || 19 < this.recvBuffer.length) {
            return this.getErrorResponse(1025);
        }
        int sec = 0;
        if (17 < this.recvBuffer.length) {
            sec = this.toBin(this.recvBuffer[17]);
        }
        cal.set(2000 + this.toBin(this.recvBuffer[12]), this.toBin(this.recvBuffer[13]) - 1, this.toBin(this.recvBuffer[14]), this.toBin(this.recvBuffer[15]), this.toBin(this.recvBuffer[16]), sec);
        return this.getErrorResponse(0);
    }

    private byte[] createSendBuff(int len) {
        if (len < 14) {
            len = 14;
        }
        this.sendBuffer = new byte[len];
        this.sendBuffer[0] = -64;
        this.sendBuffer[1] = this.recvBuffer[1];
        this.sendBuffer[2] = this.recvBuffer[2];
        this.sendBuffer[3] = this.recvBuffer[6];
        this.sendBuffer[4] = this.recvBuffer[7];
        this.sendBuffer[5] = this.recvBuffer[8];
        this.sendBuffer[6] = this.recvBuffer[3];
        this.sendBuffer[7] = this.recvBuffer[4];
        this.sendBuffer[8] = this.recvBuffer[5];
        this.sendBuffer[9] = this.recvBuffer[9];
        this.sendBuffer[10] = this.recvBuffer[10];
        this.sendBuffer[11] = this.recvBuffer[11];
        this.sendBuffer[12] = 0;
        this.sendBuffer[13] = 0;
        return this.sendBuffer;
    }

    private byte toBcd(int data) {
        return (byte)(data / 10 * 16 + data % 10);
    }

    private int toBin(byte data) {
        return data / 16 * 10 + data % 16;
    }

    public byte[] getRecvData() {
        return this.recvBuffer;
    }

    public byte[] getSendData() {
        return this.sendBuffer;
    }
}

