/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator.converter;

import java.io.Serializable;

public class MC3E
implements Serializable {
    private byte btNetNo;
    private byte btPcNo;
    private byte[] recvBuffer;
    private byte[] sendBuffer;

    public MC3E(int netNo, int pcNo) {
        this.btNetNo = (byte)netNo;
        this.btPcNo = (byte)pcNo;
    }

    public String getInfo() {
        return Integer.toString(this.btNetNo & 0xFF) + "." + Integer.toString(this.btPcNo & 0xFF);
    }

    public String getParam() {
        return Integer.toString(this.btNetNo & 0xFF) + "\t" + Integer.toString(this.btPcNo & 0xFF);
    }

    public boolean checkCommand(byte[] data) {
        if (data.length < 21) {
            return false;
        }
        if (80 != data[0] || 0 != data[1] || this.btNetNo != data[2] || this.btPcNo != data[3] || -1 != data[4] || 3 != data[5] || 0 != data[6]) {
            return false;
        }
        int reqlen = data[7] & 0xFF | (data[8] & 0xFF) << 8;
        if (reqlen != data.length - 9) {
            return false;
        }
        this.recvBuffer = data;
        return true;
    }

    public int getCommandCode() {
        return this.recvBuffer[11] & 0xFF | (this.recvBuffer[12] & 0xFF) << 8;
    }

    public int getSubCommandCode() {
        return this.recvBuffer[13] & 0xFF | (this.recvBuffer[14] & 0xFF) << 8;
    }

    public int getDeviceAdder() {
        return this.recvBuffer[15] & 0xFF | (this.recvBuffer[16] & 0xFF) << 8 | (this.recvBuffer[17] & 0xFF) << 16;
    }

    public int getDeviceCode() {
        return this.recvBuffer[18] & 0xFF;
    }

    public int getDeviceLength() {
        return this.recvBuffer[19] & 0xFF | (this.recvBuffer[20] & 0xFF) << 8;
    }

    public byte[] getData() {
        if (this.recvBuffer.length <= 21) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] rData = new byte[this.recvBuffer.length - 21];
        int s = 21;
        for (int d = 0; d < rData.length; d += 2) {
            rData[d] = this.recvBuffer[s + 1];
            rData[d + 1] = this.recvBuffer[s];
            s += 2;
        }
        return rData;
    }

    public byte[] createResponse(byte[] data) {
        byte[] sendData;
        if (data != null) {
            sendData = this.createBuff(data.length, 0);
            int s = 0;
            int d = 11;
            while (s < data.length) {
                sendData[d] = data[s + 1];
                sendData[d + 1] = data[s];
                s += 2;
                d += 2;
            }
        } else {
            sendData = this.createBuff(0, 0);
        }
        return sendData;
    }

    public byte[] createErrorResponse(int errcode) {
        byte[] sendData = this.createBuff(9, errcode);
        System.arraycopy(this.recvBuffer, 2, sendData, 0, 5);
        System.arraycopy(this.recvBuffer, 11, sendData, 5, 4);
        return sendData;
    }

    private byte[] createBuff(int datalen, int endCode) {
        if (datalen < 0) {
            datalen = 0;
        }
        this.sendBuffer = new byte[11 + datalen];
        this.sendBuffer[0] = -48;
        this.sendBuffer[1] = 0;
        this.sendBuffer[2] = this.recvBuffer[2];
        this.sendBuffer[3] = this.recvBuffer[3];
        this.sendBuffer[4] = -1;
        this.sendBuffer[5] = 3;
        this.sendBuffer[6] = 0;
        this.sendBuffer[7] = (byte)(datalen + 2 & 0xFF);
        this.sendBuffer[8] = (byte)(datalen + 2 >> 8 & 0xFF);
        this.sendBuffer[9] = (byte)(endCode & 0xFF);
        this.sendBuffer[10] = (byte)(endCode >> 8 & 0xFF);
        return this.sendBuffer;
    }

    public byte[] getRecvData() {
        return this.recvBuffer;
    }

    public byte[] getSendData() {
        return this.sendBuffer;
    }
}

