/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.receiver;

import java.util.ArrayList;
import java.util.List;
import jp.co.frdm.Vamp.receiver.RecvListener;

public abstract class AbstractReceiver
implements Runnable {
    private Thread thread;
    private List recvListeners = new ArrayList();
    private long delay;
    protected final int portNo;

    protected abstract boolean open();

    protected abstract void close();

    protected abstract byte[] recv();

    protected abstract void send(byte[] var1) throws Exception;

    public AbstractReceiver(int portNo, long delay) {
        this.portNo = portNo;
        this.delay = delay;
        this.thread = new Thread(this);
    }

    public synchronized void addRecvListener(RecvListener listner) {
        this.recvListeners.add(listner);
        System.out.println("Receiver(" + String.valueOf(this.portNo) + ") listener add : " + String.valueOf(this.recvListeners.size()));
    }

    public synchronized void removeRecvListener(RecvListener listner) {
        this.recvListeners.remove(listner);
        System.out.println("Receiver(" + String.valueOf(this.portNo) + ") listener remove : " + String.valueOf(this.recvListeners.size()));
    }

    private synchronized byte[] fireRecvPerformed(byte[] recvData) {
        for (RecvListener listner : this.recvListeners) {
            byte[] sendData = listner.recvPerformed(recvData);
            if (sendData == null) continue;
            return sendData;
        }
        return null;
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        Thread th = this.thread;
        this.thread = null;
        try {
            while (th.isAlive()) {
                th.join();
            }
        }
        catch (InterruptedException ee) {
            ee.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.open()) {
            return;
        }
        System.out.println("start!");
        while (this.thread == Thread.currentThread()) {
            byte[] sendData;
            byte[] recvData = this.recv();
            if (recvData == null || (sendData = this.fireRecvPerformed(recvData)) == null) continue;
            AbstractReceiver abstractReceiver = this;
            synchronized (abstractReceiver) {
                long delayTime = this.delay;
            }
            try {
                Thread.sleep(this.delay);
                this.send(sendData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.close();
        System.out.println("stop!");
    }

    public synchronized void setDelay(long delay) {
        this.delay = delay;
    }
}

