/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Timer;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.PlcControl;
import program.PlcRunnable;

public class P12Analog
implements PlcRunnable,
ActionListener {
    private Timer timer = new Timer(1000, this);
    private PlcControl plc;
    private int second = 0;
    private int mokuhyo;
    private int preValue;
    private int curValue;
    private int nokori;
    private int average;
    private int yosou;
    private int count;
    private int keisuu = 20;

    public P12Analog() {
        this.timer.start();
    }

    public void startUpCall(PlcControl plc) throws Exception {
    }

    public void cycleCall(PlcControl plc) throws Exception {
        if (this.plc == null) {
            this.plc = plc;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.plc == null) {
            return;
        }
        if (this.second % 50 == 0) {
            for (int i = 500; i < 513; ++i) {
                this.plc.writePlcMem("DM", i, this.randomNumber(this.plc.readPlcMem("DM", i, 1)));
            }
        }
        this.plc.writePlcMem("DM", 3313, this.intToByte(this.second));
        this.plc.writePlcMem("DM", 3314, this.intToByte((1799 - this.second) / 60));
        this.plc.writePlcMem("DM", 3315, this.intToByte((1799 - this.second) % 60));
        if (this.second % 10 == 0) {
            this.curValue = (int)((double)this.curValue + Math.random() * (double)this.keisuu);
            this.plc.writePlcMem("DM", 3307, this.intToByte(this.curValue));
        }
        if (this.second % 30 == 0) {
            this.calcDemand();
        }
        ++this.second;
        if (1800 <= this.second) {
            this.second = 0;
        }
    }

    private byte[] randomNumber(byte[] oldData) {
        int value = Integer.parseInt(Util.toString(oldData), 16);
        if ((value += (int)(Math.random() * 100.0 - 50.0)) > 4000) {
            value = 4000 - value % 4000;
        }
        if (value < 0) {
            value = Math.abs(value);
        }
        StringBuffer sb = new StringBuffer(Integer.toString(value, 16));
        while (sb.length() < 4) {
            sb.insert(0, '0');
        }
        return Util.toByteArrey(sb.toString());
    }

    private void calcDemand() {
        this.mokuhyo = this.byteToInt(this.plc.readPlcMem("DM", 3301, 1));
        if (this.count == 0) {
            this.curValue = 0;
            this.preValue = 0;
            this.keisuu = this.keisuu == 20 ? 18 : 20;
        }
        this.nokori = this.mokuhyo - this.curValue;
        if (this.nokori < 0) {
            this.nokori = 0;
        }
        this.average = (this.curValue - this.preValue) * 60;
        if (this.average < 0) {
            this.average = 0;
        }
        this.yosou = (this.curValue - this.preValue) * (60 - this.count) + this.curValue;
        if (this.yosou < 0) {
            this.yosou = 0;
        }
        this.plc.writePlcMem("DM", 3306, this.intToByte(this.preValue));
        this.plc.writePlcMem("DM", 3307, this.intToByte(this.curValue));
        this.plc.writePlcMem("DM", 3308, this.intToByte(this.nokori));
        this.plc.writePlcMem("DM", 3309, this.intToByte(this.average));
        this.plc.writePlcMem("DM", 3310, this.intToByte(this.yosou));
        this.plc.writePlcMem("DM", 3316, this.intToByte(this.count));
        this.plc.writePlcMem("DM", 19063, this.intToByte(this.count));
        this.preValue = this.curValue;
        ++this.count;
        if (60 <= this.count) {
            this.count = 0;
        }
    }

    private byte[] intToByte(int value) {
        DecimalFormat f = new DecimalFormat("0000");
        return Util.toByteArrey(String.valueOf(f.format(value)));
    }

    private int byteToInt(byte[] value) {
        return Integer.parseInt(Util.toString(value));
    }
}

