/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.Compare;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Export;
import org.dbunit.ant.Operation;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public class DbUnitTask
extends Task {
    private Connection conn = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private String schema = null;
    private List steps = new ArrayList();
    private Path classpath;
    private AntClassLoader loader;
    private boolean useQualifiedTableNames = false;
    private boolean supportBatchStatement = false;
    private boolean datatypeWarning = true;
    private String escapePattern = null;
    private String dataTypeFactory = "org.dbunit.dataset.datatype.DefaultDataTypeFactory";

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserid(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setUseQualifiedTableNames(boolean useQualifiedTableNames) {
        this.useQualifiedTableNames = useQualifiedTableNames;
    }

    public void setSupportBatchStatement(boolean supportBatchStatement) {
        this.supportBatchStatement = supportBatchStatement;
    }

    public void setDatatypeWarning(boolean datatypeWarning) {
        this.datatypeWarning = datatypeWarning;
    }

    public void setDatatypeFactory(String datatypeFactory) {
        this.dataTypeFactory = datatypeFactory;
    }

    public void setEscapePattern(String escapePattern) {
        this.escapePattern = escapePattern;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public List getSteps() {
        return this.steps;
    }

    public void addOperation(Operation operation) {
        this.steps.add(operation);
    }

    public void addCompare(Compare compare) {
        this.steps.add(compare);
    }

    public void addExport(Export export) {
        this.steps.add(export);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        try {
            try {
                IDatabaseConnection connection = this.createConnection();
                ListIterator stepIter = this.steps.listIterator();
                while (stepIter.hasNext()) {
                    DbUnitTaskStep step = (DbUnitTaskStep)stepIter.next();
                    this.log(step.getLogMessage(), 2);
                    step.execute(connection);
                }
                Object var5_6 = null;
            }
            catch (DatabaseUnitException e) {
                throw new BuildException((Throwable)e, this.location);
            }
            catch (SQLException e) {
                throw new BuildException((Throwable)e, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (this.conn == null) throw throwable;
                this.conn.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (this.conn == null) return;
        this.conn.close();
        return;
    }

    IDatabaseConnection createConnection() throws SQLException {
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.location);
        }
        if (this.userId == null) {
            throw new BuildException("User Id attribute must be set!", this.location);
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.location);
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.location);
        }
        if (this.steps.size() == 0) {
            throw new BuildException("Must declare at least one step in a <dbunit> task!");
        }
        Driver driverInstance = null;
        try {
            Class dc;
            if (this.classpath != null) {
                this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                this.loader = new AntClassLoader(this.project, this.classpath);
                dc = this.loader.loadClass(this.driver);
            } else {
                this.log("Loading " + this.driver + " using system loader.", 3);
                dc = Class.forName(this.driver);
            }
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        catch (InstantiationException e) {
            throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        this.log("connecting to " + this.url, 3);
        Properties info = new Properties();
        info.put("user", this.userId);
        info.put("password", this.password);
        this.conn = driverInstance.connect(this.url, info);
        if (this.conn == null) {
            throw new SQLException("No suitable Driver for " + this.url);
        }
        this.conn.setAutoCommit(true);
        DatabaseConnection connection = new DatabaseConnection(this.conn, this.schema);
        DatabaseConfig config = connection.getConfig();
        config.setFeature("http://www.dbunit.org/features/batchedStatements", this.supportBatchStatement);
        config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.useQualifiedTableNames);
        config.setFeature("http://www.dbunit.org/features/datatypeWarning", this.datatypeWarning);
        config.setProperty("http://www.dbunit.org/properties/escapePattern", this.escapePattern);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", new ForwardOnlyResultSetTableFactory());
        try {
            IDataTypeFactory dataTypeFactory = (IDataTypeFactory)Class.forName(this.dataTypeFactory).newInstance();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class Not Found: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Illegal Access: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        catch (InstantiationException e) {
            throw new BuildException("Instantiation Exception: DataType factory " + this.driver + " could not be loaded", (Throwable)e, this.location);
        }
        return connection;
    }
}

