/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Table
extends Rectangle
implements Element,
MarkupAttributes {
    private int columns;
    private Point curPosition = new Point(0, 0);
    private ArrayList rows = new ArrayList();
    private Cell defaultLayout = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float widthPercentage = 80.0f;
    private String absWidth = "";
    private float[] widths;
    boolean mDebug = false;
    boolean mTableInserted = false;
    boolean mAutoFillEmptyCells = false;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    protected Hashtable alternatingRowAttributes = null;
    static /* synthetic */ Class class$com$lowagie$text$Table;
    static /* synthetic */ Class class$com$lowagie$text$Cell;

    public Table(int n) throws BadElementException {
        this(n, 1);
    }

    public Table(int n, int n2) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        if (n <= 0) {
            throw new BadElementException("A table should have at least 1 column.");
        }
        this.columns = n;
        for (int i = 0; i < n2; ++i) {
            this.rows.add(new Row(n));
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[n];
        float f = 100.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            this.widths[i] = f;
        }
    }

    public Table(Properties properties) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        int n;
        int n2;
        int n3;
        int n4;
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultLayout.setBorder(15);
        String string = (String)properties.remove("columns");
        if (string == null) {
            this.columns = 1;
        } else {
            this.columns = Integer.parseInt(string);
            if (this.columns <= 0) {
                this.columns = 1;
            }
        }
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, this.curPosition.y);
        string = (String)properties.remove("lastHeaderRow");
        if (string != null) {
            this.setLastHeaderRow(Integer.parseInt(string));
        }
        if ((string = (String)properties.remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)properties.remove("cellspacing")) != null) {
            this.setSpacing(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("cellpadding")) != null) {
            this.setPadding(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("offset")) != null) {
            this.setOffset(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)properties.remove("width")) != null) {
            if (string.endsWith("%")) {
                this.setWidth(Float.valueOf(string.substring(0, string.length() - 1) + "f").floatValue());
            } else {
                this.setAbsWidth(string);
            }
        }
        this.widths = new float[this.columns];
        for (n4 = 0; n4 < this.columns; ++n4) {
            this.widths[n4] = 0.0f;
        }
        string = (String)properties.remove("widths");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.widths[n5] = Float.valueOf(string + "f").floatValue();
                ++n5;
            }
            this.columns = n5;
        }
        if ((string = (String)properties.remove("tablefitspage")) != null) {
            this.tableFitsPage = new Boolean(string);
        }
        if ((string = (String)properties.remove("cellsfitpage")) != null) {
            this.cellsFitPage = new Boolean(string);
        }
        if ((string = (String)properties.remove("borderwidth")) != null) {
            this.setBorderWidth(Float.valueOf(string + "f").floatValue());
        }
        n4 = 0;
        string = (String)properties.remove("left");
        if (string != null && new Boolean(string).booleanValue()) {
            n4 |= 4;
        }
        if ((string = (String)properties.remove("right")) != null && new Boolean(string).booleanValue()) {
            n4 |= 8;
        }
        if ((string = (String)properties.remove("top")) != null && new Boolean(string).booleanValue()) {
            n4 |= 1;
        }
        if ((string = (String)properties.remove("bottom")) != null && new Boolean(string).booleanValue()) {
            n4 |= 2;
        }
        this.setBorder(n4);
        String string2 = (String)properties.remove("red");
        String string3 = (String)properties.remove("green");
        String string4 = (String)properties.remove("blue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBorderColor(new Color(n3, n2, n));
        } else {
            string = properties.getProperty("bordercolor");
            if (string != null) {
                this.setBorderColor(MarkupParser.decodeColor(string));
            }
        }
        string2 = (String)properties.remove("bgred");
        string3 = (String)properties.remove("bggreen");
        string4 = (String)properties.remove("bgblue");
        if (string2 != null || string3 != null || string4 != null) {
            n3 = 0;
            n2 = 0;
            n = 0;
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
            if (string3 != null) {
                n2 = Integer.parseInt(string3);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
            }
            this.setBackgroundColor(new Color(n3, n2, n));
        } else {
            string = (String)properties.remove("backgroundcolor");
            if (string != null) {
                this.setBackgroundColor(MarkupParser.decodeColor(string));
            }
        }
        string = (String)properties.remove("grayfill");
        if (string != null) {
            this.setGrayFill(Float.valueOf(string + "f").floatValue());
        }
        if (properties.size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setDefaultLayout(Cell cell) {
        this.defaultLayout = cell;
    }

    public void setAutoFillEmptyCells(boolean bl) {
        this.mAutoFillEmptyCells = bl;
    }

    public void setTableFitsPage(boolean bl) {
        this.tableFitsPage = bl;
        if (bl) {
            this.setCellsFitPage(true);
        }
    }

    public void setCellsFitPage(boolean bl) {
        this.cellsFitPage = bl;
    }

    public boolean hasToFitPageTable() {
        return this.tableFitsPage;
    }

    public boolean hasToFitPageCells() {
        return this.cellsFitPage;
    }

    public void setOffset(float f) {
        this.offset = f;
    }

    public float getOffset() {
        return this.offset;
    }

    public int type() {
        return 22;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void addCell(Cell cell, int n, int n2) throws BadElementException {
        this.addCell(cell, new Point(n, n2));
    }

    public void addCell(Cell cell, Point point) throws BadElementException {
        if (cell == null) {
            throw new NullPointerException("addCell - cell has null-value");
        }
        if (point == null) {
            throw new NullPointerException("addCell - point has null-value");
        }
        if (cell.isTable()) {
            this.insertTable((Table)cell.getElements().next(), point);
        }
        if (this.mDebug) {
            if (point.x < 0) {
                throw new BadElementException("row coordinate of location must be >= 0");
            }
            if (point.y <= 0 && point.y > this.columns) {
                throw new BadElementException("column coordinate of location must be >= 0 and < nr of columns");
            }
            if (!this.isValidLocation(cell, point)) {
                throw new BadElementException("Adding a cell at the location (" + point.x + "," + point.y + ") with a colspan of " + cell.colspan() + " and a rowspan of " + cell.rowspan() + " is illegal (beyond boundaries/overlapping).");
            }
        }
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        cell.fill();
        this.placeCell(this.rows, cell, point);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase phrase) throws BadElementException {
        this.addCell(phrase, this.curPosition);
    }

    public void addCell(Phrase phrase, Point point) throws BadElementException {
        Cell cell = new Cell(phrase);
        cell.setBorder(this.defaultLayout.border());
        cell.setBorderWidth(this.defaultLayout.borderWidth());
        cell.setBorderColor(this.defaultLayout.borderColor());
        cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        cell.setGrayFill(this.defaultLayout.grayFill());
        cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        cell.setColspan(this.defaultLayout.colspan());
        cell.setRowspan(this.defaultLayout.rowspan());
        this.addCell(cell, point);
    }

    public void addCell(String string) throws BadElementException {
        this.addCell(new Phrase(string), this.curPosition);
    }

    public void addCell(String string, Point point) throws BadElementException {
        this.addCell(new Phrase(string), point);
    }

    public void insertTable(Table table) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, this.curPosition);
    }

    public void insertTable(Table table, int n, int n2) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        this.insertTable(table, new Point(n, n2));
    }

    public void insertTable(Table table, Point point) {
        if (table == null) {
            throw new NullPointerException("insertTable - table has null-value");
        }
        if (point == null) {
            throw new NullPointerException("insertTable - point has null-value");
        }
        this.mTableInserted = true;
        table.complete();
        if (this.mDebug && point.y > this.columns) {
            System.err.println("insertTable -- wrong columnposition(" + point.y + ") of location; max =" + this.columns);
        }
        int n = point.x + 1 - this.rows.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.rows.add(new Row(this.columns));
            }
        }
        ((Row)this.rows.get(point.x)).setElement(table, point.y);
        this.setCurrentLocationToNextValidPosition(point);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.mAutoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
        if (this.alternatingRowAttributes != null) {
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            Object object = this.alternatingRowAttributes.keySet().iterator();
            while (object.hasNext()) {
                String string = String.valueOf(object.next());
                String[] stringArray = (String[])this.alternatingRowAttributes.get(string);
                properties.setProperty(string, stringArray[0]);
                properties2.setProperty(string, stringArray[1]);
            }
            for (int i = this.lastHeaderRow + 1; i < this.rows.size(); ++i) {
                object = (Row)this.rows.get(i);
                ((Row)object).setMarkupAttributes(i % 2 == 0 ? properties : properties2);
            }
        }
    }

    public void setDefaultCellBorder(int n) {
        this.defaultLayout.setBorder(n);
    }

    public void setDefaultCellBorderWidth(float f) {
        this.defaultLayout.setBorderWidth(f);
    }

    public void setDefaultCellBorderColor(Color color) {
        this.defaultLayout.setBorderColor(color);
    }

    public void setDefaultCellBackgroundColor(Color color) {
        this.defaultLayout.setBackgroundColor(color);
    }

    public void setDefaultCellGrayFill(float f) {
        if (f >= 0.0f && f <= 1.0f) {
            this.defaultLayout.setGrayFill(f);
        }
    }

    public void setDefaultHorizontalAlignment(int n) {
        this.defaultLayout.setHorizontalAlignment(n);
    }

    public void setDefaultVerticalAlignment(int n) {
        this.defaultLayout.setVerticalAlignment(n);
    }

    public void setDefaultRowspan(int n) {
        this.defaultLayout.setRowspan(n);
    }

    public void setDefaultColspan(int n) {
        this.defaultLayout.setColspan(n);
    }

    private void assumeTableDefaults(Cell cell) {
        if (cell.border() == -1) {
            cell.setBorder(this.defaultLayout.border());
        }
        if (cell.borderWidth() == -1.0f) {
            cell.setBorderWidth(this.defaultLayout.borderWidth());
        }
        if (cell.borderColor() == null) {
            cell.setBorderColor(this.defaultLayout.borderColor());
        }
        if (cell.backgroundColor() == null) {
            cell.setBackgroundColor(this.defaultLayout.backgroundColor());
        }
        if (cell.grayFill() == -1.0f) {
            cell.setGrayFill(this.defaultLayout.grayFill());
        }
        if (cell.horizontalAlignment() == -1) {
            cell.setHorizontalAlignment(this.defaultLayout.horizontalAlignment());
        }
        if (cell.verticalAlignment() == -1) {
            cell.setVerticalAlignment(this.defaultLayout.verticalAlignment());
        }
    }

    public void deleteColumn(int n) throws BadElementException {
        int n2;
        float[] fArray = new float[--this.columns];
        for (n2 = 0; n2 < n; ++n2) {
            fArray[n2] = this.widths[n2];
        }
        for (n2 = n; n2 < this.columns; ++n2) {
            fArray[n2] = this.widths[n2 + 1];
        }
        this.setWidths(fArray);
        for (n2 = 0; n2 < this.columns; ++n2) {
            fArray[n2] = this.widths[n2];
        }
        this.widths = fArray;
        int n3 = this.rows.size();
        for (int i = 0; i < n3; ++i) {
            Row row = (Row)this.rows.get(i);
            row.deleteColumn(n);
            this.rows.set(i, row);
        }
        if (n == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        this.rows.remove(n);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int n) {
        this.lastHeaderRow = n;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlignment(String string) {
        if ("Left".equalsIgnoreCase(string)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    public void setSpaceInsideCell(float f) {
        this.cellpadding = f;
    }

    public void setSpaceBetweenCells(float f) {
        this.cellspacing = f;
    }

    public void setPadding(float f) {
        this.cellpadding = f;
    }

    public void setSpacing(float f) {
        this.cellspacing = f;
    }

    public void setCellpadding(float f) {
        this.cellspacing = f;
    }

    public void setCellspacing(float f) {
        this.cellpadding = f;
    }

    public void setWidth(float f) {
        this.widthPercentage = f;
    }

    public void setAbsWidth(String string) {
        this.absWidth = string;
    }

    public void setWidths(float[] fArray) throws BadElementException {
        if (fArray.length != this.columns) {
            throw new BadElementException("Wrong number of columns.");
        }
        float f = 0.0f;
        for (int i = 0; i < this.columns; ++i) {
            f += fArray[i];
        }
        this.widths[this.columns - 1] = 100.0f;
        for (int i = 0; i < this.columns - 1; ++i) {
            float f2;
            this.widths[i] = f2 = 100.0f * fArray[i] / f;
            int n = this.columns - 1;
            this.widths[n] = this.widths[n] - f2;
        }
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.setWidths(fArray);
    }

    public int columns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public int alignment() {
        return this.alignment;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float widthPercentage() {
        return this.widthPercentage;
    }

    public String absWidth() {
        return this.absWidth;
    }

    public int firstDataRow() {
        return this.lastHeaderRow + 1;
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.rows.size());
    }

    public Object getElement(int n, int n2) {
        return ((Row)this.rows.get(n)).getCell(n2);
    }

    private void mergeInsertedTables() {
        int n = 0;
        int n2 = 0;
        float[] fArray = null;
        int[] nArray = new int[this.columns];
        float[][] fArrayArray = new float[this.columns][];
        int[] nArray2 = new int[this.rows.size()];
        ArrayList<Row> arrayList = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Table table = null;
        for (n2 = 0; n2 < this.columns; ++n2) {
            n6 = 1;
            for (n = 0; n < this.rows.size(); ++n) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n)).getCell(n2))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n)).getCell(n2);
                if (table.getDimension().width <= n6) continue;
                n6 = table.getDimension().width;
                fArrayArray[n2] = table.widths;
            }
            n4 += n6;
            nArray[n2] = n6;
        }
        for (n = 0; n < this.rows.size(); ++n) {
            n5 = 1;
            for (n2 = 0; n2 < this.columns; ++n2) {
                if (!(class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n)).getCell(n2))) continue;
                bl = true;
                table = (Table)((Row)this.rows.get(n)).getCell(n2);
                if (table.getDimension().height <= n5) continue;
                n5 = table.getDimension().height;
            }
            n3 += n5;
            nArray2[n] = n5;
        }
        if (n4 != this.columns || n3 != this.rows.size() || bl) {
            int n7;
            int n8;
            fArray = new float[n4];
            int n9 = 0;
            for (n8 = 0; n8 < this.widths.length; ++n8) {
                if (nArray[n8] != 1) {
                    for (n7 = 0; n7 < nArray[n8]; ++n7) {
                        fArray[n9] = this.widths[n8] * fArrayArray[n8][n7] / 100.0f;
                        ++n9;
                    }
                    continue;
                }
                fArray[n9] = this.widths[n8];
                ++n9;
            }
            arrayList = new ArrayList<Row>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add(new Row(n4));
            }
            n8 = 0;
            n7 = 0;
            Object object = null;
            for (n = 0; n < this.rows.size(); ++n) {
                n7 = 0;
                n5 = 1;
                for (n2 = 0; n2 < this.columns; ++n2) {
                    Object object2;
                    if ((class$com$lowagie$text$Table == null ? Table.class$("com.lowagie.text.Table") : class$com$lowagie$text$Table).isInstance(((Row)this.rows.get(n)).getCell(n2))) {
                        table = (Table)((Row)this.rows.get(n)).getCell(n2);
                        for (int i = 0; i < table.getDimension().height; ++i) {
                            for (int j = 0; j < table.getDimension().width; ++j) {
                                object = table.getElement(i, j);
                                if (object == null) continue;
                                ((Row)arrayList.get(i + n8)).addElement(object, j + n7);
                            }
                        }
                    } else if ((class$com$lowagie$text$Cell == null ? Table.class$("com.lowagie.text.Cell") : class$com$lowagie$text$Cell).isInstance(object2 = this.getElement(n, n2))) {
                        ((Cell)object2).setRowspan(((Cell)((Row)this.rows.get(n)).getCell(n2)).rowspan() + nArray2[n] - 1);
                        ((Cell)object2).setColspan(((Cell)((Row)this.rows.get(n)).getCell(n2)).colspan() + nArray[n2] - 1);
                        this.placeCell(arrayList, (Cell)object2, new Point(n8, n7));
                    }
                    n7 += nArray[n2];
                }
                n8 += nArray2[n];
            }
            this.columns = n4;
            this.rows = arrayList;
            this.widths = fArray;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (((Row)this.rows.get(i)).isReserved(j)) continue;
                    this.addCell(this.defaultLayout, new Point(i, j));
                }
            }
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    private boolean isValidLocation(Cell cell, Point point) {
        if (point.x < this.rows.size()) {
            if (point.y + cell.colspan() > this.columns) {
                return false;
            }
            int n = this.rows.size() - point.x > cell.rowspan() ? cell.rowspan() : this.rows.size() - point.x;
            int n2 = this.columns - point.y > cell.colspan() ? cell.colspan() : this.columns - point.y;
            for (int i = point.x; i < point.x + n; ++i) {
                for (int j = point.y; j < point.y + n2; ++j) {
                    if (!((Row)this.rows.get(i)).isReserved(j)) continue;
                    return false;
                }
            }
        } else if (point.y + cell.colspan() > this.columns) {
            return false;
        }
        return true;
    }

    private void placeCell(ArrayList arrayList, Cell cell, Point point) {
        int n;
        Row row = null;
        int n2 = ((Row)arrayList.get(0)).columns();
        int n3 = point.x + cell.rowspan() - arrayList.size();
        this.assumeTableDefaults(cell);
        if (point.x + cell.rowspan() > arrayList.size()) {
            for (n = 0; n < n3; ++n) {
                row = new Row(n2);
                arrayList.add(row);
            }
        }
        for (n = point.x + 1; n < point.x + cell.rowspan(); ++n) {
            if (((Row)arrayList.get(n)).reserve(point.y, cell.colspan())) continue;
            throw new RuntimeException("addCell - error in reserve");
        }
        row = (Row)arrayList.get(point.x);
        row.addElement(cell, point.y);
    }

    public void addColumns(int n) {
        int n2;
        ArrayList<Row> arrayList = new ArrayList<Row>(this.rows.size());
        int n3 = this.columns + n;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = new Row(n3);
            for (n2 = 0; n2 < this.columns; ++n2) {
                row.setElement(((Row)this.rows.get(i)).getCell(n2), n2);
            }
            for (n2 = this.columns; n2 < n3 && i < this.curPosition.x; ++n2) {
                row.setElement(this.defaultLayout, n2);
            }
            arrayList.add(row);
        }
        float[] fArray = new float[n3];
        for (n2 = 0; n2 < this.columns; ++n2) {
            fArray[n2] = this.widths[n2];
        }
        for (n2 = this.columns; n2 < n3; ++n2) {
            fArray[n2] = 0.0f;
        }
        this.columns = n3;
        this.widths = fArray;
        this.rows = arrayList;
    }

    public float[] getWidths(float f, float f2) {
        float[] fArray = new float[this.columns + 1];
        switch (this.alignment) {
            case 0: {
                fArray[0] = f;
                break;
            }
            case 2: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 100.0f;
                break;
            }
            default: {
                fArray[0] = f + f2 * (100.0f - this.widthPercentage) / 200.0f;
            }
        }
        f2 = f2 * this.widthPercentage / 100.0f;
        for (int i = 1; i < this.columns; ++i) {
            fArray[i] = fArray[i - 1] + this.widths[i - 1] * f2 / 100.0f;
        }
        fArray[this.columns] = fArray[0] + f2;
        return fArray;
    }

    private void setCurrentLocationToNextValidPosition(Point point) {
        int n = point.x;
        int n2 = point.y;
        do {
            if (n2 + 1 == this.columns) {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        } while (n < this.rows.size() && n2 < this.columns && ((Row)this.rows.get(n)).isReserved(n2));
        this.curPosition = new Point(n, n2);
    }

    public static boolean isTag(String string) {
        return "table".equals(string);
    }

    public void setAlternatingRowAttribute(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            throw new NullPointerException("MarkupTable#setAlternatingRowAttribute(): null values are not permitted.");
        }
        this.alternatingRowAttributes = this.alternatingRowAttributes == null ? new Hashtable() : this.alternatingRowAttributes;
        String[] stringArray = (String[])this.alternatingRowAttributes.get(string);
        stringArray = stringArray == null ? new String[2] : stringArray;
        stringArray[0] = string2;
        stringArray[1] = string3;
        this.alternatingRowAttributes.put(string, stringArray);
    }

    public float top() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right() {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float top(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float bottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float left(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public float right(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table can't be calculated. See the FAQ.");
    }

    public void setTop(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setBottom(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setLeft(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    public void setRight(int n) {
        throw new UnsupportedOperationException("Dimensions of a Table are attributed automagically. See the FAQ.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

