/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Cell;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

class PdfTable
extends Rectangle {
    private int columns;
    private ArrayList headercells;
    private ArrayList cells;
    private float cellpadding;
    private float cellspacing;

    PdfTable(Table table, float f, float f2, float f3) {
        super(f, f3, f2, f3);
        PdfCell pdfCell;
        int n;
        this.setBorder(table.border());
        this.setBorderWidth(table.borderWidth());
        this.setBorderColor(table.borderColor());
        this.setBackgroundColor(table.backgroundColor());
        this.setGrayFill(table.grayFill());
        this.columns = table.columns();
        this.cellpadding = table.cellpadding();
        this.cellspacing = table.cellspacing();
        float[] fArray = table.getWidths(f, f2 - f);
        this.setLeft(fArray[0]);
        this.setRight(fArray[fArray.length - 1]);
        int n2 = 0;
        int n3 = 0;
        int n4 = table.firstDataRow();
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        int n5 = table.size() + 1;
        float[] fArray2 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            fArray2[i] = f3;
        }
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Row row = (Row)iterator.next();
            if (row.isEmpty()) {
                if (n2 < n5 - 1 && fArray2[n2 + 1] > fArray2[n2]) {
                    fArray2[n2 + 1] = fArray2[n2];
                }
            } else {
                for (n = 0; n < row.columns(); ++n) {
                    Cell cell;
                    block13: {
                        cell = (Cell)row.getCell(n);
                        if (cell == null) continue;
                        pdfCell = new PdfCell(cell, n2, fArray[n], fArray[n + cell.colspan()], fArray2[n2], this.cellspacing, this.cellpadding);
                        try {
                            if (fArray2[n2] - pdfCell.height() - this.cellpadding < fArray2[n2 + pdfCell.rowspan()]) {
                                fArray2[n2 + pdfCell.rowspan()] = fArray2[n2] - pdfCell.height() - this.cellpadding;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (!(fArray2[n2] - pdfCell.height() < fArray2[n5 - 1])) break block13;
                            fArray2[n5 - 1] = fArray2[n2] - pdfCell.height();
                        }
                    }
                    if (n2 < n4) {
                        pdfCell.setHeader();
                        this.headercells.add(pdfCell);
                    }
                    pdfCell.setGroupNumber(n3);
                    bl |= cell.getGroupChange();
                    this.cells.add(pdfCell);
                }
            }
            ++n2;
            if (!bl) continue;
            ++n3;
        }
        int n6 = this.cells.size();
        for (n = 0; n < n6; ++n) {
            pdfCell = (PdfCell)this.cells.get(n);
            try {
                pdfCell.setBottom(fArray2[pdfCell.rownumber() + pdfCell.rowspan()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                pdfCell.setBottom(fArray2[n5 - 1]);
            }
        }
        this.setBottom(fArray2[n5 - 1]);
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    ArrayList getCells() {
        return this.cells;
    }

    int columns() {
        return this.columns;
    }

    float cellpadding() {
        return this.cellpadding;
    }

    float cellspacing() {
        return this.cellspacing;
    }
}

