/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.cat.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * RNVɊւ郆[eBeB[NXB̃NXstaticC|[gAꂼ̃\bhĂяoƂňȉ̌Ăяo\ɂȂ܂B
 *
 * <pre>
 *  List&lt;String&gt; strings = list(&quot;A&quot;, &quot;B&quot;, &quot;C&quot;);
 *  Map&lt;String, String&gt; stringMap = map($(&quot;X&quot;, &quot;1&quot;), $(&quot;Y&quot;, &quot;2&quot;));
 *  Set&lt;String&gt; stringSet = set(&quot;A&quot;, &quot;B&quot;, &quot;C&quot;);
 * </pre>
 *
 * \bhĂяo̍ۂɎgpNXސłׁAnew ŋLq킸킵܂B
 *
 * @author maekawa
 *
 */
public abstract class CollectionUtil {
	/**
	 * w肵NXArrayList𐶐܂
	 *
	 * @param <T> NX
	 * @return w肵NXArrayList𐶐܂
	 */
	public static <T> List<T> list() {
		return new ArrayList<T>();
	}

	/**
	 * w肵NXƏeʂArrayList𐶐܂
	 *
	 * @param <T> NX
	 * @param size e
	 * @return w肵NXƏeʂArrayList𐶐܂
	 */
	public static <T> List<T> list(int size) {
		return new ArrayList<T>(size);
	}

	/**
	 * w肵eŃXg𐶐܂B
	 *
	 * @param <T> NX
	 * @param elements l
	 * @return w肵eŃXg𐶐܂B
	 */
	public static <T> List<T> list(T... elements) {
		return new ArrayList<T>(Arrays.asList(elements));
	}

	/**
	 * w肵NXHashSet𐶐܂
	 *
	 * @param <T> NX
	 * @return w肵NXHashSet𐶐܂
	 */
	public static <T> Set<T> set() {
		return new HashSet<T>();
	}

	/**
	 * w肵NXHashSeteʃTCYŐ܂
	 *
	 * @param <T> NX
	 * @param size eʃTCY
	 * @return w肵NXHashSet𐶐܂
	 */
	public static <T> Set<T> set(int size) {
		return new HashSet<T>(size);
	}

	/**
	 * w肵eŃZbg𐶐܂B
	 *
	 * @param <T> NX
	 * @param elements l
	 * @return w肵eŃZbg𐶐܂B
	 */
	public static <T> Set<T> set(T... elements) {
		return new HashSet<T>(Arrays.asList(elements));
	}

	/**
	 * w肵NXHashMap𐶐܂
	 *
	 * @param <K> L[ɂȂNX
	 * @param <V> lɂȂNX
	 * @return w肵NXHashMap𐶐܂
	 */
	public static <K, V> Map<K, V> map() {
		return new HashMap<K, V>();
	}

	public static class Pair<A, B> {
		private A first;
		private B second;

		public Pair(A first, B second) {
			this.first = first;
			this.second = second;
		}

		public A getFirst() {
			return first;
		}

		public B getSecond() {
			return second;
		}
	}

	/**
	 * w肳ꂽeŃ}bv𐶐܂B
	 *
	 * <pre>
	 * Map&lt;Integer, String&gt; m = map($(0, &quot;0&quot;), $(1, &quot;1&quot;));
	 * </pre>
	 *
	 * ̂悤ɋLq܂B
	 *
	 * @param <K> L[̃NX
	 * @param <V> l̃NX
	 * @param entries Gg[̃e
	 * @return w肳ꂽeŃ}bv𐶐܂B
	 */
	public static <K, V> Map<K, V> map(Pair<K, V>... entries) {
		Map<K, V> map = new HashMap<K, V>();
		for (Pair<K, V> entry : entries) {
			map.put(entry.getFirst(), entry.getSecond());
		}
		return map;
	}

	/**
	 * lƃL[̃yA𐶐܂B
	 *
	 * @param <A> L[̃NX
	 * @param <B> l̃NX
	 * @param first L[l
	 * @param second l
	 * @return lƃL[̃yA𐶐܂B
	 */
	public static <A, B> Pair<A, B> $(A first, B second) {
		return new Pair<A, B>(first, second);
	}
}
