/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.QualityFlag;

import org.F11.scada.WifeException;
import org.F11.scada.applet.expression.text.Format;
import org.F11.scada.applet.expression.text.FormatFactory;
import org.F11.scada.data.ConvertValue;
import org.F11.scada.data.WifeDataAnalog;
import org.F11.scada.data.WifeDataDigital;
import org.F11.scada.xwife.server.WifeDataProvider;

/**
 * ̒lvZNXł
 * vZt|[hL@ɕϊAl擾܂
 * @version 1.0
 * @author Youhei Horikawa <hori@users.sourceforge.jp>
 */
public class Expression {
//	private static Logger log = Logger.getLogger(Expression.class);
	/** ڂlڂ̏ꍇtrue */
	private boolean termIsVariable = false;
	/** vZ(Term)̍ڃXgit|[hL@j */
	private List terms;
	/** gpĂz_ */
	private Set holders;
	/** ԏ[h */
	private boolean isEnableInitialMode;

	/**
	 * ԏ[h true ŏ܂B
	 */
	public Expression() {
		this(true);
	}
	
	/**
	 * ԏ[hݒ肵܂BisEnableInitialModetruȅꍇA
	 * Qƃz_QualityFlagGOOD,BADȊO̎͗OB
	 * @param isEnableInitialMode isEnableInitialModetruȅꍇAQƃz_QualityFlagGOOD,BADȊO̎͗OB
	 */
	public Expression(boolean isEnableInitialMode) {
		this.isEnableInitialMode = isEnableInitialMode;
	}

	/**
	 * ^ꂽvZt|[hL@̎ɕϊ܂B
	 * @param ex vZ
	 */
	public void toPostfix(String ex) {
		terms = new ArrayList();
		Stack operations = new Stack();
		Term term = null;
		for (ExpressionTokenizer et = new ExpressionTokenizer(ex);
				et.hasMoreTokens();) {
			String token = et.nextToken();
			term = TermFactory.createTerm(token, isEnableInitialMode, operations);
			term.convHandle(token, this, operations);
		}
		term = TermFactory.createTerm("#END#", isEnableInitialMode, operations);
		term.convHandle(null, this, operations);
		holders = createHolders();
	}
	
	private Set createHolders() {
		Set ls = new HashSet();
		for (Iterator it = terms.iterator(); it.hasNext();) {
			Object o = it.next();
			if (o instanceof TermValiable) {
				ls.add(o.toString());
			}
		}
		return ls;
	}

	/**
	 * t|[hL@̎𕶎ŕԂ܂B
	 * fobOp̊֐ł
	 * @return ̕\
	 */
	String getRPNString() {
		StringBuffer sb = new StringBuffer();
		for (Iterator it = terms.iterator(); it.hasNext();) {
			sb.append(it.next());
			sb.append(',');
		}
		return sb.toString();
	}

	/**
	 * t|[hL@̎doublel擾܂B
	 * @return vZ
	 */
	public double doubleValue() throws WifeException {
		return calcPostfix().doubleValue();
	}

	/**
	 * t|[hL@̎booleanl擾܂B
	 * @return vZ
	 */
	public boolean booleanValue() throws WifeException {
		return calcPostfix().booleanValue();
	}

	/**
	 * ̃voC__z_̃ZbgԂ܂
	 * @return voC__z_̃ZbgidȂj
	 */
	public Set getProviderHolderNames() {
		if (null != holders) {
			return holders;
		} else {
			return createHolders();
		}
	}

	/**
	 * ̃voC__z_valuetH[}bg
	 * @param value
	 * @return
	 */
	public String format(double value, String pattern) {
		ConvertValue conv = null;
		conv = getConvertValue(conv);
		if (conv != null) {
			if (pattern != null)
				return conv.convertStringValue(conv.convertInputValue(value), pattern);
			else
				return conv.convertStringValue(conv.convertInputValue(value));
		}
		if (pattern != null) {
			FormatFactory factory = new FormatFactory();
			Format format = factory.getFormat(pattern);
			return format.format(value);
		}
		return String.valueOf(value);
	}

	private ConvertValue getConvertValue(ConvertValue conv) {
		for (Iterator it = getProviderHolderNames().iterator(); it.hasNext();) {
			String tag = (String) it.next();
			int p = tag.indexOf('_');
			if (0 < p) {
				DataHolder dh =
					Manager.getInstance().findDataHolder(tag.substring(0, p), tag.substring(p + 1));
				if (dh != null) {
					ConvertValue cv = (ConvertValue) dh.getParameter(WifeDataProvider.PARA_NAME_CONVERT);
					if (cv != null) {
						if (conv == null
							|| conv.getPattern().length() <= cv.getPattern().length()) {
							conv = cv;
							break;
						}
					}
				}
			}
		}
		return conv;
	}

	/**
	 * ɁuvoC__z_v݂邩𔻒肵܂B
	 * @param name voC__z_
	 * @return ݂ꍇ true  Ȃꍇ false Ԃ܂B
	 */
	public boolean hasDataHolder(String name) {
		return holders.contains(name);
	}

	/**
	 * t|[hL@̎vZAʂԂ܂B
	 * @return vZʂAbstractValiableIuWFNg
	 */
	private AbstractValiable calcPostfix() throws WifeException {
		Stack operations = new Stack();
		for (Iterator it = terms.iterator(); it.hasNext();) {
			Term s = (Term) it.next();
			s.calcHandle(this, operations);
		}
		AbstractValiable s = (AbstractValiable) operations.pop();
		return s;
	}

	// ȍ~̃\bh́ATerm̃nh\bhĂяo܂B
	private void push(Term s, Stack operations) {
		operations.push((Object) s);
	}

	private Term pop(Stack operations) {
		return (Term) operations.pop();
	}

	private boolean empty(Stack operations) {
		return operations.empty();
	}

	private Term peek(Stack operations) {
		return (Term) operations.peek();
	}

	private void setTermIsVariable(boolean termIsVariable) {
		this.termIsVariable = termIsVariable;
	}

	private boolean isTermIsVariable() {
		return termIsVariable;
	}

	/**
	 * ʂ̃Xg֒ǉ܂B
	 * @param s
	 */
	private void send(Term s) {
		terms.add(s);
	}

	/**
	 * vZ̊eڂ̃C^tFCXł
	 * <p>^Cg: </p>
	 * <p>: </p>
	 * <p>쌠: Copyright (c) 2002</p>
	 * <p>Ж: </p>
	 * @author 
	 * @version 1.0
	 */
	private interface Term {
		public void convHandle(String token, Expression rp, Stack operations);
		public int getPriority();
		public void calcHandle(Expression rp, Stack operations) throws WifeException;
	}

	/**
	 * lێ鍀ڂ̊NXł
	 * <p>^Cg: </p>
	 * <p>: </p>
	 * <p>쌠: Copyright (c) 2002</p>
	 * <p>Ж: </p>
	 * @author 
	 * @version 1.0
	 */
	private abstract static class AbstractValiable implements Term {
		public void convHandle(String token, Expression rp, Stack operations) {
			rp.send(this);
			rp.setTermIsVariable(true);
		}
		public void calcHandle(Expression rp, Stack operations) {
			rp.push(this, operations);
		}
		public int getPriority() {
			return 0;
		}
		public double doubleValue() throws WifeException {
			throw new WifeException(
				WifeException.WIFE_WARNING,
				WifeException.WIFE_EXPRESSION_WARNING,
				"^sv");
		}
		public boolean booleanValue() throws WifeException {
			throw new WifeException(
				WifeException.WIFE_WARNING,
				WifeException.WIFE_EXPRESSION_WARNING,
				"^sv");
		}
	}

	/**
	 * t@TێNXł
	 * @version 1.0
	 * @author Youhei Horikawa <hori@users.sourceforge.jp>
	 */
	private static class TermValiable extends AbstractValiable {
		private final String ph_name;
		private final boolean isEnableInitialMode;

		public TermValiable(String token, boolean isEnableInitialMode) {
			this.ph_name = token;
			this.isEnableInitialMode = isEnableInitialMode;
		}

		public String toString() {
			return ph_name;
		}

		/**
		 *
		 * @return t@TQƃAiOl
		 */
		public double doubleValue() throws WifeException {
			DataHolder dh = null;
			int p = ph_name.indexOf('_');
			if (0 < p) {
				dh =
					Manager.getInstance().findDataHolder(
						ph_name.substring(0, p),
						ph_name.substring(p + 1));
			}
			if (dh == null) {
				throw new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_EXPRESSION_WARNING,
					"voC__z_o^:" + ph_name);
			}
			if (!(dh.getValue() instanceof WifeDataAnalog)) {
				return super.doubleValue();
			} else {
				ConvertValue conv = (ConvertValue) dh.getParameter("convert");
				switch (dh.getQualityFlag().getQuality()) {
				case QualityFlag.GOOD:
					WifeDataAnalog da = (WifeDataAnalog) dh.getValue();
					return conv.convertDoubleValue(da.doubleValue());
				case QualityFlag.BAD:
					// ʐMG[
					throw new WifeException(
							WifeException.WIFE_WARNING,
							WifeException.WIFE_BAD_DATA_WARNING,
							"f[^擾s:" + ph_name);
				default:
					// XV
					if (isEnableInitialMode) {
						throw new WifeException(
								WifeException.WIFE_WARNING,
								WifeException.WIFE_INITIALDATA_WARNING,
								"f[^XV:" + ph_name);
					} else {
						return conv.convertDoubleValue(0);
					}
				}
			}
		}

		/**
		 *
		 * @return t@TQƃfW^l
		 */
		public boolean booleanValue() throws WifeException {
			DataHolder dh = null;
			int p = ph_name.indexOf('_');
			if (0 < p) {
				dh =
					Manager.getInstance().findDataHolder(
						ph_name.substring(0, p),
						ph_name.substring(p + 1));
			}
			if (dh == null) {
				throw new WifeException(
					WifeException.WIFE_WARNING,
					WifeException.WIFE_BAD_DATA_WARNING,
					"voC__z_o^:" + ph_name);
			}
			if (!(dh.getValue() instanceof WifeDataDigital)) {
				return super.booleanValue();
			} else {
				switch (dh.getQualityFlag().getQuality()) {
				case QualityFlag.GOOD:
					WifeDataDigital wdd = (WifeDataDigital) dh.getValue();
					return wdd.isOnOff(true);
				case QualityFlag.BAD:
					// ʐMG[
					throw new WifeException(
							WifeException.WIFE_WARNING,
							WifeException.WIFE_BAD_DATA_WARNING,
							"f[^擾s:" + ph_name);
				default:
					// XV
					if (isEnableInitialMode) {
						throw new WifeException(
								WifeException.WIFE_WARNING,
								WifeException.WIFE_INITIALDATA_WARNING,
								"f[^XV:" + ph_name);
					} else {
						return false;
					}
				}
			}
		}
	}

	/**
	 * ێNXł
	 * @version 1.0
	 * @author Youhei Horikawa <hori@users.sourceforge.jp>
	 */
	private static class TermDouble extends AbstractValiable {
		private double value;

		public TermDouble(double value) {
			this.value = value;
		}

		public String toString() {
			return String.valueOf(value);
		}

		public double doubleValue() {
			return value;
		}
	}

	/**
	 * vZ̊eڂ𐶐t@NgNXł
	 * @version 1.0
	 * @author Youhei Horikawa <hori@users.sourceforge.jp>
	 */
	private static class TermFactory {
		/** `ςݍڂ̃}bv */
		private static Map opes;
		/**
		 * Zq̊NXł
		 * @version 1.0
		 * @author Youhei Horikawa <hori@users.sourceforge.jp>
		 */
		private abstract static class AbstractOperator implements Term {
			public void convHandle(String token, Expression rp, Stack operations) {
				while (true) {
					if (rp.empty(operations) || (rp.peek(operations) == TermFactory.TERM_BRA)) {
						break;
					}
					Term state = (Term) rp.peek(operations);
					if (this.getPriority() < state.getPriority()) {
						break;
					} else {
						rp.send(rp.pop(operations));
					}
				}
				rp.push(this, operations);
				rp.setTermIsVariable(false);
			}
		}
		/**
		 * Zp֐̊NXł
		 * @version 1.0
		 * @author Youhei Horikawa <hori@users.sourceforge.jp>
		 */
		private abstract static class AbstractFunction implements Term {
			public void convHandle(String token, Expression rp, Stack operations) {
				while (true) {
					if (rp.empty(operations) || (rp.peek(operations) == TermFactory.TERM_BRA)) {
						break;
					}
					Term state = (Term) rp.peek(operations);
					if (this.getPriority() <= state.getPriority()) {
						break;
					} else {
						rp.send(rp.pop(operations));
					}
				}
				rp.push(this, operations);
				rp.setTermIsVariable(false);
			}
			public int getPriority() {
				return 3;
			}
		}

		/** 萔Ft|[h̏I */
		private static final Term TERM_END = new AbstractValiable() {
			public void convHandle(String token, Expression rp, Stack operations) {
				while (!rp.empty(operations)) {
					Term state = rp.pop(operations);
					if (state == TERM_BRA) {
						throw new RuntimeException("ʂĂȂ");
					}
					rp.send(state);
				}
				rp.send(this);
			}

			public void calcHandle(Expression rp, Stack operations) {
				AbstractValiable state = (AbstractValiable) rp.pop(operations);
				if (!rp.empty(operations)) {
					throw new RuntimeException("sȌvZ");
				}
				rp.push(state, operations);
			}

			public String toString() {
				return "#end#";
			}
		};
		/** 萔FuPbg '(' */
		private static final Term TERM_BRA = new AbstractValiable() {
			public void convHandle(String token, Expression rp, Stack operations) {
				rp.push(this, operations);
				rp.setTermIsVariable(false);
			}
			public void calcHandle(Expression rp, Stack operations) {
				throw new RuntimeException("sȌvZ");
			}
			public String toString() {
				return "(";
			}
		};
		/** 萔FuPbg ')' */
		private static final Term TERM_CKET = new AbstractValiable() {
			public void convHandle(String token, Expression rp, Stack operations) {
				while (!rp.empty(operations)) {
					Term state = rp.pop(operations);
					if (state == TERM_BRA) {
						rp.setTermIsVariable(true);
						return;
					} else {
						rp.send(state);
					}
				}
				throw new RuntimeException("ʂĂȂ");
			}
			public void calcHandle(Expression rp, Stack operations) {
				throw new RuntimeException("sȌvZ");
			}
			public String toString() {
				return ")";
			}
		};
		/** _萔F^ */
		private static final Term TERM_TRUE = new AbstractValiable() {
			public String toString() {
				return "true";
			}
			public boolean booleanValue() {
				return true;
			}
		};
		/** _萔FU */
		private static final Term TERM_FALSE = new AbstractValiable() {
			public String toString() {
				return "false";
			}
			public boolean booleanValue() {
				return false;
			}
		};
		/** 萔F~ */
		private static final Term TERM_PI = new AbstractValiable() {
			public String toString() {
				return "pi";
			}
			public double doubleValue() {
				return Math.PI;
			}
		};
		/** ZpZqFׂ */
		private static final Term TERM_OPR_POW = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.pow(d2, d1)), operations);
			}
			public int getPriority() {
				return 4;
			}
			public String toString() {
				return "^";
			}
		};
		/** ZpZqF */
		private static final Term TERM_OPR_MUL = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(d2 * d1), operations);
			}
			public int getPriority() {
				return 4;
			}
			public String toString() {
				return "*";
			}
		};
		/** ZpZqF] */
		private static final Term TERM_OPR_DIV = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(d2 / d1), operations);
			}
			public int getPriority() {
				return 4;
			}
			public String toString() {
				return "/";
			}
		};
		/** ZpZqFa */
		private static final Term TERM_OPR_ADD = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(d2 + d1), operations);
			}
			public void convHandle(String token, Expression rp, Stack operations) {
				if (rp.isTermIsVariable()) {
					super.convHandle(token, rp, operations);
				}
			}
			public int getPriority() {
				return 5;
			}
			public String toString() {
				return "+";
			}
		};
		/** ZpZqF */
		private static final Term TERM_OPR_SUB = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(d2 - d1), operations);
			}
			public void convHandle(String token, Expression rp, Stack operations) {
				if (rp.isTermIsVariable()) {
					super.convHandle(token, rp, operations);
				} else {
					rp.push(TERM_OPR_MUL, operations);
					rp.push(new TermDouble(-1), operations);
					//	                rp.send(new TermDouble(-1));
					//	                rp.send(MultiplyOperetor.getInstance());
					rp.setTermIsVariable(false);
				}
			}
			public int getPriority() {
				return 5;
			}
			public String toString() {
				return "-";
			}
		};
		/** _ZqFے */
		private static final Term TERM_OPR_NOT = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				boolean b1 = ((AbstractValiable) rp.pop(operations)).booleanValue();
				rp.push(!b1 ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public void convHandle(String token, Expression rp, Stack operations) {
				super.convHandle(token, rp, operations);
			}
			public int getPriority() {
				return 2;
			}
			public String toString() {
				return "!";
			}
		};
		/** _ZqF< */
		private static final Term TERM_OPR_LT = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 < d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 7;
			}
			public String toString() {
				return "<";
			}
		};
		/** _ZqF<= */
		private static final Term TERM_OPR_LE = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 <= d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 7;
			}
			public String toString() {
				return "<=";
			}
		};
		/** _ZqF> */
		private static final Term TERM_OPR_GT = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 > d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 7;
			}
			public String toString() {
				return ">";
			}
		};
		/** _ZqF>= */
		private static final Term TERM_OPR_GE = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 >= d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 7;
			}
			public String toString() {
				return ">=";
			}
		};
		/** _ZqF== */
		private static final Term TERM_OPR_EQ = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 == d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 8;
			}
			public String toString() {
				return "==";
			}
		};
		/** _ZqF!= */
		private static final Term TERM_OPR_NE = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				double d2 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push((d2 != d1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 8;
			}
			public String toString() {
				return "!=";
			}
		};
		/** _ZqF&& */
		private static final Term TERM_OPR_AND = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				boolean b1 = ((AbstractValiable) rp.pop(operations)).booleanValue();
				boolean b2 = ((AbstractValiable) rp.pop(operations)).booleanValue();
				rp.push((b2 && b1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 12;
			}
			public String toString() {
				return "&&";
			}
		};
		/** _ZqF|| */
		private static final Term TERM_OPR_OR = new AbstractOperator() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				boolean b1 = ((AbstractValiable) rp.pop(operations)).booleanValue();
				boolean b2 = ((AbstractValiable) rp.pop(operations)).booleanValue();
				rp.push((b2 || b1) ? TermFactory.TERM_TRUE : TermFactory.TERM_FALSE, operations);
			}
			public int getPriority() {
				return 13;
			}
			public String toString() {
				return "||";
			}
		};
		/** Zp֐FABS */
		private static final Term TERM_FUN_ABS = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.abs(d1)), operations);
			}
			public String toString() {
				return "abs";
			}
		};
		/** Zp֐FSIN */
		private static final Term TERM_FUN_SIN = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.sin(d1)), operations);
			}
			public String toString() {
				return "sin";
			}
		};
		/** Zp֐FCOS */
		private static final Term TERM_FUN_COS = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.cos(d1)), operations);
			}
			public String toString() {
				return "cos";
			}
		};
		/** Zp֐FTAN */
		private static final Term TERM_FUN_TAN = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.tan(d1)), operations);
			}
			public String toString() {
				return "tan";
			}
		};
		/** Zp֐FASIN */
		private static final Term TERM_FUN_ASIN = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.asin(d1)), operations);
			}
			public String toString() {
				return "asin";
			}
		};
		/** Zp֐FACOS */
		private static final Term TERM_FUN_ACOS = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.acos(d1)), operations);
			}
			public String toString() {
				return "acos";
			}
		};
		/** Zp֐FATAN*/
		private static final Term TERM_FUN_ATAN = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.atan(d1)), operations);
			}
			public String toString() {
				return "atan";
			}
		};
		/** Zp֐FSQRT */
		private static final Term TERM_FUN_SQRT = new AbstractFunction() {
			public void calcHandle(Expression rp, Stack operations) throws WifeException {
				double d1 = ((AbstractValiable) rp.pop(operations)).doubleValue();
				rp.push(new TermDouble(Math.sqrt(d1)), operations);
			}
			public String toString() {
				return "sqrt";
			}
		};

		static {
			opes = new HashMap();
			// 萔
			opes.put(TERM_END.toString(), TERM_END);
			opes.put(TERM_BRA.toString(), TERM_BRA);
			opes.put(TERM_CKET.toString(), TERM_CKET);
			// 萔
			opes.put(TERM_TRUE.toString(), TERM_TRUE);
			opes.put(TERM_FALSE.toString(), TERM_FALSE);
			opes.put(TERM_PI.toString(), TERM_PI);
			// ZpZq
			opes.put(TERM_OPR_POW.toString(), TERM_OPR_POW);
			opes.put(TERM_OPR_MUL.toString(), TERM_OPR_MUL);
			opes.put(TERM_OPR_DIV.toString(), TERM_OPR_DIV);
			opes.put(TERM_OPR_ADD.toString(), TERM_OPR_ADD);
			opes.put(TERM_OPR_SUB.toString(), TERM_OPR_SUB);
			// _Zq
			opes.put(TERM_OPR_NOT.toString(), TERM_OPR_NOT);
			opes.put(TERM_OPR_LT.toString(), TERM_OPR_LT);
			opes.put(TERM_OPR_LE.toString(), TERM_OPR_LE);
			opes.put(TERM_OPR_GT.toString(), TERM_OPR_GT);
			opes.put(TERM_OPR_GE.toString(), TERM_OPR_GE);
			opes.put(TERM_OPR_EQ.toString(), TERM_OPR_EQ);
			opes.put(TERM_OPR_NE.toString(), TERM_OPR_NE);
			opes.put(TERM_OPR_AND.toString(), TERM_OPR_AND);
			opes.put(TERM_OPR_OR.toString(), TERM_OPR_OR);
			// Zp֐
			opes.put(TERM_FUN_ABS.toString(), TERM_FUN_ABS);
			opes.put(TERM_FUN_SIN.toString(), TERM_FUN_SIN);
			opes.put(TERM_FUN_COS.toString(), TERM_FUN_COS);
			opes.put(TERM_FUN_TAN.toString(), TERM_FUN_TAN);
			opes.put(TERM_FUN_ASIN.toString(), TERM_FUN_ASIN);
			opes.put(TERM_FUN_ACOS.toString(), TERM_FUN_ACOS);
			opes.put(TERM_FUN_ATAN.toString(), TERM_FUN_ATAN);
			opes.put(TERM_FUN_SQRT.toString(), TERM_FUN_SQRT);
		}

		private TermFactory() {}

		/**
		 * `ςݍڂ܂
		 * @param token
		 * @return
		 */
		public static Term getOperator(String token) {
			return (Term) TermFactory.opes.get(token);
		}
		/**
		 * `ςݍڂAΐVɃIuWFNg𐶐܂
		 * 擪ȂdoubleƂĐAȊO͕ϐƂĐ܂B
		 * @param token
		 * @param
		 * @return
		 */
		public static Term createTerm(String token, boolean isEnableInitialMode, Stack operations) {
			Term state = getOperator(token.toLowerCase());
			if (state == null) {
				if (token.charAt(0) >= '0' && token.charAt(0) <= '9')
					return new TermDouble(Double.parseDouble(token));
				else
					return new TermValiable(token, isEnableInitialMode);
			}
			return state;
		}
	}
	/**
	 * g[NɕNX
	 * @version 1.0
	 * @author Youhei Horikawa <hori@users.sourceforge.jp>
	 */
	private class ExpressionTokenizer {
		private String expression;
		private int nextPos;
		/**
		 * RXgN^
		 * @param expression
		 */
		public ExpressionTokenizer(String expression) {
			this.expression = expression;
			nextPos = 0;
		}
		/**
		 * g[N擾\ǂ܂
		 * @return
		 */
		public boolean hasMoreTokens() {
			char ch;
			do {
				if (nextPos >= expression.length())
					return false;
				ch = expression.charAt(nextPos++);
			} while (isGap(ch));
			nextPos--;
			return true;
		}
		/**
		 * g[N擾܂
		 * @return
		 */
		public String nextToken() {
			char ch;
			// 擪̋󔒂ǂݔ΂
			do {
				if (nextPos >= expression.length())
					return null;
				ch = expression.charAt(nextPos++);
			} while (isGap(ch));
			StringBuffer token = new StringBuffer();
			if (isLeterOrNo(ch)) {
				// p
				do {
					token.append(ch);
					if (nextPos >= expression.length())
						return token.toString();
					ch = expression.charAt(nextPos++);
				} while (isLeterOrNo(ch));
			} else if (isBracket(ch)) {
				// 
				token.append(ch);
				nextPos++;
			} else {
				// Li󔒂pʂ܂Łj
				do {
					token.append(ch);
					if (nextPos >= expression.length())
						return token.toString();
					ch = expression.charAt(nextPos++);
				} while (!isGap(ch) && !isLeterOrNo(ch) && !isBracket(ch));
				// t@Ngɓo^ς݂̃Iy[VłȂ΁APɂ
				while (1 < token.length() && TermFactory.getOperator(token.toString()) == null) {
					token.deleteCharAt(token.length() - 1);
					nextPos--;
				}
			}
			nextPos--; // Ǎ݈ʒu
			return token.toString();
		}
		/**
		 * chʂǂ܂
		 * @param ch
		 * @return
		 */
		private boolean isBracket(char ch) {
			return (0 <= "()".indexOf(ch));
		}
		/**
		 * ch؂肩ǂ܂
		 * @param ch
		 * @return
		 */
		private boolean isGap(char ch) {
			return (0 <= " \t\r\f\n,".indexOf(ch));
		}
		/**
		 * chpǂ܂
		 * @param ch
		 * @return
		 */
		private boolean isLeterOrNo(char ch) {
			if (('a' <= ch && ch <= 'z')
				|| ('A' <= ch && ch <= 'Z')
				|| ('0' <= ch && ch <= '9')
				|| ch == '_'
				|| ch == '.') {
				return true;
			}
			return false;
		}
	}
}
