/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.ngraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.F11.scada.applet.ngraph.model.GraphModel;

/**
 * ghOt̃vpeBBghvpeBǉꍇ́AGfB^p̃NXTrend3DataTrendRuleSetύXĉB
 *
 * @author maekawa
 *
 */
public class GraphProperties {
	/** ̃vpeB[̃Xi[ */
	private final PropertyChangeSupport changeSupport;
	/** ّS\̉sNZ */
	private int horizontalForAllSpanMode;
	/** ٗ\̉sNZ */
	private int horizontalForSelectSpanMode;
	/** ڐ̐ */
	private int horizontalCount;
	/** ڐ̎ԃXP[ */
	private long horizontalLineSpan;
	/** t\tH[}bg */
	private String dateFormat;
	/** ԕ\tH[}bg */
	private String timeFormat;
	/** cڐ1̃sNZ */
	private int verticalScale;
	/** cڐ̐ */
	private int verticalCount;
	/** cڐ̃sNZ */
	private int verticalLine;
	/** ڐ̃sNZ */
	private int scalePixcelSize;
	/** [hcڐ̐ */
	private int compositionVerticalCount;
	/** OtGA̗] */
	private Insets insets;
	/** gptHg */
	private Font font;
	/** ̐F */
	private Color lineColor;
	/** wiF */
	private Color backGround;
	/** OtGÃObhF */
	private Color verticalScaleColor;
	/** V[YO[ṽXg */
	private List<SeriesGroup> seriesGroups;
	/** JgO[vNo. */
	private int groupNo;
	/** y[W`t@C */
	private String pagefile;
	/** XP[ύX{^̃vpeB[ */
	private List<HorizontalScaleButtonProperty> horizontalScaleButtonProperty;
	/** ghOtő\R[h */
	private int maxRecord;
	/** c[o[\̗L */
	private boolean isVisibleToolbar;
	/** V[Y\̗L */
	private boolean isVisibleSeries;
	/** Xe[^X\̗L */
	private boolean isVisibleStatus;
	/** XN[o[\̗L */
	private boolean isVisibleScroolbar;
	/** Qƈʒu\̗L */
	private boolean isVisibleReferenceLine;
	/** cXP[\̗L */
	private boolean isVisibleVerticalString;
	/** ݂̍E\[h */
	private boolean isCompositionMode = true;
	/** ݂̃Xp\[h */
	private boolean isAllSpanDisplayMode;
	/** gh{^̕\/\ */
	private boolean isShowTrendOpButton;
	/** OXP[\AcXP[̊Ԋu(l56) */
	private int verticalLineInterval;

	public GraphProperties() {
		changeSupport = new PropertyChangeSupport(this);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		changeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		changeSupport.removePropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListeners() {
		PropertyChangeListener[] l = changeSupport.getPropertyChangeListeners();
		for (PropertyChangeListener listener : l) {
			changeSupport.removePropertyChangeListener(listener);
		}
	}

	/**
	 * cڐ̃sNZ擾܂B
	 *
	 * @return cڐ̃sNZ
	 */
	public int getVerticalLine() {
		if (verticalLine == 0) {
			verticalLine = verticalScale * compositionVerticalCount;
		}
		return verticalLine;
	}

	/**
	 * cڐ1̃sNZ擾܂B
	 *
	 * @return cڐ1̃sNZ
	 */
	public int getVerticalScale() {
		return verticalScale;
	}

	/**
	 * cڐ1̃sNZݒ肵܂B
	 *
	 * @param verticalScale cڐ1̃sNZ
	 */
	public void setVerticalScale(int verticalScale) {
		this.verticalScale = verticalScale;
	}

	/**
	 * cڐ̐擾܂B
	 *
	 * @return cڐ̐
	 */
	public int getVerticalCount() {
		return verticalCount;
	}

	/**
	 * cڐ̐ݒ肵܂B
	 *
	 * @param verticalCount cڐ̐
	 */
	public void setVerticalCount(int verticalCount) {
		this.verticalCount = verticalCount;
	}

	/**
	 * [hcڐ̐擾܂B
	 *
	 * @return [hcڐ̐
	 */
	public int getCompositionVerticalCount() {
		return compositionVerticalCount;
	}

	/**
	 * [hcڐ̐ݒ肵܂B
	 *
	 * @param compositionVerticalCount [hcڐ̐
	 */
	public void setCompositionVerticalCount(int compositionVerticalCount) {
		this.compositionVerticalCount = compositionVerticalCount;
	}

	/**
	 * ̑sNZ
	 *
	 * @param isAllSpanDisplayMode XpS\[hȂ true 𗪕\[hȂ false w
	 *
	 * @return ̑sNZ
	 */
	public int getHorizontalLine(boolean isAllSpanDisplayMode) {
		return getHorizontalScale(isAllSpanDisplayMode) * horizontalCount;
	}

	/**
	 * ڐ̃sNZ擾܂B
	 *
	 * @return ڐ̃sNZ
	 */
	public int getScalePixcelSize() {
		return scalePixcelSize;
	}

	/**
	 * ڐ̃sNZݒ肵܂B
	 *
	 * @param scalePixcelSize ڐ̃sNZ
	 */
	public void setScalePixcelSize(int scalePixcelSize) {
		this.scalePixcelSize = scalePixcelSize;
	}

	/**
	 * ڐ̎ԃXP[擾܂B
	 *
	 * @return ڐ̎ԃXP[
	 */
	public long getHorizontalLineSpan() {
		return horizontalLineSpan;
	}

	/**
	 * ڐ̎ԃXP[ݒ肵܂B
	 *
	 * @param horizontalLineSpan ڐ̎ԃXP[
	 */
	public void setHorizontalLineSpan(long horizontalLineSpan) {
		this.horizontalLineSpan = horizontalLineSpan;
	}

	/**
	 * 1ڐ̒(sNZ)
	 *
	 * @param isAllSpanDisplayMode
	 *
	 * @return 1ڐ̒(sNZ)
	 */
	public int getHorizontalScale(boolean isAllSpanDisplayMode) {
		return isAllSpanDisplayMode
			? horizontalForAllSpanMode
			: horizontalForSelectSpanMode;
	}

	/**
	 * ّS\̉sNZݒ肵܂B
	 *
	 * @param horizontalForAllSpanMode ّS\̉sNZ
	 */
	public void setHorizontalForAllSpanMode(int horizontalForAllSpanMode) {
		this.horizontalForAllSpanMode = horizontalForAllSpanMode;
	}

	/**
	 * ٗ\̉sNZݒ肵܂B
	 *
	 * @param horizontalForSelectSpanMode ٗ\̉sNZ
	 */
	public void setHorizontalForSelectSpanMode(int horizontalForSelectSpanMode) {
		this.horizontalForSelectSpanMode = horizontalForSelectSpanMode;
	}

	/**
	 * ڐ̐擾܂B
	 *
	 * @return ڐ̐
	 */
	public int getHorizontalCount() {
		return horizontalCount;
	}

	/**
	 * ڐ̐ݒ肵܂B
	 *
	 * @param horizontalCount ڐ̐
	 */
	public void setHorizontalCount(int horizontalCount) {
		this.horizontalCount = horizontalCount;
	}

	/**
	 * t\tH[}bg擾܂B
	 *
	 * @return t\tH[}bg
	 */
	public String getDateFormat() {
		return dateFormat;
	}

	/**
	 * t\tH[}bgݒ肵܂B
	 *
	 * @param dateFormat t\tH[}bg
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}

	/**
	 * ԕ\tH[}bg擾܂B
	 *
	 * @return ԕ\tH[}bg
	 */
	public String getTimeFormat() {
		return timeFormat;
	}

	/**
	 * ԕ\tH[}bgݒ肵܂B
	 *
	 * @param timeFormat ԕ\tH[}bg
	 */
	public void setTimeFormat(String timeFormat) {
		this.timeFormat = timeFormat;
	}

	/**
	 * OtGA̗]擾܂B
	 *
	 * @return OtGA̗]
	 */
	public Insets getInsets() {
		return insets;
	}

	/**
	 * OtGA̗]ݒ肵܂B
	 *
	 * @param insets OtGA̗]
	 */
	public void setInsets(Insets insets) {
		this.insets = insets;
	}

	/**
	 * gptHg擾܂B
	 *
	 * @return gptHg
	 */
	public Font getFont() {
		return font;
	}

	/**
	 * gptHgݒ肵܂B
	 *
	 * @param font gptHg
	 */
	public void setFont(Font font) {
		this.font = font;
	}

	/**
	 * ̐F擾܂B
	 *
	 * @return ̐F
	 */
	public Color getLineColor() {
		return lineColor;
	}

	/**
	 * ̐Fݒ肵܂B
	 *
	 * @param lineColor ̐F
	 */
	public void setLineColor(Color lineColor) {
		this.lineColor = lineColor;
	}

	/**
	 * wiF擾܂B
	 *
	 * @return wiF
	 */
	public Color getBackGround() {
		return backGround;
	}

	/**
	 * wiFݒ肵܂B
	 *
	 * @param backGround wiF
	 */
	public void setBackGround(Color backGround) {
		this.backGround = backGround;
	}

	/**
	 * OtGÃObhF擾܂B
	 *
	 * @return OtGÃObhF
	 */
	public Color getVerticalScaleColor() {
		return verticalScaleColor;
	}

	/**
	 * OtGÃObhFݒ肵܂B
	 *
	 * @param verticalScaleColor OtGÃObhF
	 */
	public void setVerticalScaleColor(Color verticalScaleColor) {
		this.verticalScaleColor = verticalScaleColor;
	}

	/**
	 * V[YO[vɒǉ܂B
	 *
	 * @param s V[YO[vɒǉ܂B
	 */
	public void setSeriesGroup(List<SeriesGroup> s) {
		seriesGroups = new ArrayList<SeriesGroup>(s);
	}

	/**
	 * JgO[vNo.̃V[YO[vԂ܂B
	 *
	 * @return JgO[vNo.̃V[YO[vԂ܂B
	 */
	public SeriesGroup getSeriesGroup() {
		return seriesGroups.get(groupNo);
	}

	/**
	 * V[YO[ṽXg擾܂B
	 *
	 * @return V[YO[ṽXg
	 */
	public List<SeriesGroup> getSeriesGroups() {
		return Collections.unmodifiableList(seriesGroups);
	}

	/**
	 * JgO[vNo.擾܂B
	 *
	 * @return JgO[vNo.
	 */
	public int getGroupNo() {
		return groupNo;
	}

	/**
	 * JgO[vNo.ݒ肵܂B
	 *
	 * @param groupNo JgO[vNo.
	 */
	public boolean setGroupNo(int groupNo) {
		boolean validGroupNo = isValidGroupNo(groupNo);
		if (validGroupNo) {
			int old = this.groupNo;
			this.groupNo = groupNo;
			changeSupport.firePropertyChange(
				GraphModel.GROUP_CHANGE,
				old,
				this.groupNo);
		}
		return validGroupNo;
	}

	private boolean isValidGroupNo(int groupNo) {
		return 0 <= groupNo && seriesGroups.size() - 1 >= groupNo;
	}

	/**
	 * y[W`t@C擾܂B
	 *
	 * @return y[W`t@C
	 */
	public String getPagefile() {
		return pagefile;
	}

	/**
	 * y[W`t@Cݒ肵܂B
	 *
	 * @param pagefile y[W`t@C
	 */
	public void setPagefile(String pagefile) {
		this.pagefile = pagefile;
	}

	/**
	 * ّS\̉sNZ擾܂B
	 *
	 * @return ّS\̉sNZ
	 */
	public int getHorizontalForAllSpanMode() {
		return horizontalForAllSpanMode;
	}

	/**
	 * ٗ\̉sNZ擾܂B
	 *
	 * @return ٗ\̉sNZ
	 */
	public int getHorizontalForSelectSpanMode() {
		return horizontalForSelectSpanMode;
	}

	/**
	 * XP[ύX{^̃vpeB[擾܂B
	 *
	 * @return XP[ύX{^̃vpeB[
	 */
	public List<HorizontalScaleButtonProperty> getHorizontalScaleButtonProperty() {
		return horizontalScaleButtonProperty;
	}

	/**
	 * XP[ύX{^̃vpeB[ݒ肵܂B
	 *
	 * @param horizontalScaleButtonProperty XP[ύX{^̃vpeB[
	 */
	public void setHorizontalScaleButtonProperty(List<HorizontalScaleButtonProperty> horizontalScaleButtonProperty) {
		this.horizontalScaleButtonProperty = horizontalScaleButtonProperty;
	}

	/**
	 * ghOtő\R[h擾܂B
	 *
	 * @return ghOtő\R[h
	 */
	public int getMaxRecord() {
		return maxRecord;
	}

	/**
	 * ghOtő\R[hݒ肵܂B
	 *
	 * @param maxRecord ghOtő\R[h
	 */
	public void setMaxRecord(int maxRecord) {
		this.maxRecord = maxRecord;
	}

	/**
	 * c[o[\̗L擾܂B
	 *
	 * @return c[o[\̗L
	 */
	public boolean isVisibleToolbar() {
		return isVisibleToolbar;
	}

	/**
	 * c[o[\̗Lݒ肵܂B
	 *
	 * @param isVisibleToolbar c[o[\̗L
	 */
	public void setVisibleToolbar(boolean isVisibleToolbar) {
		this.isVisibleToolbar = isVisibleToolbar;
	}

	/**
	 * V[Y\̗L擾܂B
	 *
	 * @return V[Y\̗L
	 */
	public boolean isVisibleSeries() {
		return isVisibleSeries;
	}

	/**
	 * V[Y\̗Lݒ肵܂B
	 *
	 * @param isVisibleSeries V[Y\̗L
	 */
	public void setVisibleSeries(boolean isVisibleSeries) {
		this.isVisibleSeries = isVisibleSeries;
	}

	/**
	 * Xe[^X\̗L擾܂B
	 *
	 * @return Xe[^X\̗L
	 */
	public boolean isVisibleStatus() {
		return isVisibleStatus;
	}

	/**
	 * Xe[^X\̗Lݒ肵܂B
	 *
	 * @param isVisibleStatus Xe[^X\̗L
	 */
	public void setVisibleStatus(boolean isVisibleStatus) {
		this.isVisibleStatus = isVisibleStatus;
	}

	/**
	 * XN[o[\̗L擾܂B
	 *
	 * @return XN[o[\̗L
	 */
	public boolean isVisibleScroolbar() {
		return isVisibleScroolbar;
	}

	/**
	 * XN[o[\̗Lݒ肵܂B
	 *
	 * @param isVisibleScroolbar XN[o[\̗L
	 */
	public void setVisibleScroolbar(boolean isVisibleScroolbar) {
		this.isVisibleScroolbar = isVisibleScroolbar;
	}

	/**
	 * Qƈʒu\̗L擾܂B
	 *
	 * @return Qƈʒu\̗L
	 */
	public boolean isVisibleReferenceLine() {
		return isVisibleReferenceLine;
	}

	/**
	 * Qƈʒu\̗Lݒ肵܂B
	 *
	 * @param isVisibleReferenceLine Qƈʒu\̗L
	 */
	public void setVisibleReferenceLine(boolean isVisibleReferenceLine) {
		this.isVisibleReferenceLine = isVisibleReferenceLine;
	}

	/**
	 * cXP[\̗L擾܂B
	 *
	 * @return cXP[\̗L
	 */
	public boolean isVisibleVerticalString() {
		return isVisibleVerticalString;
	}

	/**
	 * cXP[\̗Lݒ肵܂B
	 *
	 * @param isVisibleVerticalString cXP[\̗L
	 */
	public void setVisibleVerticalString(boolean isVisibleVerticalString) {
		this.isVisibleVerticalString = isVisibleVerticalString;
	}

	/**
	 * ݂̍E\[h擾܂B
	 *
	 * @return ݂̍E\[h
	 */
	public boolean isCompositionMode() {
		return isCompositionMode;
	}

	/**
	 * ݂̍E\[hݒ肵܂B
	 *
	 * @param isCompositionMode ݂̍E\[h
	 */
	public void setCompositionMode(boolean isCompositionMode) {
		this.isCompositionMode = isCompositionMode;
	}

	/**
	 * ݂̃Xp\[h擾܂B
	 *
	 * @return ݂̃Xp\[h
	 */
	public boolean isAllSpanDisplayMode() {
		return isAllSpanDisplayMode;
	}

	/**
	 * ݂̃Xp\[hݒ肵܂B
	 *
	 * @param isAllSpanDisplayMode ݂̃Xp\[h
	 */
	public void setAllSpanDisplayMode(boolean isAllSpanDisplayMode) {
		this.isAllSpanDisplayMode = isAllSpanDisplayMode;
	}

	/**
	 * gh{^̕\/\擾܂B
	 *
	 * @return gh{^̕\/\
	 */
	public boolean isShowTrendOpButton() {
		return isShowTrendOpButton;
	}

	/**
	 * gh{^̕\/\ݒ肵܂B
	 *
	 * @param isShowTrendOpButton gh{^̕\/\
	 */
	public void setShowTrendOpButton(boolean isShowTrendOpButton) {
		this.isShowTrendOpButton = isShowTrendOpButton;
	}

	/**
	 * cXP[̕\ԊuԂ܂
	 *
	 * @return cXP[̕\ԊuԂ܂
	 */
	public int getVerticalLineInterval() {
		return verticalLineInterval;
	}

	/**
	 * cXP[̕\Ԋuݒ肵܂
	 *
	 * @param verticalLineInterval cXP[̕\Ԋuݒ肵܂
	 */
	public void setVerticalLineInterval(int verticalLineInterval) {
		this.verticalLineInterval = verticalLineInterval;
	}

}
