/*
 * Project F-11 - Web SCADA for Java
 * Copyright (C) 2002-2008 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.ngraph;

import java.awt.Color;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.Manager;

import org.F11.scada.data.ConvertValue;
import org.F11.scada.data.WifeDataAnalog;
import org.F11.scada.data.WifeDataDigital;
import org.F11.scada.server.register.HolderString;
import org.F11.scada.xwife.server.WifeDataProvider;
import org.apache.log4j.Logger;

/**
 * V[YX̃vpeB[
 *
 * @author maekawa
 *
 */
public class SeriesProperties {
	private final Logger logger = Logger.getLogger(SeriesProperties.class);
	/** V[ỸCfbNX */
	private int index;
	/** \E\ */
	private Boolean visible;
	/** F */
	private Color color;
	/** @ԍ */
	private String unit;
	/** @햼 */
	private String name;
	/** Qƒl */
	private Float referenceValue;
	/** PʋL */
	private String unitMark;
	/** ڐl̃tH[}bg */
	private String verticalFormat;
	/** \ől */
	private float max;
	/** \ŏl */
	private float min;
	/** ݒl̃z_ID */
	private HolderString holderString;

	/**
	 * V[ỸCfbNX
	 *
	 * @return V[ỸCfbNX
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * V[ỸCfbNXݒ肵܂
	 *
	 * @param index V[ỸCfbNX
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * V[Y̐F
	 *
	 * @return V[Y̐F
	 */
	public Color getColor() {
		return color;
	}

	/**
	 * V[Y̐Fݒ肵܂B
	 *
	 * @param color V[Y̐F
	 */
	public void setColor(Color color) {
		this.color = color;
	}

	/**
	 * cXP[̖ڐl\tH[}bg
	 *
	 * @return cXP[̖ڐl\tH[}bg
	 */
	public String getVerticalFormat() {
		return verticalFormat;
	}

	/**
	 * cXP[̖ڐl\tH[}bgݒ
	 *
	 * @param verticalFormat cXP[̖ڐl\tH[}bg
	 */
	public void setVerticalFormat(String verticalFormat) {
		this.verticalFormat = verticalFormat;
	}

	/**
	 * V[Y̕\E\
	 *
	 * @return V[Y̕\E\
	 */
	public Boolean isVisible() {
		return visible;
	}

	/**
	 * V[Y̕\E\ݒ
	 *
	 * @param visible V[Y̕\E\
	 */
	public void setVisible(Boolean visible) {
		this.visible = visible;
	}

	/**
	 * @ԍ
	 *
	 * @return @ԍ
	 */
	public String getUnit() {
		return unit;
	}

	/**
	 * @ԍݒ
	 *
	 * @param unit @ԍ
	 */
	public void setUnit(String unit) {
		this.unit = unit;
	}

	/**
	 * @햼
	 *
	 * @return @햼
	 */
	public String getName() {
		return name;
	}

	/**
	 * @햼̂ݒ
	 *
	 * @param name @햼
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Qƒl
	 *
	 * @return Qƒl
	 */
	public Float getReferenceValue() {
		return referenceValue;
	}

	public String getReferenceValueString() {
		if (null == referenceValue) {
			return null;
		} else {
			Manager manager = Manager.getInstance();
			DataHolder hd = manager.findDataHolder(holderString.getHolderId());
			if (hd != null) {
				Object obj = hd.getValue();
				if (obj instanceof WifeDataAnalog) {
					ConvertValue convertValue =
						(ConvertValue) hd
								.getParameter(WifeDataProvider.PARA_NAME_CONVERT);
					double ref =
						convertValue.convertInputValueUnlimited(referenceValue);
					return convertValue.convertStringValueUnlimited(ref);
				} else if (obj instanceof WifeDataDigital) {
					return referenceValue == 1.0F ? "ON" : "OFF";
				} else {
					logger.info("Class=" + obj.getClass().getName());
					return null;
				}
			} else {
				logger.info("Holder null");
				return null;
			}
		}
	}

	/**
	 * Qƒlݒ
	 *
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(Float referenceValue) {
		this.referenceValue = referenceValue;
	}

	/**
	 * ݒl
	 *
	 * @return ݒl
	 */
	public String getNowValue() {
		Manager manager = Manager.getInstance();
		DataHolder hd = manager.findDataHolder(holderString.getHolderId());
		if (hd != null) {
			Object obj = hd.getValue();
			if (obj instanceof WifeDataAnalog) {
				WifeDataAnalog a = (WifeDataAnalog) obj;
				ConvertValue convertValue =
					(ConvertValue) hd
							.getParameter(WifeDataProvider.PARA_NAME_CONVERT);
				return convertValue
						.convertStringValueUnlimited(a.doubleValue());
			} else if (obj instanceof WifeDataDigital) {
				WifeDataDigital d = (WifeDataDigital) obj;
				return d.isOnOff(true) ? "ON" : "OFF";
			} else {
				logger.info("Class=" + obj.getClass().getName());
				return null;
			}
		} else {
			logger.info("Holder null");
			return null;
		}
	}

	/**
	 * Pʖ
	 *
	 * @return Pʖ
	 */
	public String getUnitMark() {
		return unitMark;
	}

	/**
	 * Pʖ̂ݒ
	 *
	 * @param unitMark Pʖ
	 */
	public void setUnitMark(String unitMark) {
		this.unitMark = unitMark;
	}

	/**
	 * V[Y̕\ől
	 *
	 * @return V[Y̕\ől
	 */
	public float getMax() {
		return max;
	}

	/**
	 * V[Y̕\őlݒ
	 *
	 * @param max V[Y̕\ől
	 */
	public void setMax(float max) {
		this.max = max;
	}

	/**
	 * V[Y̕\ŏl
	 *
	 * @return V[Y̕\ŏl
	 */
	public float getMin() {
		return min;
	}

	/**
	 * V[Y̕\ŏlݒ
	 *
	 * @param min V[Y̕\ŏl
	 */
	public void setMin(float min) {
		this.min = min;
	}

	/**
	 * ̃V[YQƂĂz_Ԃ܂
	 *
	 * @return ̃V[YQƂĂz_Ԃ܂
	 */
	public HolderString getHolderString() {
		return holderString;
	}

	/**
	 * ̃V[YQƂĂz_ݒ肵܂
	 *
	 * @param holderString ̃V[YQƂĂz_ݒ肵܂
	 */
	public void setHolderString(HolderString holderString) {
		this.holderString = holderString;
	}
}
