/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.schedule.point;

import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.swing.JDialog;
import javax.swing.event.SwingPropertyChangeSupport;

import org.F11.scada.applet.dialog.WifeDialog;
import org.F11.scada.applet.schedule.GroupElement;
import org.F11.scada.applet.schedule.ScheduleModel;
import org.F11.scada.applet.schedule.ScheduleRowModel;
import org.F11.scada.applet.schedule.ScheduleRowModelImpl;
import org.F11.scada.applet.symbol.SymbolCollection;
import org.F11.scada.applet.symbol.ValueSetter;
import org.F11.scada.data.WifeDataSchedule;
import org.F11.scada.server.schedule.SchedulePointService;
import org.F11.scada.server.schedule.point.dto.SchedulePointRowDto;
import org.F11.scada.util.RmiErrorUtil;
import org.F11.scada.util.RmiUtil;
import org.apache.log4j.Logger;

public class SeparateScheduleModel implements ScheduleModel {
	private final Logger logger = Logger.getLogger(SeparateScheduleModel.class);
	/** oEYvpeBłB */
	private SwingPropertyChangeSupport changeSupport;
	/** XPW[f[^ł */
	private WifeDataSchedule dataSchedule;
	/** XPW[|CgT[rX̎Q */
	private final SchedulePointService schedulePointService;
	/** Ώۍsf[^ */
	private final SchedulePointRowDto rowDto;
	/** eR|[lg */
	private final JDialog dialog;

	/** XPW[fύXCxg */
	private static final String SCHEDULE_MODEL_CHANGE =
		"org.F11.scada.applet.schedule.point.SeparateScheduleModel.SCHEDULE_MODEL_CHANGE";

	public SeparateScheduleModel(SchedulePointRowDto rowDto, JDialog dialog)
			throws RemoteException {
		this((SchedulePointService) RmiUtil
			.lookupServer(SchedulePointService.class), rowDto, dialog);
	}

	public SeparateScheduleModel(
			SchedulePointService schedulePointService,
			SchedulePointRowDto rowDto,
			JDialog dialog) throws RemoteException {
		this.schedulePointService = schedulePointService;
		this.rowDto = rowDto;
		this.dialog = dialog;
		dataSchedule = this.schedulePointService.getSeparateSchedule(rowDto);
	}

	/**
	 * IuWFNgɒlݒ肵܂B
	 * 
	 * @exception RemoteException
	 */
	public void setValue() {
		try {
			SchedulePointUtil.setLoggingField(rowDto);
			schedulePointService.updateSeperateSchedule(
				rowDto,
				new Date(),
				dataSchedule);
		} catch (RemoteException e) {
			RmiErrorUtil.error(logger, e, dialog);
		}
	}

	/**
	 * f[^ҏWꂽꍇ true Ԃ܂B
	 */
	public boolean isEditing() {
		return false;
	}

	/**
	 * ێĂXPW[f[^XV܂B
	 */
	public void writeData() {
	}

	/**
	 * ێĂXPW[f[^AhD܂B
	 */
	public void undoData() {
	}

	/**
	 * XPW[f[^̃O[vw肵CfbNXɕύX܂B
	 * 
	 * @param index O[vCfbNX
	 */
	public void setGroupNo(int index) {
	}

	/**
	 * XPW[p^[̃CfbNXԂ܂B
	 * 
	 * @param index ځijj
	 * @return ڕ\CfbNX
	 */
	public int getDayIndex(int index) {
		return dataSchedule.getDayIndex(index);
	}

	/**
	 * O[vNo ̍ő吔Ԃ܂
	 * 
	 * @return O[vNo ̍ő吔
	 */
	public int getGroupNoMax() {
		return 1;
	}

	/**
	 * XPW[p^[̃CfbNXԂ܂B
	 * 
	 * @param index
	 */
	public String getDayIndexName(int index) {
		return dataSchedule.getDayIndexName(index);
	}

	/**
	 * ̃CfbNXԂ܂B
	 * 
	 * @param index
	 */
	public int getSpecialDayOfIndex(int index) {
		return dataSchedule.getSpecialDayOfIndex(index);
	}

	/**
	 * ڃp^[̃TCYԂ܂B
	 * 
	 * @return ڃp^[̃TCY
	 */
	public int getPatternSize() {
		if (dataSchedule == null) {
			return 0;
		}
		return dataSchedule.getPatternSize();
	}

	/**
	 * XPW[ On/Off ̍ő񐔂Ԃ܂B
	 * 
	 * @return XPW[ On/Off ̍ő
	 */
	public int getNumberSize() {
		return dataSchedule.getNumberSize();
	}

	/**
	 * XPW[sfԂ܂B
	 * 
	 * @param index Ԃs
	 * @return XPW[sfԂ܂B
	 */
	public ScheduleRowModel getScheduleRowModel(int index) {
		return new ScheduleRowModelImpl(this, index);
	}

	/**
	 * f[^fύX邽тɒʒm郊XgɃXi[ǉ܂B
	 * 
	 * @param listener PropertyChangeListener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (changeSupport == null)
			changeSupport = new SwingPropertyChangeSupport(this);
		changeSupport
			.addPropertyChangeListener(SCHEDULE_MODEL_CHANGE, listener);
	}

	/**
	 * f[^fύX邽тɒʒm郊Xg烊Xi[폜܂B
	 * 
	 * @param listener PropertyChangeListener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (changeSupport == null)
			return;
		changeSupport.removePropertyChangeListener(
			SCHEDULE_MODEL_CHANGE,
			listener);
	}

	/**
	 * Xi[ɃoEYvpeBύXCxgʒm܂B
	 * 
	 * @param oldValue ύXO̒l
	 * @param newValue ύX̒l
	 */
	public void firePropertyChange(Object oldValue, Object newValue) {
		if (changeSupport == null)
			return;
		changeSupport.firePropertyChange(
			SCHEDULE_MODEL_CHANGE,
			oldValue,
			newValue);
	}

	/**
	 * O[vNo Ԃ܂
	 */
	public int getGroupNo() {
		return 0;
	}

	/**
	 * O[vǉ܂B
	 * 
	 * @param dataProvider
	 * @param dataHolder
	 * @param flagHolder
	 */
	public void addGroup(
			String dataProvider,
			String dataHolder,
			String flagHolder) {
	}

	/**
	 * ҏWׂ̃_CAOԂ܂B
	 * 
	 * @param window eEBhE
	 * @param collection x[XNX̃CX^X
	 * @param Cӂ̃p[^Xg
	 * @todo Cӂ̃p[^͂A^ׂB
	 */
	public WifeDialog getDialog(
			Window window,
			SymbolCollection collection,
			List para) {
		throw new UnsupportedOperationException();
	}

	/**
	 * ݒ_CAO̍ Point IuWFNgԂ܂B
	 */
	public Point getPoint() {
		throw new UnsupportedOperationException();
	}

	/**
	 * ݒ_CAO̍ Point IuWFNgݒ肵܂B
	 */
	public void setPoint(Point point) {
		throw new UnsupportedOperationException();
	}

	/**
	 * ̃V{̕ҏW\tOݒ肵܂B
	 * 
	 * @param editable ҏW\ɂȂ true łȂ false ݒ肵܂B
	 */
	public void setEditable(boolean[] editable) {
	}

	/**
	 * ̃V{ҏW\ǂԂ܂B
	 * 
	 * @return ҏW\ȏꍇ true łȂ false Ԃ܂B
	 */
	public boolean isEditable() {
		// TODO AccessControlable#checkPermissionŌ
		return true;
	}

	/*
	 * @see org.F11.scada.applet.symbol.Editable#getDestinations()
	 */
	public String[] getDestinations() {
		return new String[0];
	}

	/**
	 * ݐ̒ǉ͂ȂB
	 * 
	 * @see org.F11.scada.applet.symbol.Editable#addDestination(Map)
	 */
	public void addDestination(Map atts) {
	}

	/**
	 * ݐ̒ǉ͂ȂB
	 * 
	 * @see org.F11.scada.applet.symbol.Editable#addElement(Map)
	 */
	public void addValueSetter(ValueSetter setter) {
	}

	/**
	 * O[v̂Ԃ܂
	 * 
	 * @return O[v̂Ԃ܂
	 */
	public String getGroupName() {
		return dataSchedule.getGroupName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.F11.scada.applet.symbol.Editable#isTabkeyMove()
	 */
	public boolean isTabkeyMove() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.F11.scada.applet.schedule.ScheduleModel#disConnect()
	 */
	public void disConnect() {
		removePropertyChangeListeners();
	}
	
	public void removePropertyChangeListeners() {
		if (null != changeSupport) {
			PropertyChangeListener[] liteners =
				changeSupport.getPropertyChangeListeners();
			for (PropertyChangeListener l : liteners) {
				changeSupport.removePropertyChangeListener(l);
			}
		}
	}

	public void duplicateGroup(int[] dest) {
	}

	public void duplicateWeekOfDay(int src, int[] dest) {
	}

	public GroupElement[] getGroupNames() {
		return new GroupElement[0];
	}

	public int getTopSize() {
		return dataSchedule.getTopSize();
	}

	public WifeDataSchedule getDataSchedule() {
		return dataSchedule;
	}

	public void setDataSchedule(WifeDataSchedule schedule) {
		dataSchedule = schedule;
	}

	public boolean isVisible() {
		return true;
	}
}
