/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.applet.symbol;

import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.SwingUtilities;

import org.F11.scada.xwife.applet.AbstractWifeApplet;

/**
 * URLI[vV{NXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class OpenURLSymbol extends Symbol {
	private static final long serialVersionUID = -8303294589313100528L;

	public OpenURLSymbol() {
		this(null);
	}

	public OpenURLSymbol(SymbolProperty property) {
		super(property);
	}

	protected void updatePropertyImpl() {
		setVisible(false);
		
		boolean isOpen = Boolean.valueOf(getProperty("open")).booleanValue();
		
		if (isOpen) {
			AbstractWifeApplet applet =
				(AbstractWifeApplet) SwingUtilities.getAncestorOfClass(AbstractWifeApplet.class, this);
			if (applet == null) {
				throw new IllegalStateException("WifeApplet noting");
			}
		
			if (!applet.isStandAlone()) {
				try {
					showDocument(applet);
				} catch (MalformedURLException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	private void showDocument(Applet applet) throws MalformedURLException {
		AppletContext context = applet.getAppletContext();
		String url = getProperty("url");
		if (url != null) {
			context.showDocument(new URL(url), "_blank");
		} else {
			System.out.println("url not found");
		}
	}
}
