/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/CreateHolderData.java,v 1.4.6.1 2004/11/29 07:12:47 frdm Exp $
 * $Revision: 1.4.6.1 $
 * $Date: 2004/11/29 07:12:47 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.data;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.gr.javacons.jim.QualityFlag;

/**
 * f[^z_[𐶐ׂɕKvȏێNXB
 * WifeDataProviderProxyIuWFNgɁAT[o[RMIoRœ]
 * T[o[ɕێĂDataHolderČ܂B
 * ̃NX͕sσNXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public final class CreateHolderData implements Serializable {
	private static final long serialVersionUID = 4735383098026717379L;
	private final String holderName;
	private final ConvertValue convertValue;
	private final Map demandData;
	private final WifeData wifeData;
	private final Date date;
	private final QualityFlag qualityFlag;
	private final String provider;

	/**
	 * RXgN^
	 * @param holder f[^z_[
	 * @param value f[^l bytez
	 * @param convertValue lϊIuWFNg
	 * @param demandData f}hf[^
	 * @param wifeData lIuWFNg
	 * @param date f[^XV
	 * @param qualityFlag NHeBtO
	 */
	public CreateHolderData(
			String holderName,
			WifeData wifeData,
			ConvertValue convertValue,
			Map demandData,
			Date date,
			QualityFlag qualityFlag,
			String provider) {

	    if (holderName == null) {
			throw new IllegalArgumentException("Argument `holderName' need not null.");
		}
		if (wifeData == null) {
			throw new IllegalArgumentException("Argument `wifeData' need not null.");
		}
	    if (provider == null) {
			throw new IllegalArgumentException("Argument `provider' need not null.");
		}
		this.holderName = holderName;
		this.wifeData = wifeData.valueOf(wifeData.toByteArray());
		this.convertValue = convertValue;
		if (demandData != null) {
			this.demandData = new HashMap(demandData);
		} else {
			this.demandData = null;
		}
		if (date == null) {
			throw new IllegalArgumentException("date is null.");
		}
		if (qualityFlag == null) {
			throw new IllegalArgumentException("qualityFlag is null.");
		}
		this.date = new Date(date.getTime());
		this.qualityFlag = qualityFlag;
		this.provider = provider;
	}

	/**
	 * f[^z_[Ԃ܂B
	 * @return f[^z_[ 
	 */
	public String getHolder() {
		return holderName;
	}
	
	/**
	 * lϊIuWFNgԂ܂B
	 * @return lϊIuWFNg
	 */
	public ConvertValue getConvertValue() {
		return convertValue;
	}

	/**
	 * f}hf[^Ԃ܂B
	 * @return f}hf[^
	 */
	public Map getDemandData() {
		if (demandData != null){
			return Collections.unmodifiableMap(demandData);
		} else {
			return Collections.unmodifiableMap(new HashMap());
		}
	}

	/**
	 * f[^lԂ܂B
	 * @return f[^l
	 */
	public WifeData getWifeData() {
		return wifeData.valueOf(wifeData.toByteArray());
	}
	
	/**
	 * ̃IuWFNg̕`Ԃ܂B
	 * Ԃ镶́AIɕύX\܂BJ̃fobOȊO
	 * gp鎖͐܂B
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer b = new StringBuffer();
		b.append("provider=").append(provider)
		.append(", holderName=").append(holderName)
		.append(", convertValue=").append(convertValue)
		.append(", demandData=").append(demandData)
		.append(", wifeData=").append(wifeData)
		.append(", date=").append(date)
		.append(", qualityFlag=").append(qualityFlag);

		return b.toString();
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new CreateHolderData(
				holderName,
				wifeData,
				convertValue,
				demandData,
				date,
				qualityFlag,
				provider);
	}

	/**
	 * f[^XVԂ܂B
	 * @return f[^XV
	 */
	public Date getDate() {
		return new Date(date.getTime());
	}

	/**
	 * NHeBtOԂ܂B
	 * @return NHeBtO
	 */
	public QualityFlag getQualityFlag() {
		return qualityFlag;
	}

	public String getProvider() {
	    return provider;
	}
}
