/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/DataAccessable.java,v 1.9.2.6 2006/08/11 02:24:33 frdm Exp $
 * $Revision: 1.9.2.6 $
 * $Date: 2006/08/11 02:24:33 $
 *
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.data;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.QualityFlag;

import org.F11.scada.server.alarm.AlarmTableJournal;
import org.F11.scada.server.alarm.table.PointTableBean;
import org.F11.scada.xwife.applet.Session;

/**
 * f[^voC_Ef[^voC_vNVԂ̃[gC^[tFCXłB AvbgoRŃf[^voC_ɃANZXׂ̃C^[tFCXłB
 *
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public interface DataAccessable extends Remote {
	/**
	 * w肳ꂽf[^Ԃ܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @return w肵f[^z_̃f[^IuWFNg
	 * @exception RemoteException RMI G[Ƃ
	 */
	public Object getValue(String dpname, String dhname) throws RemoteException;

	/**
	 * w肳ꂽNIeBtOԂ܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @return w肵f[^z_̃f[^IuWFNg
	 * @exception RemoteException RMI G[Ƃ
	 */
	public QualityFlag getQualityFlag(String dpname, String dhname)
		throws RemoteException;

	/**
	 * f[^z_ɒlIuWFNgݒ肵܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @param dataValue lIuWFNg
	 * @exception RemoteException RMI G[Ƃ
	 */
	public void setValue(String dpname, String dhname, Object dataValue)
		throws RemoteException;

	/**
	 * f[^z_ɒlIuWFNgݒ肵܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @param dataValue lIuWFNg
	 * @param user [U[
	 * @param ip [IP
	 * @exception RemoteException RMI G[Ƃ
	 */
	public void setValue(
		String dpname,
		String dhname,
		Object dataValue,
		String user,
		String ip) throws RemoteException;

	/**
	 * qXge[ůmFtOݒ肵܂B
	 *
	 * @param point |Cgԍ
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @param date XVt
	 * @param row }EXNbNiύXjs
	 * @throws RemoteException RemoteException RMI G[Ƃ
	 */
	public void setHistoryTable(
		Integer point,
		String dpname,
		String dhname,
		Timestamp date,
		Integer row) throws RemoteException;

	/**
	 * w肳ꂽf[^z_Ԃ܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @return ݂ꍇ DataHolder IuWFNgAꍇ null Ԃ܂B
	 * @throws RemoteException RemoteException RMI G[Ƃ
	 */
	public DataHolder findDataHolder(String dpname, String dhname)
		throws RemoteException;

	/**
	 * w肳ꂽf[^z_̃p^Ԃ܂B
	 *
	 * @param dpname f[^voC_
	 * @param dhname f[^z_
	 * @param paraName p^
	 * @return p^IuWFNg
	 * @throws RemoteException RemoteException RMI G[Ƃ
	 */
	public Object getParameta(String dpname, String dhname, String paraName)
		throws RemoteException;

	/**
	 * f[^z_XVf[^Ԃ܂B
	 *
	 * @param provider f[^voC_
	 * @return f[^z_XVf[^ListIuWFNg
	 */
	public List getHoldersData(String provider) throws RemoteException;

	/**
	 * f[^z_XVf[^Ԃ܂B
	 *
	 * @param provider f[^voC_
	 * @param t ێf[^̍ŐVt long l
	 * @return f[^z_XVf[^ListIuWFNg
	 */
	public List getHoldersData(String provider, long t, Session session)
		throws RemoteException;

	/**
	 * T[o[ŎsĂAf[^voC_̔zԂ܂B
	 *
	 * @return f[^voC_̃Xg
	 */
	public List getDataProviders() throws RemoteException;

	/**
	 * f[^z_[IuWFNg̔zԂ܂B
	 *
	 * @param dataProvider f[^voC_
	 * @return CreateHolderData[] f[^z_[IuWFNg̔z
	 */
	public List getCreateHolderDatas(String dataProvider)
		throws RemoteException;

	/**
	 * ^CX^vŎw肳ꂽȏ̃W[if[^Ԃ܂B
	 *
	 * @param t ^CX^vLongl
	 * @param provider f[^voC_[
	 * @param holder f[^z_[
	 * @return SortedMap W[if[^̃Xg
	 */
	public SortedMap<Long, AlarmTableJournal> getAlarmJournal(
		long t,
		String provider,
		String holder) throws RemoteException;

	/**
	 * ^CX^vŎw肳ꂽȏ̃W[if[^Ԃ܂B
	 *
	 * @param t ^CX^vLongl
	 * @return SortedMap XV PointTableBean IuWFNg̃}bv
	 * @since 1.0.3
	 */
	public SortedMap<Long, PointTableBean[]> getPointJournal(long t)
		throws RemoteException;

	/**
	 * f[^z_[IuWFNg̔zԂ܂B
	 *
	 * @param holderStrings f[^z_
	 * @return CreateHolderData[] f[^z_[IuWFNg̔z
	 */
	public List getCreateHolderDatas(Collection holderStrings)
		throws RemoteException;

	/**
	 * T[o[̃R}hĂяo܂B
	 *
	 * @param command R}h
	 * @param args 
	 * @return ߂l΂̓IuWFNgԂAłȂꍇ null ԂB
	 */
	Object invoke(String command, Object[] args) throws RemoteException;
}
