package org.F11.scada.scheduling;

import java.util.TimerTask;


/**
 * XPW[[NXŎs^XNNXłB
 */
public abstract class SchedulerTask implements Runnable {
	/** bN */
    final Object lock = new Object();

	/** s^XN̏ */
    int state = VIRGIN;
    /** XPW[ */
    static final int VIRGIN = 0;
    /** XPW[ */
    static final int SCHEDULED = 1;
    /** ~ */
    static final int CANCELLED = 2;
	/** ^XNNX */
    TimerTask timerTask;

	/**
	 * s^XN𐶐܂B
	 */
    protected SchedulerTask() {}

	/**
	 * XPW[s܂
	 */
    public abstract void run();

	/**
	 * ̎s^XN𒆎~܂
	 * <p>
	 * ̃\bh2ȏĂяoĂ܂B
	 * @return ̃^XNXPW[ true Ԃ܂
	 */
    public boolean cancel() {
        synchronized(lock) {
            if (timerTask != null) {
                timerTask.cancel();
            }
            boolean result = (state == SCHEDULED);
            state = CANCELLED;
            return result;
        }
    }

	/**
	 * ̃^XNŋ߁uۂɁvs悤ɁuXPW[ꂽvsԂԂ܂ (̃\bh^XN̎sɌĂяoꂽꍇA߂l͐is̃^XNs̃XPW[ꂽsԂɂȂ܂)B 
	 * @return ̃^XN̎sŋ߃XPW[ꂽԁBDate.getTime() ŕԂ`B^XN܂sĂȂꍇA߂l͖`
	 */
    public long scheduledExecutionTime() {
        synchronized(lock) {
            return timerTask == null ? 0 : timerTask.scheduledExecutionTime();
        }
    }

}
