package org.F11.scada.security;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.F11.scada.EnvironmentManager;
import org.F11.scada.security.auth.Subject;

/**
 * WIFE ̃ZLeB|V[\NXłB
 * [U[ƃO[vɋꂽp[~bVێ܂B
 * w肵 Subject Af[^z_[̋Ă̂肵܂B
 * ̃NX͗B̃CX^Xێ܂(Singleton p^[)
 */
public class WifePolicy extends Policy {
	/** WifePolicy ̃CX^X */
	private static Policy _policy = new WifePolicy();
	/** WifePrincipal  PermissionCollection ̃nbV}bvł */
	private Map policyMap;
	/** ftHg policyMap t@NgNXł */
	private static final String DEFAULT_POLICYMAP =
			"org.F11.scada.security.postgreSQL.PostgreSQLPolicyMap";

	/**
	 * w肳ꂽ Map NXŁAZLeB|V[܂B
	 * ftHgł́APostgreSQLPolicyMap NXgp܂B
	 */
	private WifePolicy() {
		try {
			init();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * w肳ꂽ Map NXŁAZLeB|V[܂B
	 * @throws ClassNotFoundException Map NXȂꍇ
	 * @throws InstantiationException  Class  abstract NXAC^tF[XA
	 * zNXAv~eBu^A܂ void \ꍇA
	 * NX null RXgN^ێȂꍇA
	 * 邢̓CX^X̐ق̗RŎsꍇ
	 * @throws IllegalAccessException NX܂͂ null RXgN^ɃANZXłȂꍇ
	 */
	private void init()
			throws ClassNotFoundException, InstantiationException, IllegalAccessException {
		policyMap =
				PolicyMapFactory.createPolicyMap(EnvironmentManager.get("/server/policy/policyMap", DEFAULT_POLICYMAP));
	}

	/**
	 * ̃|V[̃CX^XԂ܂B
	 * @return ̃|V[̃CX^X
	 */
	public static Policy getPolicy() {
		return _policy;
	}

	/**
	 * ̃\bh̓T|[gĂ܂B
	 * @param policy Zbg|V[
	 * @throws UnsupportedOperationException  UnsupportedOperationException X[܂
	 */
	public static void setPolicy(Policy policy) {
		throw new UnsupportedOperationException();
	}

	/**
	 * ̃\bh̓T|[gĂ܂B
	 * @param codesource R[h\[X
	 * @return PermissionCollection
	 * @throws UnsupportedOperationException  UnsupportedOperationException X[܂
	 */
	public PermissionCollection getPermissions(CodeSource codesource) {
		throw new UnsupportedOperationException();
	}

	/**
	 * ̃\bh̓T|[gĂ܂B
	 * @param domain ProtectionDomain
	 * @return PermissionCollection
	 * @throws UnsupportedOperationException  UnsupportedOperationException X[܂
	 */
	public PermissionCollection getPermissions(ProtectionDomain domain) {
		throw new UnsupportedOperationException();
	}

	/**
	 * ̃\bh̓T|[gĂ܂B
	 * @param domain ProtectionDomain
	 * @param permission Permission
	 * @return true
	 * @throws UnsupportedOperationException  UnsupportedOperationException X[܂
	 */
	public boolean implies(ProtectionDomain domain, Permission permission) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Subject ɋꂽANZXɂăO[o|V[]A
	 * ̃ANZXĂ邩ǂ𔻒肵܂B
	 * @param subject Ώۂ Subject
	 * @param permission ܂܂Ă邩ǂ𔻒肷 Permission IuWFNg
	 * @return permission  subject ɋꂽANZX̓K؂ȃTuZbg̏ꍇ trueB
	 */
	public boolean implies(Subject subject, Permission permission) {
		Set principals = subject.getPrincipals();
		for (Iterator it = principals.iterator(); it.hasNext();) {
			Principal principal = (Principal) it.next();
			Object o = policyMap.get(principal);
			if (o != null) {
				PermissionCollection pc = (PermissionCollection) o;
//				System.out.println("principal:" + principal + " pc:" + pc);
				if (pc.implies(permission)) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * |V[ݒtbV܂͍ēǂݍ݂܂B
	 * ftHg PostgreSQLPolicyMap NXł́Af[^x[XēǍă|V[č\z܂B
	 */
	public void refresh() {
		try {
			init();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * ̃|V[̕\Ԃ܂B
	 * ̕\@,gpĂ Map Ɉˑ܂BftHg PostgreSQLPolicyMap
	 * ł́AHashMap  toString gp܂B
	 * @return |V[̕\
	 */
	public String toString() {
		return policyMap.toString();
	}
}
