/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/security/auth/Subject.java,v 1.7 2003/01/30 08:24:30 frdm Exp $
 * $Revision: 1.7 $
 * $Date: 2003/01/30 08:24:30 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.security.auth;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * <p>WIFE ɂ̂𒊏ۓIɕ\NXłB
 * ̓Iɂ Subject ɁA֘A[U[ƃO[ṽvVp Set ێ܂B
 * <p>vVpɂ͕sσIuWFNg Set gpĂ̂ŁAvVp̕ύX͂ł܂B
 * ɐVvVpێIuWFNg𐶐ĂB
 * 
 * @author Hideaki Maekawa <frdm@users.sorceforge.jp>
 */
public final class Subject implements Serializable {
	private static final long serialVersionUID = -2449886602280598708L;

	/** vVpȂ̃[U[\Subject NX̃CX^XłB */
	private static final Subject NULL_SUBJECT = new Subject(new HashSet(), "");
	/** vVp Set ł */
	private final Set principals;
	/** ݂̃[U[ł */
	private final String userName;

	/**
	 * vCx[gRXgN^
	 * w肵vVpŏCX^X𐶐܂B
	 * @param set vVp
	 * @param userName [U[
	 */
	private Subject(Set set, String userName) {
		if (set == null) {
			throw new IllegalArgumentException("set is null.");
		}
		if (userName == null) {
			throw new IllegalArgumentException("userName is null.");
		}
		this.principals = Collections.unmodifiableSet(set);
		this.userName = userName;
	}

	/**
	 * Subject IuWFNg𐶐t@Ng[\bhłB
	 * w肳ꂽŏIuWFNgԂ܂B
	 * @param set vVp
	 * @param userName [U[
	 * @return Subject IuWFNg
	 */
	public static Subject createSubject(Set set, String userName) {
		return new Subject(set, userName);
	}

	/**
	 * vVpȂ̃[U[\Subject NX̃CX^XԂ܂B
	 * @return Subject
	 */	
	public static Subject getNullSubject() {
		return NULL_SUBJECT;
	}

	/**
	 *  Subject Ɋ֘AÂꂽAvVp̃ZbgԂ܂B
	 * @return vVp̃Zbg
	 */
	public Set getPrincipals() {
		return principals;
	}

	/**
	 * ݂̃[U[Ԃ܂B
	 */
	public String getUserName() {
		return userName;
	}
	
	/**
	 * ̃IuWFNgƎw肳ꂽIuWFNgr܂B
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof Subject)) {
			return false;
		}
		Subject sub = (Subject)obj;
		return sub.principals.equals(principals)
				&& sub.userName.equals(userName); 
	}

	/**
	 * ̃IuWFNg̃nbVR[hԂ܂B
	 */
	public int hashCode() {
		int result = 17;
		result = 37 * result + principals.hashCode();
		result = 37 * result + userName.hashCode();
		return result;
	}
	
	/**
	 * ̃IuWFNg̕`Ԃ܂B
	 * Ԃ镶́AIɕύX\܂BJ̃fobOȊO
	 * gp鎖͐܂B
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("principals=" + principals.toString());
		buffer.append(" ,userName=" + userName);
		return buffer.toString();
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new Subject(principals, userName);
	}
}
