/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.server.alarm.table;

import java.io.ObjectStreamException;
import java.io.Serializable;

/**
 * point_table ̓e\NXłB
 * <ul>
 * <li>point |CgID
 * <li>unit@|CgL
 * <li>name@|Cg
 * <li>mark@|CgL@Pʖ
 * </ul>
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class PointTableBean implements Serializable {
	/** VACYID */
	private static final long serialVersionUID = -2234470409106572622L;
	/** |CgID */
	private final int point;
	/** |CgL */
	private final String unit;
	/** |Cg */
	private final String name;
	/** |CgL@Pʖ */
	private final String mark;

	/**
	 * ̃IuWFNg܂
	 * 
	 * @param point |CgID
	 * @param unit |CgL
	 * @param name |Cg
	 * @param mark |CgL@Pʖ
	 */
	public PointTableBean(int point, String unit, String name, String mark) {
		this.point = point;
		this.unit = unit;
		this.name = name;
		this.mark = mark;
	}

	/**
	 * |CgLPʖ̂Ԃ܂B
	 * @return |CgLPʖ
	 */
	public String getMark() {
		return mark;
	}

	/**
	 * |CĝԂ܂B
	 * @return |Cg
	 */
	public String getName() {
		return name;
	}

	/**
	 * |CgIDԂ܂B
	 * @return |CgID
	 */
	public int getPoint() {
		return point;
	}

	/**
	 * |CgLԂ܂B
	 * @return |CgL
	 */
	public String getUnit() {
		return unit;
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new PointTableBean(point, unit, name, mark);
	}
	
	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 */
	public String toString() {
		return "{point="
			+ point
			+ ", unit="
			+ unit
			+ ", name="
			+ name
			+ ", mark="
			+ mark
			+ "}";
	}

}
