/*
 * Projrct F-11 - Web SCADA for Java Copyright (C) 2002 Freedom, Inc. All Rights
 * Reserved. This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

package org.F11.scada.server.communicater;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import org.F11.scada.WifeException;
import org.F11.scada.server.event.WifeCommand;
import org.F11.scada.server.event.WifeEventListener;

/**
 * O@Ƃ̒ʐMC^[tF[XłB
 */
public interface Communicater {
	/**
	 * Communicater܂B
	 */
	public void close() throws InterruptedException;

	/**
	 * ǍݒʐMR}h̒ǉBiCӎj 񓯊Ǎ݂œKׁA\ߓo^Ă܂B
	 * @param commands
	 */
	public void addReadCommand(Collection<WifeCommand> commands);

	/**
	 * ǍݒʐMR}h̍폜BiCӎj
	 * @param commands
	 */
	public void removeReadCommand(Collection<WifeCommand> commands);

	/**
	 * ʐMCxg󂯎郊Xi[ǉ܂BiCӎj
	 * @param l Xi[IuWFNg
	 */
	public void addWifeEventListener(WifeEventListener l);

	/**
	 * ʐMCxg󂯎郊Xi[폜܂BiCӎj
	 * @param l Xi[IuWFNg
	 */
	public void removeWifeEventListener(WifeEventListener l);

	/**
	 * Ǎ݁BǍݒʐM܂ŃubN܂BsameDataBalk  true ɂꍇƓlłB
	 * @param commands WifeCommand̃RNV
	 * @return R}hIuWFNg(WifeCommand)ƃoCgz̃}bvԂ܂B
	 */
	public Map<WifeCommand, byte[]> syncRead(Collection<WifeCommand> commands)
			throws InterruptedException, IOException, WifeException;

	/**
	 * Ǎ݁BǍݒʐM܂ŃubN܂B
	 * @param commands WifeCommand̃RNV
	 * @param sameDataBalk true ̏ꍇAOʐMʂꍇ̃}bvԂ܂Bfalse ̏ꍇ͏ɒʐMʂԂ܂B
	 * @return R}hIuWFNg(WifeCommand)ƃoCgz̃}bvԂ܂B
	 */
	public Map<WifeCommand, byte[]> syncRead(Collection<WifeCommand> commands, boolean sameDataBalk)
			throws InterruptedException, IOException, WifeException;

	/**
	 * ݁BݒʐM܂ŃubN܂B
	 * @param commands WifeCommandL[ɂbyte[]Map
	 */
	public void syncWrite(Map<WifeCommand, byte[]> commands)
			throws InterruptedException, IOException, WifeException;
}
