/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.converter;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

import org.F11.scada.WifeException;
import org.F11.scada.WifeUtilities;
import org.F11.scada.server.communicater.Environment;
import org.F11.scada.server.event.WifeCommand;

/**
 * WifeʐMW[MC3ER}h̎NXB
 */
public class MC1E implements Converter {
	/** MC1ER}h wb_ */
	public static final int MC1E_COMMAND_HEADER_LENGTH = 1;
	/** MC1ER}h IR[h */
	public static final int MC1E_COMMAND_ENDCODE_LENGTH = 1;

	/**   D f[^WX^\܂B */
	public static final Integer D_AREA = new Integer(0);
	/**   M [GA\܂B */
	public static final Integer M_AREA = new Integer(1);
	/**   X ̓[GA\܂B */
	public static final Integer X_AREA = new Integer(2);
	/**   Y o̓[GA\܂B */
	public static final Integer Y_AREA = new Integer(3);
	/**   B N[GA\܂B */
	public static final Integer B_AREA = new Integer(4);
	/**   ZR t@CWX^\܂B */
	public static final Integer R_AREA = new Integer(10);
	/**   W NWX^\܂B */
	public static final Integer W_AREA = new Integer(11);

	/** R}hʂ̃}bv */
	private static final Map memoryModeMap;
	static {
		memoryModeMap = new HashMap();
		memoryModeMap.put(D_AREA, new ComndKindWorddev(0x20, 0x44));
		memoryModeMap.put(M_AREA, new ComndKindBitdev(0x20, 0x4d));
		memoryModeMap.put(X_AREA, new ComndKindBitdev(0x20, 0x58));
		memoryModeMap.put(Y_AREA, new ComndKindBitdev(0x20, 0x59));
		memoryModeMap.put(B_AREA, new ComndKindBitdev(0x20, 0x42));
		memoryModeMap.put(R_AREA, new ComndKindWorddev(0x20, 0x52));
		memoryModeMap.put(W_AREA, new ComndKindWorddev(0x20, 0x57));
	}

	/** PCԍ */
	private byte pcno = (byte) 0x00;
	/** CPUĎ^C} */
	private byte[] cpu = {(byte) 0x00, (byte) 0x00 };

	/**
	 *  ftHgRXgN^
	 */
	public MC1E() {
	}

	/** ݒ肵AX|Xwb_ԂB*/
	public byte[] setEnvironment(Environment device) {
		pcno = (byte) (device.getPlcNodeNo() & 0xff);
		cpu[0] = (byte) (device.getPlcWatchWait() % 0x100);
		cpu[1] = (byte) (device.getPlcWatchWait() / 0x100);

		return new byte[] {(byte) 0x81, (byte) 0x00 };
	}

	/** Ǎ݃R}hݒ肷B*/
	public void setReadCommand(WifeCommand commdef) throws WifeException {
		mc1eCommand = READ_MC1ECOMMAND;
		mc1eCommand.setCommand(commdef, pcno, cpu, null);
	}
	/** ݃R}hݒ肷B*/
	public void setWriteCommand(WifeCommand commdef, byte[] data)
		throws WifeException {
		mc1eCommand = WRITE_MC1ECOMMAND;
		mc1eCommand.setCommand(commdef, pcno, cpu, data);
	}

	/** R}h擾\H */
	public boolean hasCommand() {
		return mc1eCommand.hasCommand();
	}

	/** R}h쐬ÃR}h܂B */
	public void nextCommand(ByteBuffer sendBuffer) {
		mc1eCommand.nextCommand(sendBuffer);
	}

	/** OsR}h쐬܂B */
	public void retryCommand(ByteBuffer sendBuffer) {
		mc1eCommand.retryCommand(sendBuffer);
	}

	/** Mf[^ƎMf[^̐܂B */
	public WifeException checkCommandResponce(ByteBuffer recvBuffer)
		throws WifeException {
		byte[] err = { 0, 0 };
		if (recvBuffer.remaining()
			< (MC1E_COMMAND_HEADER_LENGTH + MC1E_COMMAND_ENDCODE_LENGTH)) {
			StringBuffer sb = new StringBuffer();
			sb.append("RecvData (");
			sb.append(WifeUtilities.toString(recvBuffer));
			sb.append(") is short!");
			return new WifeException(
				WifeException.WIFE_ERROR,
				WifeException.WIFE_NET_RESPONCE_ERROR,
				sb.toString() + mc1eCommand.toString());
		}
		// IR[h
		if (recvBuffer.get(1) != (byte) 0x00) {
			StringBuffer sb = new StringBuffer();
			sb.append("End code error: ");
			sb.append(" RecvData (");
			sb.append(WifeUtilities.toString(recvBuffer));
			sb.append(")");
			return new WifeException(
				WifeException.WIFE_ERROR,
				WifeException.WIFE_NET_RESPONCE_ENDCODE_ERROR,
				err,
				sb.toString() + mc1eCommand.toString());
		}
		return null;
	}

	/** Mf[^f[^擾܂B */
	public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
		mc1eCommand.getResponceData(recvBuffer, recvData);
	}

	/** ʐM̍ő咷Ԃ܂B */
	public int getPacketMaxSize(WifeCommand commdef) {
		ComndKind kind =
			(ComndKind) memoryModeMap.get(new Integer(commdef.getMemoryMode()));
		return kind.getReadMaxLen() / 2;
	}

	/** 
	 * \Ԃ܂B 
	 */
	public String toString() {
		return mc1eCommand.toString();
	}

	/**
	 * R}hϊwp[NX̃C^[tFCXłB 
	 */
	private interface Mc1eCommand {
		/** R}hݒ肷B*/
		public void setCommand(
			WifeCommand commdef,
			byte pcno,
			byte[] cpu,
			byte[] data)
			throws WifeException;
		/** R}h擾\H */
		public boolean hasCommand();
		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer);
		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer);

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData);
	}

	/** 
	 * Ǎ݃R}hϊwp[NX̃CX^XłB
	 */
	private final Mc1eCommand READ_MC1ECOMMAND = new Mc1eCommand() {
		/** PCԍ */
		private byte pcno;
		/** CPUĎ^C} */
		private byte[] cpu;
		/** PLC */
		private byte[] memoryMode;
		/** PLCAhX */
		private long memoryAddress;
		/** ׂPLCf[^̎coCg */
		private int restByteLength = 0;
		/** PLCf[^oCg */
		private int thisByteLength = 0;
		/** őPLCf[^oCg */
		private int maxByteLen = 0;
		/** foCXʃwp[NXւ̎Q */
		private ComndKind kind;

		/** R}h̃l^ݒ肷B*/
		public void setCommand(
			WifeCommand commdef,
			byte pcno,
			byte[] cpu,
			byte[] data)
			throws WifeException {
			this.pcno = pcno;
			this.cpu = cpu;
			// foCXʃwp[NX
			kind =
				(ComndKind) memoryModeMap.get(
					new Integer(commdef.getMemoryMode()));
			if (kind == null) {
				throw new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_COMMAND_ERROR,
					"Not supported memory mode " + commdef.getMemoryMode());
			}
			memoryMode = kind.getMemKind();
			memoryAddress = commdef.getMemoryAddress();
			restByteLength = commdef.getWordLength() * 2;
			thisByteLength = 0;
			maxByteLen = kind.getReadMaxLen();
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}
		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			long addr = kind.getAddress(memoryAddress);

			// foCXɈˑ钷𒴂Ă
			if (maxByteLen < restByteLength) {
				thisByteLength = maxByteLen;
				restByteLength -= maxByteLen;
			} else {
				thisByteLength = restByteLength;
				restByteLength = 0;
			}

			// MC1Ewb_̍쐬
			sendBuffer.put((byte) 0x01); // [hǍ
			sendBuffer.put(pcno);
			sendBuffer.put(cpu);
			// foCXAhX
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) ((addr / 0x100) % 0x100));
			sendBuffer.put((byte) ((addr / 0x10000) % 0x100));
			sendBuffer.put((byte) 0x00);
			// foCXR[h
			sendBuffer.put(memoryMode);
			// 
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			sendBuffer.put((byte) 0x00);

			// ̃AhX
			memoryAddress += (thisByteLength / 2);
		}
		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			long addr = kind.getAddress(memoryAddress - (thisByteLength / 2));

			// MC1Ewb_̍쐬
			sendBuffer.put((byte) 0x01); // [hǍ
			sendBuffer.put(pcno);
			sendBuffer.put(cpu);
			// foCXAhX
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) ((addr / 0x100) % 0x100));
			sendBuffer.put((byte) ((addr / 0x10000) % 0x100));
			sendBuffer.put((byte) 0x00);
			// foCXR[h
			sendBuffer.put(memoryMode);
			// 
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			sendBuffer.put((byte) 0x00);
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(
			ByteBuffer recvBuffer,
			ByteBuffer recvData) {
			for (int i =
				MC1E_COMMAND_HEADER_LENGTH + MC1E_COMMAND_ENDCODE_LENGTH;
				i < recvBuffer.remaining();
				i += 2) {
				recvData.put(recvBuffer.get(i + 1));
				recvData.put(recvBuffer.get(i + 0));
			}
		}

		/** 
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("ReadMode:").append("\n");
			s.append("memoryMode:").append(memoryMode).append("\n");
			s.append("memoryAddress:").append(memoryAddress).append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/** 
	 * ݃R}hϊwp[NX̃CX^XłB
	 */
	private final Mc1eCommand WRITE_MC1ECOMMAND = new Mc1eCommand() {
		/** PCԍ */
		private byte pcno;
		/** CPUĎ^C} */
		private byte[] cpu;
		/** PLC */
		private byte[] memoryMode;
		/** PLCAhX */
		private long memoryAddress;
		/** ݃f[^ */
		private byte[] writeData;
		/** ݃f[^ʒu */
		private int writePos;
		/** ׂPLCf[^̎coCg */
		private int restByteLength = 0;
		/** PLCf[^oCg */
		private int thisByteLength = 0;
		/** őPLCf[^oCg */
		private int maxByteLen = 0;
		/** foCXʃwp[NXւ̎Q */
		private ComndKind kind;

		/** R}hݒ肷B*/
		public void setCommand(
			WifeCommand commdef,
			byte pcno,
			byte[] cpu,
			byte[] data)
			throws WifeException {
			this.pcno = pcno;
			this.cpu = cpu;
			// foCXʃwp[NX
			kind =
				(ComndKind) memoryModeMap.get(
					new Integer(commdef.getMemoryMode()));
			if (kind == null) {
				throw new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_COMMAND_ERROR,
					"Not supported memory mode " + commdef.getMemoryMode());
			}
			memoryMode = kind.getMemKind();
			memoryAddress = commdef.getMemoryAddress();
			writeData = data;
			writePos = 0;
			restByteLength = commdef.getWordLength() * 2;
			thisByteLength = 0;
			maxByteLen = kind.getWriteMaxLen();
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			long addr = kind.getAddress(memoryAddress);

			// foCXɈˑ钷𒴂Ă
			if (maxByteLen < restByteLength) {
				thisByteLength = maxByteLen;
				restByteLength -= maxByteLen;
			} else {
				thisByteLength = restByteLength;
				restByteLength = 0;
			}

			// MC3Ewb_̍쐬
			sendBuffer.put((byte) 0x03); // [h
			sendBuffer.put(pcno);
			sendBuffer.put(cpu);
			// foCXAhX
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) ((addr / 0x100) % 0x100));
			sendBuffer.put((byte) ((addr / 0x10000) % 0x100));
			sendBuffer.put((byte) 0x00);
			// foCXR[h
			sendBuffer.put(memoryMode);
			// 
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			sendBuffer.put((byte) 0x00);
			// ݃f[^
			for (int i = writePos; i < (writePos + thisByteLength); i += 2) {
				sendBuffer.put(writeData[i + 1]);
				sendBuffer.put(writeData[i + 0]);
			}

			// ̃AhX
			memoryAddress += (thisByteLength / 2);
			writePos += thisByteLength;
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			long addr = kind.getAddress(memoryAddress - (thisByteLength / 2));
			int pos = writePos - thisByteLength;

			// MC3Ewb_̍쐬
			sendBuffer.put((byte) 0x03); // [h
			sendBuffer.put(pcno);
			sendBuffer.put(cpu);
			// foCXAhX
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) ((addr / 0x100) % 0x100));
			sendBuffer.put((byte) ((addr / 0x10000) % 0x100));
			sendBuffer.put((byte) 0x00);
			// foCXR[h
			sendBuffer.put(memoryMode);
			// 
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			sendBuffer.put((byte) 0x00);
			// ݃f[^
			for (int i = pos; i < (pos + thisByteLength); i += 2) {
				sendBuffer.put(writeData[i + 1]);
				sendBuffer.put(writeData[i + 0]);
			}
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(
			ByteBuffer recvBuffer,
			ByteBuffer recvData) {
		}

		/** 
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("WriteMode:").append("\n");
			s.append("memoryMode:").append(memoryMode).append("\n");
			s.append("memoryAddress:").append(memoryAddress).append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/** R}hϊNX */
	private Mc1eCommand mc1eCommand = READ_MC1ECOMMAND;

	/**
	 * foCXʃwp[NX
	 */
	private abstract static class ComndKind {
		private final byte[] memKind;

		public ComndKind(int kd1, int kd2) {
			this.memKind = new byte[2];
			this.memKind[0] = (byte) (kd1 & 0xff);
			this.memKind[1] = (byte) (kd2 & 0xff);
		}

		public byte[] getMemKind() {
			return memKind;
		}

		abstract public int getReadMaxLen();
		abstract public int getWriteMaxLen();
		abstract public long getAddress(long addr);
	}

	/**
	 * rbgfoCX
	 */
	private static class ComndKindBitdev extends ComndKind {
		/** rbgfoCXʂ̑MpPbgőTCY\萔ł */
		public static final int BITREAD_MC1E_PACKET_MAX_SIZE = 128 * 2;
		public static final int BITWRITE_MC1E_PACKET_MAX_SIZE = 40 * 2;
		public ComndKindBitdev(int kd1, int kd2) {
			super(kd1, kd2);
		}
		public int getReadMaxLen() {
			return BITREAD_MC1E_PACKET_MAX_SIZE;
		}
		public int getWriteMaxLen() {
			return BITWRITE_MC1E_PACKET_MAX_SIZE;
		}
		public long getAddress(long addr) {
			return addr * 16;
		}
	}

	/**
	 * [hfoCX
	 */
	private static class ComndKindWorddev extends ComndKind {
		/** [hfoCXʂ̑MpPbgőTCY\萔ł */
		public static final int WORD_MC1E_PACKET_MAX_SIZE = 256 * 2;
		public ComndKindWorddev(int kd1, int kd2) {
			super(kd1, kd2);
		}
		public int getReadMaxLen() {
			return WORD_MC1E_PACKET_MAX_SIZE;
		}
		public int getWriteMaxLen() {
			return WORD_MC1E_PACKET_MAX_SIZE;
		}
		public long getAddress(long addr) {
			return addr;
		}
	}

}
