/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.F11.scada.tool.conf.client;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.ParseException;

import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFormattedTextField.AbstractFormatter;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.F11.scada.tool.conf.StreamManager;

public class ClientConfTab extends JScrollPane implements DocumentListener {
	private static final long serialVersionUID = -5360161794370392714L;

	private final Frame frameParent;
	private final StreamManager manager;

	private final JTextField initialText = new JTextField();
	private final JTextField errorText = new JTextField();
	private final JTextField treeWidth = new JTextField();
	private final JTextField treeHeight = new JTextField();
	private final JTextField dismissDelay = new JTextField();
	private final JTextField schDlgWidth = new JTextField();
	private final JTextField schDlgHeight = new JTextField();
	private final JTextField trdDlgWidth = new JTextField();
	private final JTextField trdDlgHeight = new JTextField();
	private final JTextField separateScheduleLimit = new JTextField();
	private final JTextField soundOnHolder = new JTextField();
	private final JFormattedTextField treeFontSize = new JFormattedTextField(
		new DecimalFormat("###"));
	private final JFormattedTextField soundTimerTime = new JFormattedTextField(
		new DecimalFormat("#####"));
	private final JTextField columnConfig = new JTextField();
	private final JTextField finishPass = new JTextField();

	public ClientConfTab(Frame parent, StreamManager manager) {
		super();
		this.frameParent = parent;
		this.manager = manager;
		init();
	}

	private void init() {
		JPanel mainPanel = new JPanel(new GridLayout(0, 2));
		// V{̏l\
		mainPanel.add(new JLabel("V{l\F"));
		initialText.setText(manager
			.getClientConf("initialtext", "initial data"));
		initialText.getDocument().addDocumentListener(this);
		mainPanel.add(initialText);
		// G[\
		mainPanel.add(new JLabel("V{G[l\F"));
		errorText.setText(manager.getClientConf("errortext", "err.."));
		errorText.getDocument().addDocumentListener(this);
		mainPanel.add(errorText);
		// ߂Eiރ{^
		mainPanel.add(new JLabel("߂Eiރ{^F"));
		JButton but = new JButton("ڍ");
		but.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// ACRETCYݒ_CAO
				new NextPrevDialog(manager, frameParent).setVisible(true);
			}
		});
		mainPanel.add(but);
		// XPW[o[̐Fݒ
		mainPanel.add(new JLabel("XPW[o[̐FݒF"));
		but = new JButton("ڍ");
		but.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// XPW[Fݒ_CAO
				new SchColorsDialog(manager, frameParent).setVisible(true);
			}
		});
		mainPanel.add(but);
		// LbVy[WNɃNCAgɓǂݍ
		mainPanel.add(new JLabel("NɃLbVy[WǂݍށF"));
		JComboBox cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"parser.AppletFrameDefine.receiveCache",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"parser.AppletFrameDefine.receiveCache",
							"true");
					} else {
						manager.setClientConf(
							"parser.AppletFrameDefine.receiveCache",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		/*
		 * {^(X{^)ŁAmF_CAOoɕ邩ǂB true:mF_CAOoɕB
		 * false:mF_CAOoB WebuEUŃNCAg𗧂グɂ́A̋@\͓삹KI܂B
		 */
		mainPanel.add(new JLabel("{^(X{^)ŁAmF_CAOF"));
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("true".equals(manager.getClientConf(
			"xwife.applet.Applet.isClose",
			"true"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"xwife.applet.Applet.isClose",
							"false");
					} else {
						manager.setClientConf(
							"xwife.applet.Applet.isClose",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
		// グɃNCAgő剻EȂ
		mainPanel.add(new JLabel("グɃNCAgő剻F"));
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"xwife.applet.Applet.maximized",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"xwife.applet.Applet.maximized",
							"true");
					} else {
						manager.setClientConf(
							"xwife.applet.Applet.maximized",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		/*
		 * c[̏c {treeWidth  : treeHeight } (Pixcel) cFő剻^XNo[\ 805
		 * cFő剻^XNo[\L 775 KȃTCYB ͓KɎw肵ĂB
		 */
		mainPanel.add(new JLabel("c[TCYF"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		panel.add(new JLabel("F", JLabel.RIGHT));
		treeWidth.setText(manager.getClientConf(
			"xwife.applet.Applet.treeWidth",
			"150"));
		treeWidth.getDocument().addDocumentListener(this);
		panel.add(treeWidth);
		panel.add(new JLabel("F", JLabel.RIGHT));
		treeHeight.setText(manager.getClientConf(
			"xwife.applet.Applet.treeHeight",
			"775"));
		treeHeight.getDocument().addDocumentListener(this);
		panel.add(treeHeight);
		mainPanel.add(panel);
		// xEԔɃXN[Z[o[EȂ
		mainPanel.add(new JLabel("xEԔXN[Z[o[F"));
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"xwife.applet.Applet.screenSaver",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"xwife.applet.Applet.screenSaver",
							"true");
					} else {
						manager.setClientConf(
							"xwife.applet.Applet.screenSaver",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		// c[`bv̍ő\(~b)B
		mainPanel.add(new JLabel("c[`bv̍ő\(~b)F"));
		panel = new JPanel(new GridLayout(1, 0));
		dismissDelay.setText(manager.getClientConf(
			"xwife.applet.Applet.dismissDelay",
			"10000"));
		dismissDelay.getDocument().addDocumentListener(this);
		panel.add(dismissDelay);
		// c[`bṽJX^\@
		JLabel label = new JLabel("\@F", JLabel.RIGHT);
		label.setToolTipText("[W]ł̓c[`bvȂB");
		panel.add(label);
		cb = new JComboBox(new String[] { "JX^", "W" });
		if ("false".equals(manager.getClientConf(
			"xwife.applet.Applet.customTipLocation",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("JX^".equals(e.getItem())) {
						manager.setClientConf(
							"xwife.applet.Applet.customTipLocation",
							"true");
					} else {
						manager.setClientConf(
							"xwife.applet.Applet.customTipLocation",
							"false");
					}
				}
			}
		});
		panel.add(cb);
		mainPanel.add(panel);
		// x񉹒~L[ݒBl F12L[
		// x񉹒~fW^CxgݒB
		// x񉹒~fW^CxgݐݒB
		mainPanel.add(new JLabel("x񉹒~F"));
		but = new JButton("ڍ");
		but.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// x񉹒~ݒ_CAO
				new AlarmStopDialog(manager, frameParent).setVisible(true);
			}
		});
		mainPanel.add(but);
		// XPW[̃O[vꗗ_CAÕTCY
		mainPanel.add(new JLabel("XPW[O[vꗗ_CAOF"));
		panel = new JPanel(new GridLayout(1, 0));
		panel.add(new JLabel("F", JLabel.RIGHT));
		schDlgWidth.setText(manager.getClientConf(
			"xwife.applet.Applet.schedule.dialog.width",
			"157"));
		schDlgWidth.getDocument().addDocumentListener(this);
		panel.add(schDlgWidth);
		panel.add(new JLabel("F", JLabel.RIGHT));
		schDlgHeight.setText(manager.getClientConf(
			"xwife.applet.Applet.schedule.dialog.height",
			"217"));
		schDlgHeight.getDocument().addDocumentListener(this);
		panel.add(schDlgHeight);
		mainPanel.add(panel);
		// ghOt̃O[vꗗ_CAÕTCY
		mainPanel.add(new JLabel("ghOtO[vꗗ_CAOF"));
		panel = new JPanel(new GridLayout(1, 0));
		panel.add(new JLabel("F", JLabel.RIGHT));
		trdDlgWidth.setText(manager.getClientConf(
			"xwife.applet.Applet.trend.dialog.width",
			"157"));
		trdDlgWidth.getDocument().addDocumentListener(this);
		panel.add(trdDlgWidth);
		panel.add(new JLabel("F", JLabel.RIGHT));
		trdDlgHeight.setText(manager.getClientConf(
			"xwife.applet.Applet.trend.dialog.height",
			"217"));
		trdDlgHeight.getDocument().addDocumentListener(this);
		panel.add(trdDlgHeight);
		mainPanel.add(panel);
		// NCAg̃TCYƈʒu
		mainPanel.add(new JLabel("NCAg̃TCYƈʒuF"));
		but = new JButton("ڍ");
		but.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// NCAgzuݒ_CAO
				new ClientLocDialog(manager, frameParent).setVisible(true);
			}
		});
		mainPanel.add(but);
		// ҏW\ȃV{Ń}EXJ[\̌`
		mainPanel.add(new JLabel("ҏW\V{Ń}EXJ[\`F"));
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"xwife.applet.Applet.symbol.handcursor",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"xwife.applet.Applet.symbol.handcursor",
							"true");
					} else {
						manager.setClientConf(
							"xwife.applet.Applet.symbol.handcursor",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		// vCIeBɂ鎩Wv̐
		mainPanel.add(new JLabel("vCIeBɂ鎩WvF"));
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.PriorityController",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager
							.setClientConf(
								"org.F11.scada.xwife.applet.alarm.PriorityController",
								"true");
					} else {
						manager
							.setClientConf(
								"org.F11.scada.xwife.applet.alarm.PriorityController",
								"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		// ÑXvbVݒ
		mainPanel.add(new JLabel("ÑXvbVݒF"));
		but = new JButton("ڍ");
		but.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// XvbV̗L
				// XvbṼ^Cg
				// XvbṼC[W
				new SplashDialog(manager, frameParent).setVisible(true);
			}
		});
		mainPanel.add(but);
		// mF_CAO̗L
		label = new JLabel("mF_CAO̗LF");
		label.setToolTipText("PLC݂ɊւSɂāB");
		mainPanel.add(label);
		cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.applet.dialog.isConfirm",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.applet.dialog.isConfirm",
							"true");
					} else {
						manager.setClientConf(
							"org.F11.scada.applet.dialog.isConfirm",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
		separateSchedule(mainPanel);
		separateScheduleLimit(mainPanel);
		showSortColumn(mainPanel);
		typeDmode(mainPanel);
		typeDTabSync(mainPanel);
		// imageLoader(mainPanel);
		treeFontSize(mainPanel);
		alarmTableColumn(mainPanel);
		screenShot(mainPanel);
		soundTimer(mainPanel);
		soundTimerTime(mainPanel);
		isViewWeek(mainPanel);
		soundOnHolder(mainPanel);
		isShowAttributeColumn(mainPanel);
		isTodayOrTomorrow(mainPanel);
		columnConfig(mainPanel);
		setNomalSize(mainPanel);
		setShowScreenLock(mainPanel);
		setFinishPass(mainPanel);
		finishPass(mainPanel);

		JPanel scPanel = new JPanel(new BorderLayout());
		scPanel.add(mainPanel, BorderLayout.NORTH);
		this.setViewportView(scPanel);
	}

	private void separateSchedule(JPanel mainPanel) {
		// XPW[Ōʕ\̗L
		mainPanel.add(new JLabel("XPW[Ōʕ\̗LF"));
		JComboBox cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.applet.schedule.point.SeparateSchedule",
			"false"))) {
			cb.setSelectedIndex(1);
		} else {
			cb.setSelectedIndex(0);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager
							.setClientConf(
								"org.F11.scada.applet.schedule.point.SeparateSchedule",
								"true");
					} else {
						manager
							.setClientConf(
								"org.F11.scada.applet.schedule.point.SeparateSchedule",
								"false");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void separateScheduleLimit(JPanel mainPanel) {
		// XPW[Ōʕ\̍s
		mainPanel.add(new JLabel("XPW[@ꗗ\̍s"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		separateScheduleLimit.setText(manager.getClientConf(
			"org.F11.scada.applet.schedule.point.limit",
			"25"));
		separateScheduleLimit.getDocument().addDocumentListener(this);
		panel.add(separateScheduleLimit);
		mainPanel.add(panel);
	}

	private void showSortColumn(JPanel mainPanel) {
		mainPanel.add(new JLabel("xꗗɎʂ\F"));
		JComboBox cb = new JComboBox(new String[] { "Ȃ", "" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.showSortColumn",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.showSortColumn",
							"true");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.showSortColumn",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void typeDmode(JPanel mainPanel) {
		JLabel label = new JLabel("TypeD[hF");
		label.setToolTipText("TypeDŁ{^Ƃ̕\@B");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "ȌԂێ", "xꗗ\" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.typeDmode",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("xꗗ\".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.typeDmode",
							"true");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.typeDmode",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void typeDTabSync(JPanel mainPanel) {
		JLabel label = new JLabel("TypeD^uF");
		label.setToolTipText("TypeDxꗗ̑I^u𓯊邩B");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "Ȃ", "" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.AppletD.tabsync",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("Ȃ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.AppletD.tabsync",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.AppletD.tabsync",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void treeFontSize(JPanel mainPanel) {
		// c[̃tHgTCY
		mainPanel.add(new JLabel("c[̃tHgTCY(l12)"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		treeFontSize.setText(manager.getClientConf(
			"org.F11.scada.xwife.applet.pagetree.font",
			"12"));
		treeFontSize.setInputVerifier(new NumberVerifier("l"));
		treeFontSize.setFocusLostBehavior(JFormattedTextField.COMMIT);
		treeFontSize.getDocument().addDocumentListener(this);
		panel.add(treeFontSize);
		mainPanel.add(panel);
	}

	private void alarmTableColumn(JPanel mainPanel) {
		mainPanel.add(new JLabel("xꗗ̗񕝐ݒ"));
		JButton button = new JButton("ڍ");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new AlarmTableColumn(frameParent, manager).setVisible(true);
			}
		});
		mainPanel.add(button);
	}

	private void screenShot(JPanel mainPanel) {
		mainPanel.add(new JLabel("XN[Vbgݒ"));
		JButton button = new JButton("ڍ");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new ScreenShot(frameParent, manager).setVisible(true);
			}
		});
		mainPanel.add(button);
	}

	private void soundTimer(JPanel mainPanel) {
		JLabel label = new JLabel("x񉹃^C}[F");
		label.setToolTipText("x񉹃^C}[gpĎ~邩̐ݒ");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "Ȃ", "" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.soundTimer",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("Ȃ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.soundTimer",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.soundTimer",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void soundTimerTime(JPanel mainPanel) {
		// x񉹃^C}[Œ~܂ł̎
		mainPanel.add(new JLabel("x񉹃^C}[F"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		soundTimerTime.setText(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.soundTimerTime",
			"5000"));
		soundTimerTime.setInputVerifier(new NumberVerifier("l"));
		soundTimerTime.setFocusLostBehavior(JFormattedTextField.COMMIT);
		soundTimerTime.getDocument().addDocumentListener(this);
		panel.add(soundTimerTime);
		mainPanel.add(panel);
	}

	private void isViewWeek(JPanel mainPanel) {
		JLabel label = new JLabel("vɗj\F");
		label.setToolTipText("E̎vɗj\邩ݒ");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "Ȃ", "" });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.isViewWeek",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("Ȃ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.isViewWeek",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.isViewWeek",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void soundOnHolder(JPanel mainPanel) {
		// x񉹋֎~NCAgŋL
		mainPanel.add(new JLabel("x񉹋֎~NCAgŋLF"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		soundOnHolder.setText(manager.getClientConf(
			"xwife.applet.Applet.soundOnHolder",
			""));
		soundOnHolder.getDocument().addDocumentListener(this);
		soundOnHolder
			.setToolTipText("Lꍇ̓z_ID́B͂Ȃꍇ͏]ʂAeNCAgŌx񉹋֎~Ԃێ܂B");
		panel.add(soundOnHolder);
		mainPanel.add(panel);
	}

	private void isShowAttributeColumn(JPanel mainPanel) {
		JLabel label = new JLabel("xꗗɕ\F");
		label.setToolTipText("xꗗɕ\邩ݒ");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "", "Ȃ" });
		if ("true".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.showAttributeColumn",
			"true"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("Ȃ".equals(e.getItem())) {
						manager
							.setClientConf(
								"org.F11.scada.xwife.applet.alarm.showAttributeColumn",
								"false");
					} else {
						manager
							.setClientConf(
								"org.F11.scada.xwife.applet.alarm.showAttributeColumn",
								"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void isTodayOrTomorrow(JPanel mainPanel) {
		JLabel label = new JLabel("ޭٍA݂𖳌ɂF");
		label.setToolTipText("ޭٍA݂𖳌ɂ邩ݒ");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "Ȃ", "", });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.applet.schedule.todayOrTomorrow",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("Ȃ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.applet.schedule.todayOrTomorrow",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.applet.schedule.todayOrTomorrow",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void columnConfig(JPanel mainPanel) {
		// xꗗړݒ
		mainPanel.add(new JLabel("xꗗړݒF"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		columnConfig.setText(manager.getClientConf(
			"org.F11.scada.columnConfig",
			""));
		columnConfig.getDocument().addDocumentListener(this);
		columnConfig
			.setToolTipText("xꗗ̗u1:ړ̗1, 2:ړ̗2... ,n:ړ̗nvŐݒ肵܂B");
		panel.add(columnConfig);
		mainPanel.add(panel);
	}

	private void setNomalSize(JPanel mainPanel) {
		JLabel label = new JLabel("x񔭐ɃNCAgTCY߂F");
		label.setToolTipText("x񔭐ɍŏꂽNCAg̃TCYɖ߂ǂݒ");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "߂Ȃ", "߂", });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.alarm.setNomalSize",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("߂Ȃ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.setNomalSize",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.alarm.setNomalSize",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void setShowScreenLock(JPanel mainPanel) {
		JLabel label = new JLabel("ʃbN{^\F");
		label.setToolTipText("ʃbN{^\̗L");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "\", "B", });
		if ("true".equals(manager.getClientConf(
			"org.F11.scada.xwife.applet.isShowScreenLock",
			"true"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("\".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.isShowScreenLock",
							"true");
					} else {
						manager.setClientConf(
							"org.F11.scada.xwife.applet.isShowScreenLock",
							"false");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void setFinishPass(JPanel mainPanel) {
		JLabel label = new JLabel("NCAgIɔF؂sF");
		label.setToolTipText("NCAgIɔF؂s");
		mainPanel.add(label);
		JComboBox cb = new JComboBox(new String[] { "sȂ", "s", });
		if ("false".equals(manager.getClientConf(
			"org.F11.scada.applet.dialog.isPassword",
			"false"))) {
			cb.setSelectedIndex(0);
		} else {
			cb.setSelectedIndex(1);
		}
		cb.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if ("sȂ".equals(e.getItem())) {
						manager.setClientConf(
							"org.F11.scada.applet.dialog.isPassword",
							"false");
					} else {
						manager.setClientConf(
							"org.F11.scada.applet.dialog.isPassword",
							"true");
					}
				}
			}
		});
		mainPanel.add(cb);
	}

	private void finishPass(JPanel mainPanel) {
		// xꗗړݒ
		mainPanel.add(new JLabel("IpX[hF"));
		JPanel panel = new JPanel(new GridLayout(1, 0));
		finishPass.setText(manager.getClientConf(
			"org.F11.scada.applet.dialog.password",
			"password"));
		finishPass.getDocument().addDocumentListener(this);
		finishPass.setToolTipText("NCAgĨpX[hݒ肵܂");
		panel.add(finishPass);
		mainPanel.add(panel);
	}

	public void changedUpdate(DocumentEvent e) {
		eventPaformed(e);
	}

	public void insertUpdate(DocumentEvent e) {
		eventPaformed(e);
	}

	public void removeUpdate(DocumentEvent e) {
		eventPaformed(e);
	}

	private void eventPaformed(DocumentEvent e) {
		if (e.getDocument() == initialText.getDocument()) {
			manager.setClientConf("initialtext", initialText.getText());
		} else if (e.getDocument() == errorText.getDocument()) {
			manager.setClientConf("errortext", errorText.getText());
		} else if (e.getDocument() == treeWidth.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.treeWidth",
				treeWidth.getText());
		} else if (e.getDocument() == treeHeight.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.treeHeight",
				treeHeight.getText());
		} else if (e.getDocument() == dismissDelay.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.dismissDelay",
				dismissDelay.getText());
		} else if (e.getDocument() == schDlgWidth.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.schedule.dialog.width",
				schDlgWidth.getText());
		} else if (e.getDocument() == schDlgHeight.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.schedule.dialog.height",
				schDlgHeight.getText());
		} else if (e.getDocument() == trdDlgWidth.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.trend.dialog.width",
				trdDlgWidth.getText());
		} else if (e.getDocument() == trdDlgHeight.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.trend.dialog.height",
				trdDlgHeight.getText());
		} else if (e.getDocument() == separateScheduleLimit.getDocument()) {
			manager.setClientConf(
				"org.F11.scada.applet.schedule.point.limit",
				separateScheduleLimit.getText());
		} else if (e.getDocument() == treeFontSize.getDocument()) {
			manager.setClientConf(
				"org.F11.scada.xwife.applet.pagetree.font",
				treeFontSize.getText());
		} else if (e.getDocument() == soundTimerTime.getDocument()) {
			manager.setClientConf(
				"org.F11.scada.xwife.applet.alarm.soundTimerTime",
				soundTimerTime.getText());
		} else if (e.getDocument() == soundOnHolder.getDocument()) {
			manager.setClientConf(
				"xwife.applet.Applet.soundOnHolder",
				soundOnHolder.getText());
		} else if (e.getDocument() == columnConfig.getDocument()) {
			manager.setClientConf(
				"org.F11.scada.columnConfig",
				columnConfig.getText());
		} else if (e.getDocument() == finishPass.getDocument()) {
			manager.setClientConf(
				"org.F11.scada.applet.dialog.password",
				finishPass.getText());
		}
	}

	private static class NumberVerifier extends InputVerifier {
		private final String format;

		public NumberVerifier(String format) {
			this.format = format;
		}

		@Override
		public boolean verify(JComponent input) {
			if (input instanceof JFormattedTextField) {
				JFormattedTextField ftf = (JFormattedTextField) input;
				AbstractFormatter formatter = ftf.getFormatter();
				if (formatter != null) {
					String text = ftf.getText();
					try {
						formatter.stringToValue(text);
						return true;
					} catch (ParseException pe) {
						JOptionPane.showMessageDialog(ftf, format
							+ "`œ͂ĂB");
						return false;
					}
				}
			}
			return true;
		}

		@Override
		public boolean shouldYieldFocus(JComponent input) {
			return verify(input);
		}
	}
}
