package org.F11.scada.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class FileUtil {
	/**
	 * w茏cAҏWťÂɃt@C폜B0ȉw肳ꂽꍇ͍폜ȂB
	 *
	 * @param files t@C̈ꗗ
	 * @param cnt cB0ȉw肳ꂽꍇ͍폜ȂB
	 */
	public static void removeOldFile(File[] files, int cnt) {
		if (cnt <= 0 || null == files || files.length <= cnt) {
			return;
		}

		ArrayList<File> fileList = new ArrayList<File>(files.length);
		for (int i = 0; i < files.length; i++) {
			fileList.add(files[i]);
		}
		while (cnt < fileList.size()) {
			long first = System.currentTimeMillis();
			File firstFile = null;
			for (Iterator<File> it = fileList.iterator(); it.hasNext();) {
				File file = it.next();
				if (file.lastModified() < first) {
					first = file.lastModified();
					firstFile = file;
				}
			}
			firstFile.delete();
			fileList.remove(firstFile);
		}
	}

	/**
	 * obt@[ς݂ŎtbVPrintWriteԂ܂B
	 *
	 * @param path o͂pX
	 * @param append ǋL[h
	 * @param csn GR[h
	 * @return obt@[ς݂PrintWriteԂ܂B
	 * @throws UnsupportedEncodingException OSŃT|[gĂȂGR[hw肳ꂽꍇX[܂B
	 * @throws FileNotFoundException o͂pX쐬łȂꍇX[܂B
	 */
	public static PrintWriter getPrintWriter(String path,
			boolean append,
			String csn) throws UnsupportedEncodingException,
			FileNotFoundException {
		return new PrintWriter(new BufferedWriter(new OutputStreamWriter(
			new FileOutputStream(new File(path), append),
			csn)), true);
	}

	/**
	 * obt@[ς݂̃eLXg[_[Ԃ܂B
	 *
	 * @param path ͂t@C
	 * @param csn GR[h
	 * @return obt@[ς݂̃eLXg[_[Ԃ܂B
	 * @throws UnsupportedEncodingException OSŃT|[gĂȂGR[hw肳ꂽꍇX[܂B
	 * @throws FileNotFoundException ͂pX쐬łȂꍇX[܂B
	 */
	public static BufferedReader getReader(String path, String csn)
			throws UnsupportedEncodingException, FileNotFoundException {
		return new BufferedReader(new InputStreamReader(new FileInputStream(
			new File(path)), csn));
	}
}
