/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/dialog/DigitalDialog.java,v 1.5.2.11 2007/07/31 08:27:48 frdm Exp $
 * $Revision: 1.5.2.11 $
 * $Date: 2007/07/31 08:27:48 $
 *
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;

import javax.swing.JButton;

import org.F11.scada.WifeUtilities;
import org.F11.scada.applet.symbol.ColorFactory;
import org.F11.scada.applet.symbol.DigitalEditable;
import org.F11.scada.applet.symbol.ScheduleEditable;
import org.F11.scada.util.FontUtil;
import org.F11.scada.util.MemoryLogUtil;
import org.F11.scada.xwife.applet.PageChanger;
import org.apache.log4j.Logger;

/**
 * fW^f[^𑀍삷_CAONXłB w DigitalButton Œ`܂B
 * _CAONXł́A{^Ǝẘ֘A`܂B LZ{^́AwsȂ܂܃_CAO܂B
 */
public class DigitalDialog extends WifeDialog implements ActionListener {
	private static final long serialVersionUID = 3786955747253504330L;
	private final Logger logger = Logger.getLogger(DigitalDialog.class);
	/** fW^{^̎Q */
	private DigitalEditable symbol;
	/** y[WύXIuWFNg */
	private final PageChanger changer;

	/**
	 * RXgN^B
	 *
	 * @param frame ẽt[B
	 */
	public DigitalDialog(Frame frame, PageChanger changer) {
		super(frame);
		this.changer = changer;
		getContentPane().setLayout(null);
	}

	/**
	 * RXgN^B
	 *
	 * @param dialog e_CAOB
	 */
	public DigitalDialog(Dialog dialog, PageChanger changer) {
		super(dialog);
		this.changer = changer;
		getContentPane().setLayout(null);
	}

	/**
	 * Ce[^[Zbg܂
	 *
	 * @param listIterator ҏW\V{̃Ce[^[
	 */
	public void setListIterator(ListIterator listIterator) {
		symbol = (DigitalEditable) listIterator.next();
	}

	/**
	 * _CAO\
	 *
	 * @see java.awt.Dialog#show()
	 */
	@Override
	public void show() {
		Rectangle dialogBounds = getBounds();
		dialogBounds.setLocation(symbol.getPoint());
		setLocation(WifeUtilities.getInScreenPoint(screenSize, dialogBounds));
		/* {^̐ݒ */
		for (int i = 0, textPos = 0; i < getContentPane().getComponentCount(); i++) {
			Component compo = getContentPane().getComponent(i);
			if (compo instanceof JButton) {
				String bt = this.symbol.getButtonString(textPos);
				if (bt != null)
					((JButton) compo).setText(bt);
				textPos++;
			}
		}
		setDefaultFocus();
		super.show();
	}

	/**
	 * I鎞ɃtH[JXgo[XftHgɖ߂܂B
	 *
	 * @see java.awt.Dialog#dispose()
	 */
	public void dispose() {
		setDefaultFocus();
		super.dispose();
	}

	public void selectAll() {
	}

	/**
	 * ꂽ{^̓s܂B
	 */
	public void actionPerformed(ActionEvent e) {
		DialogButton button = (DialogButton) e.getSource();
		button.pushButton();
	}

	/**
	 * _CAOɃ{^ǉ܂B
	 *
	 * @param text {^
	 * @param actionNo wԍ
	 * @param rec {^̑傫Ɣzuʒu
	 * @param foreground F
	 * @param background wiF
	 * @param font tHg
	 * @param fontStyle tHgX^C
	 * @param fontSize tHgTCY
	 * @param schedule XPW[_CAOԍ(݂̓XPW[ȊOɂgpĂ)
	 */
	public void add(
		String text,
		int actionNo,
		Rectangle rec,
		String foreground,
		String background,
		String font,
		String fontStyle,
		String fontSize,
		String schedule) {
		DialogButton button =
			DialogButton.createDialogButton(this, actionNo, schedule, changer);
		button.setText(text);
		button.setBounds(rec);
		if (null != ColorFactory.getColor(foreground)) {
			button.setForeground(ColorFactory.getColor(foreground));
		}
		if (null != ColorFactory.getColor(background)) {
			button.setBackground(ColorFactory.getColor(background));
		}
		FontUtil.setFont(font, fontStyle, fontSize, button);
		getContentPane().add(button);
	}

	/**
	 * _CAOɕ\{^̊NXłB
	 */
	static abstract class DialogButton extends JButton {
		private static final long serialVersionUID = 355442905678592887L;
		protected static final Logger logger =
			Logger.getLogger(DialogButton.class);
		/** e_CAO̎QƂłB */
		protected DigitalDialog dialog;
		/** {^ɒ`ꂽwԍł */
		protected int actionNo;

		/**
		 * ACR{^쐬RXgN^łB
		 *
		 * @param dialog e_CAO̎Q
		 * @param actionNo {^Ɋ蓖Ăwԍ
		 */
		protected DialogButton(DigitalDialog dialog, int actionNo) {
			super();
			this.dialog = dialog;
			this.actionNo = actionNo;
			addActionListener(this.dialog);
		}

		/**
		 * z֐łB TuNXŁA{^ꂽƂ́ALq܂B
		 */
		abstract public void pushButton();

		/**
		 * w肳ꂽANVNoʂɃ{^𐶐B
		 * <ul>
		 * <li>4:s|Cg</li>
		 * <li>5:ʃXPW[</li>
		 * <li>6:LZ{^</li>
		 * <li>21`:f[^M{^</li>
		 * </ul>
		 *
		 * @param dialog e_CAO
		 * @param actionNo ANVNo
		 * @param schedule XPW[_CAOԍ(݂̓XPW[ȊOɂgpĂ)
		 * @param changer eAvbg(x񉹒~ɂĎgp)
		 * @return fW^_CAOp̃{^𐶐܂B
		 */
		static public DialogButton createDialogButton(
			DigitalDialog dialog,
			int actionNo,
			String schedule,
			PageChanger changer) {
			switch (actionNo) {
			// s|CgScheduleButtonl̓ŁA_CAO\̂ŗpĂB
			case 4:
			case 5:
				return new ScheduleButton(dialog, actionNo, schedule, changer);
			case 6:
				return new CancelButton(dialog, actionNo, changer);
			default:
				return new SendButton(dialog, actionNo);
			}
		}
	}

	/**
	 * w쑗M{^NXłB
	 */
	static final class SendButton extends DialogButton {
		private static final long serialVersionUID = -1307199387393391804L;

		/**
		 * RXgN^
		 *
		 * @param dialog {^ǉ_CAO̎Q
		 * @param actionNo {^̎w
		 */
		public SendButton(DigitalDialog dialog, int actionNo) {
			super(dialog, actionNo);
		}

		/**
		 * fW^{^̎ws܂B
		 */
		public void pushButton() {
			if (ConfirmUtil.isConfirm(dialog)) {
				dialog.symbol.pushButton(actionNo);
				dialog.dispose();
			}
		}
	}

	/**
	 * LZ{^NXłB
	 */
	static final class CancelButton extends DialogButton {
		private static final long serialVersionUID = -4881864928924466057L;

		/**
		 * RXgN^
		 *
		 * @param dialog {^ǉ_CAO̎Q
		 * @param actionNo {^̎w
		 */
		public CancelButton(
				DigitalDialog dialog,
				int actionNo,
				PageChanger changer) {
			super(dialog, actionNo);
			ActionMapUtil.setActionMap(this, changer);
		}

		/**
		 * fW^{^̎ws܂B
		 */
		public void pushButton() {
			dialog.dispose();
		}
	}

	/**
	 * ʃXPW[{^łBAA݂̓XPW[ȊOɂÃ_CAǑoR{^ƂĎgpĂ܂B
	 *
	 * @author maekawa
	 *
	 */
	private static class ScheduleButton extends DialogButton {
		private static final long serialVersionUID = -6340768556603260036L;
		private final String scheduleDialogNo;
		private final PageChanger changer;

		public ScheduleButton(
				DigitalDialog dialog,
				int actionNo,
				String schedule,
				PageChanger changer) {
			super(dialog, actionNo);
			this.scheduleDialogNo = schedule;
			this.changer = changer;
			if (null == schedule || "".equals(schedule)) {
				throw new IllegalArgumentException(
						"XPW[_CAONo(schedule)ݒ肳Ă܂B");
			}
		}

		@Override
		public void pushButton() {
			WifeDialog wd =
				DialogFactory.get(dialog, scheduleDialogNo, changer);
			wd.setListIterator(getIterator());
			wd.setTitle(dialog.getTitle());
			logger.info(MemoryLogUtil.getMemory(dialog.getTitle()));
			wd.show();
			dialog.dispose();
		}

		private ListIterator getIterator() {
			return new ScheduleIterator((ScheduleEditable) dialog.symbol);
		}

		private static class ScheduleIterator implements ListIterator {
			private final ScheduleEditable editable;

			public ScheduleIterator(ScheduleEditable editable) {
				this.editable = editable;
			}

			public void add(Object o) {
			}

			public boolean hasNext() {
				return false;
			}

			public boolean hasPrevious() {
				return false;
			}

			public Object next() {
				return editable;
			}

			public int nextIndex() {
				return 0;
			}

			public Object previous() {
				return null;
			}

			public int previousIndex() {
				return 0;
			}

			public void remove() {
			}

			public void set(Object o) {
			}
		}
	}
}
