package org.F11.scada.applet.graph;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;

import org.apache.log4j.Logger;

/**
 * XP[f[^f̊NXłB
 * SwingPropertyChangeSupport ɂCxgfQ[V܂B
 */
public abstract class AbstractVerticallyScaleModel implements VerticallyScaleModel, PropertyChangeListener {
	/** MOAPI */
	protected static Logger logger = Logger.getLogger(AbstractVerticallyScaleModel.class);
	/** vpeBCxg */
	private static final String PROPERTY_NAME = "SCALE_CHANGEED";
	/** vpeB`FWT|[g */
	private SwingPropertyChangeSupport property;
	/** ʃR|[lg */
	protected JComponent comp;
	/** OtvpeBf */
	protected GraphPropertyModel graphPropertyModel;
	/** V[Y */
	protected int series;

	/** XP[̉ */
	protected static final int scaleOneWidth = 10;
	/** XP[ڐ̕ */
	protected String[] scaleStrings;
	/** XP[ڐ̍̕ő啝 */
	protected int maxStringWidth;
	/** XP[ڐ̍̕ő卂 */
	protected int maxStringHeight;
	/** XP[őXpύX̗L */
	protected boolean isMaxEnable = true;
	/** XP[ŏXpύX̗L */
	protected boolean isMinEnable = true;

	/**
	 * RXgN^
	 * @param comp ʃR|[lg
	 * @param graphPropertyModel OtvpeBf
	 * @param series V[Y
	 */
	public AbstractVerticallyScaleModel(JComponent comp,
									   GraphPropertyModel graphPropertyModel,
									   int series) {
		this.comp = comp;
		this.graphPropertyModel = graphPropertyModel;
		this.graphPropertyModel.addPropertyChangeListener(this);
		this.graphPropertyModel.addPropertyChangeListener(GraphPropertyModel.GROUP_CHANGE_EVENT, this);
		this.series = series;
		logger.debug("initialize.");
	}

	/**
	 * R|[lg̏܂B
	 */
	abstract protected void calcSize();

	/**
	 * PropertyChangeListener Xi[Xgɒǉ܂B
	 * @param listener ǉ PropertyChangeListener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (property == null) {
			property = new SwingPropertyChangeSupport(this);
		}
		property.addPropertyChangeListener(PROPERTY_NAME, listener);
	}

	/**
	 * PropertyChangeListener Xi[Xg폜܂B
	 * @param listener 폜 PropertyChangeListener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (property == null) {
			return;
		}
		property.removePropertyChangeListener(PROPERTY_NAME, listener);
	}

	/**
	 * o^Ă郊Xi[ɁAoEhvpeB̍XVʒm܂B
	 * ȑO̒lƐVl null łȂꍇACxg̓gK܂B
	 * @param oldValue vpeB̌Âl
	 * @param newValue vpeB̐Vl
	 */
	public void firePropertyChange(Object oldValue, Object newValue) {
		if (property == null) {
			return;
		}
		property.firePropertyChange(PROPERTY_NAME, oldValue, newValue);
	}

	/**
	 * ڐ̕Ԃ܂B
	 * @return ڐ̕
	 */
	public int getScaleOneWidth() {
		return scaleOneWidth;
	}

	/**
	 * ڐ̍Ԃ܂B
	 * @return ڐ̍
	 */
	public int getScaleOneHeight() {
		return graphPropertyModel.getVerticalScaleHeight();
	}

	/**
	 * ڐ̑Ԃ܂B
	 * @return ڐ̑
	 */
	public int getScaleCount() {
		return graphPropertyModel.getVerticalScaleCount();
	}

	/**
	 * XP[̍ŏlԂ܂B
	 * @return XP[̍ŏl
	 */
	public double getScaleMin() {
		return graphPropertyModel.getVerticalMinimum(series);
	}

	/**
	 * XP[̍őlԂ܂B
	 * @return XP[̍ől
	 */
	public double getScaleMax() {
		return graphPropertyModel.getVerticalMaximum(series);
	}

	/**
	 * XP[̍ŏlݒ肵܂B
	 * @param min XP[̍ŏl
	 */
	public void setScaleMin(double min) {
		graphPropertyModel.setVerticalMinimum(series, min);
		calcSize();
	}

	/**
	 * XP[̍őlݒ肵܂B
	 * @param max XP[̍ől
	 */
	public void setScaleMax(double max) {
		graphPropertyModel.setVerticalMaximum(series, max);
		calcSize();
	}

	/**
	 * XP[ڐ蕶̔zԂ܂B
	 * @return XP[ڐ蕶̔z
	 */
	public String[] getScaleStrings() {
		if (scaleStrings == null) {
			calcSize();
		}
		return scaleStrings;
	}

	/**
	 * XP[ڐ蕶̍ő啝Ԃ܂B
	 * @param isLeft XP[ǂ
	 * @return XP[ڐ蕶̍ő啝
	 */
	public int getScaleStringMaxWidth(boolean isLeft) {
		if (maxStringWidth == 0) {
			calcSize();
		}
		FontMetrics metrics = comp.getFontMetrics(comp.getFont());
		return isLeft ? maxStringWidth + metrics.stringWidth("  ") : maxStringWidth;
	}

	/**
	 * XP[ڐ蕶̍ő卂Ԃ܂B
	 * @return XP[ڐ蕶̍ő卂
	 */
	public int getScaleStringMaxHeight() {
		if (maxStringHeight == 0) {
			calcSize();
		}
		return maxStringHeight;
	}

	/**
	 * XP[ڐ蕶̐FԂ܂B
	 * @return XP[ڐ蕶̐F
	 */
	public Color getScaleStringColor() {
		return graphPropertyModel.getColors()[series];
	}

	/**
	 * `GÃCZbcԂ܂
	 * @return `GÃCZbc
	 */
	public Insets getScaleInsets() {
		return graphPropertyModel.getInsets();
	}

	/**
	 * XP[őXpύX̗L
	 * @return XP[őXpύXłꍇ trueAłȂꍇ false
	 */
	public boolean isMaxEnable() {
		return isMaxEnable;
	}

	/**
	 * XP[ŏXpύX̗L
	 * @return XP[ŏXpύXłꍇ trueAłȂꍇ false
	 */
	public boolean isMinEnable() {
		return isMinEnable;
	}

	/**
	 * XP[őXpύX̗Lݒ肵܂B
	 * @param isMaxEnable ύX\ɂꍇ trueAύXsɂꍇ false
	 */
	public void setMaxEnable(boolean isMaxEnable) {
		this.isMaxEnable = isMaxEnable;
	}

	/**
	 * XP[ŏXpύX̗Lݒ肵܂B
	 * @param isMinEnable ύX\ɂꍇ trueAύXsɂꍇ false
	 */
	public void setMinEnable(boolean isMinEnable) {
		this.isMinEnable = isMinEnable;
	}

	/**
	 * oEhvpeB̕ύXɌĂяo܂B
	 * @param evt Cxg\[XѕύXvpeB
	 * Lq PropertyChangeEvent IuWFNg
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		calcSize();
		firePropertyChange(evt.getOldValue(), evt.getNewValue());
	}

	/**
	 * XP[ɑΉV[YԂ܂B
	 * ΉV[Y݂Ȃꍇ-1Ԃ܂B
	 * 
	 * @return XP[ɑΉV[YԂ܂BΉV[Y݂Ȃꍇ-1Ԃ܂B
	 */
	public int getSeries() {
		int max = graphPropertyModel.getSeriesSize();
		return (max <= series || 0 > series) ? -1 : series;
	}
	
	/**
	 * f[^voC_Ԃ܂
	 * @return f[^voC_Ԃ܂
	 */
	public String getDataProviderName() {
		return graphPropertyModel.getDataProviderName(series);
	}
	
	/**
	 * f[^z_Ԃ܂
	 * @return f[^z_Ԃ܂
	 */
	public String getDataHolderName() {
		return graphPropertyModel.getDataHolderName(series);
	}
}
