/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/graph/GraphPropertyModel.java,v 1.13.2.5 2007/07/11 07:47:18 frdm Exp $
 * $Revision: 1.13.2.5 $
 * $Date: 2007/07/11 07:47:18 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.Collection;

public interface GraphPropertyModel {
    /** O[vύXCxg̃vpeB[ */
    String GROUP_CHANGE_EVENT =
        GraphPropertyModel.class.getName() + "_GROUP_CHANGE_EVENT";
    /** ύXCxg̃vpeB[ */
    String X_SCALE_CHANGE_EVENT =
    	GraphPropertyModel.class.getName() + "_X_SCALE_CHANGE_EVENT";

	/**
	 * CX^XfB[vRs[܂B
	 * @return GraphPropertyModel fB[vRs[ꂽCX^XB
	 */
	public GraphPropertyModel deepCopy();

	/**
	 * Xi[ǉ܂B
	 * @param l PropertyChangeListener
	 */
	public void addPropertyChangeListener(PropertyChangeListener l);

	/**
	 * Xi[폜܂B
	 * @param l PropertyChangeListener
	 */
	public void removePropertyChangeListener(PropertyChangeListener l);

	/**
	 * cXP[̖ڐ̐Ԃ܂B
	 * @return cXP[̖ڐ̐
	 */
	public int getVerticalScaleCount();

	/**
	 * cXP[̖ڐ̃sNZԂ܂B
	 * @return cXP[̖ڐ̃sNZ
	 */
	public int getVerticalScaleHeight();

	/**
	 * XP[̖ڐ̐Ԃ܂B
	 * @return XP[̖ڐ̐
	 */
	public int getHorizontalScaleCount();

	/**
	 * XP[̖ڐ̎ԁi_bjԂ܂B
	 * @return XP[̖ڐ̎ԁi_bj
	 */
	public long getHorizontalScaleWidth();

	/**
	 * XP[̖ڐ̐ݒ肵܂B
	 * @param horizontalScaleCount XP[̖ڐ̐
	 */
	public void setHorizontalScaleCount(int horizontalScaleCount);

	/**
	 * XP[̖ڐ̎ԁi_bjݒ肵܂B
	 * @param horizontalScaleWidth XP[̖ڐ̎ԁi_bj
	 */
	public void setHorizontalScaleWidth(long horizontalScaleWidth);

	/**
	 * Otr[ȊÕR|[lg̗]̃CZbcԂ܂B
	 * @return R|[lg̗]̃CZbc
	 */
	public Insets getInsets();

	/**
	 * Otr[ȊO̗]̃CZbcԂ܂B
	 * @return R|[lg̗]̃CZbc
	 */
	public Insets getGraphiViewInsets();

	/**
	 * OtE} Color IuWFNg̔zԂ܂B
	 * @return OtE} Color IuWFNg̔z
	 */
	public Color[] getColors();

	/**
	 * ̃vpeBŐݒ肳ĂAO[ṽTCYԂ܂B
	 * @return O[ṽTCY
	 */
	public int getGroupSize();

	/**
	 * ݐݒ肳ĂO[vԂ܂B
	 * @return ݐݒ肳ĂO[v
	 */
	public int getGroup();

	/**
	 * ݐݒ肳ĂO[vԂ܂B
	 * @return ݐݒ肳ĂO[v
	 */
	public String getGroupName();

	/**
	 * IO[vݒ肵܂
	 * @param group O[v
	 */
	public void setGroup(int group);

	/**
	 * ̃O[vɈړ܂B
	 */
	void nextGroup();
	
	/**
	 * ÕO[vɈړ܂B
	 */
	void prevGroup();

	/**
	 * ݈ʒuÂĂO[v́AV[YTCYԂ܂B
	 * @return ݈ʒuÂĂO[v́AV[YTCY
	 */
	public int getSeriesSize();

	/**
	 * ݈ʒuÂĂO[v́AcXP[̍ŏlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ŏl
	 */
	public double getVerticalMinimum(int series);

	/**
	 * ݈ʒuÂĂO[v́AcXP[̍őlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ől
	 */
	public double getVerticalMaximum(int series);

	/**
	 * ݈ʒuÂĂO[v́AcXP[̍ŏlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMinimum cXP[̍ŏl
	 */
	public void setVerticalMinimum(int series, double verticalMinimum);

	/**
	 * ݈ʒuÂĂO[v́AcXP[̍őlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMaximum cXP[̍ől
	 */
	public void setVerticalMaximum(int series, double verticalMaximum);

	/**
	 * ݈ʒuÂĂO[v́Af[^voC_Ԃ܂B
	 * @param series V[Y
	 * @return f[^voC_
	 */
	public String getDataProviderName(int series);

	/**
	 * ݈ʒuÂĂO[v́Af[^z_Ԃ܂B
	 * @param series V[Y
	 * @return f[^z_
	 */
	public String getDataHolderName(int series);

	/**
	 * ݈ʒuÂĂO[v́AQƒlԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return Qƒl
	 */
	public double getReferenceValue(int series, int fold);

	/**
	 * ݈ʒuÂĂO[v́AQƒlԂ܂B
	 * @param series V[Y
	 * @return Qƒl
	 */
	public double getReferenceValue(int series);

	/**
	 * ݈ʒuÂĂO[v́AQƒlݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(int series, int fold, double referenceValue);

	/**
	 * ݈ʒuÂĂO[v́AQƒlݒ肵܂B
	 * @param series V[Y
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(int series, double referenceValue);

	/**
	 * ݈ʒuÂĂO[v́AQƎݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceTime QƎ
	 */
	public void setReferenceTime(int series, int fold, Timestamp referenceTime);

	/**
	 * ݈ʒuÂĂO[v́AQƎݒ肵܂B
	 * @param series V[Y
	 * @param referenceTime QƎ
	 */
	public void setReferenceTime(int series, Timestamp referenceTime);

	/**
	 * ݈ʒuÂĂO[v́AQƎԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return QƎ
	 */
	public Timestamp getReferenceTime(int series, int fold);

	/**
	 * ݈ʒuÂĂO[v́AQƎԂ܂B
	 * @param series V[Y
	 * @return QƎ
	 */
	public Timestamp getReferenceTime(int series);

	/**
	 * ݈ʒuÂĂO[v́ACfbNXԂ܂B
	 * @return CfbNX̔z
	 */
	public int[] getGroupColumnIndex();
	
	/**
	 * V[YvpeB(O[v̐ݒ)ǉ܂B
	 * @param property V[YvpeB
	 */
	public void addSeriesProperty(GraphSeriesProperty property);
	
	/**
	 * ݕ\Ănh[̃CfbNXݒ肵܂B
	 * @param name nh[
	 */
	public void setListHandlerIndex(int index);
	
	/**
	 * ݃CfbNXŎw肳Ănh[Ԃ܂B
	 * @return ݃CfbNXŎw肳Ănh[
	 */
	public String getListHandlerName();
	
	/**
	 * ܂Ԃ񐔂Ԃ܂B
	 * @return ܂Ԃ
	 */
	public int getFoldCount();

	/**
	 * ݈ʒuÂĂO[v́A|CĝԂ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́ACfbNXԂ܂B
	 */
	public String getPointName(int series);

	/**
	 * ݈ʒuÂĂO[v́APʋLԂ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́APʋLԂ܂B
	 */
	public String getPointMark(int series);
	
	/**
	 * ݈ʒuÂĂO[v́Aݒl\V{Ԃ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́Aݒl\V{Ԃ܂B
	 */
	public ExplanatoryNotesText getSymbol(int series);
	
	/**
	 * ݃NbNĂQƓԂ܂
	 * @return ݃NbNĂQƓԂ܂
	 */
	public Timestamp getReferenceTime();
	
	/**
	 * ݃NbNĂQƓݒ肵܂
	 * @param time ݃NbNĂQƓݒ肵܂
	 */
	public void setReferenceTime(Timestamp time);
	
	/**
	 * \Ot̉sNZԂ܂B
	 * @return \Ot̉sNZԂ܂B
	 */
	public int getHorizontalPixcelWidth();
	
	/**
	 * XXP[̖ڐ蕝Ԃ܂B
	 * @return XXP[̖ڐ蕝Ԃ܂B
	 */
	public int getScaleOneHeightPixel();
	
	/**
	 * Qƕ\̕FԂ܂
	 * @return Qƕ\̕FԂ܂
	 */
	public Color getExplanatoryColor();

	/**
	 * Qƕ\̃tHgԂ܂
	 * @return Qƕ\̃tHgԂ܂
	 */
	public Font getExplanatoryFont();

    public void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    public void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);


	/**
	 * ݐݒ肳ĂO[vԂ܂B
	 * @return ݐݒ肳ĂO[v
	 */
	public Collection getGroupNames();
	
	/**
	 * 1ڂ̃tH[}bgԂ܂
	 * @return 1ڂ̃tH[}bgԂ܂
	 */
	public String getFirstFormat();

	/**
	 * 1ڂ̃tH[}bgݒ肵܂
	 * @param format 1ڂ̃tH[}bgݒ肵܂
	 */
	public void setFirstFormat(String format);
	
	/**
	 * 2ڂ̃tH[}bgԂ܂
	 * @return 2ڂ̃tH[}bgԂ܂
	 */
	public String getSecondFormat();
	
	/**
	 * 2ڂ̃tH[}bgݒ肵܂
	 * @param format 2ڂ̃tH[}bgݒ肵܂
	 */
	public void setSecondFormat(String format);
	
	/**
	 * cXP[̃vpeB[Ԃ܂B
	 * @return cXP[̃vpeB[Ԃ܂
	 */
	public VerticallyScaleProperty getVerticallyScaleProperty();
}
