package org.F11.scada.applet.graph;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.sql.Timestamp;

import org.F11.scada.data.LoggingRowData;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;

/**
 * MOf[^\NXłB
 */
public class LoggingData implements DoubleIterator, LoggingRowData, java.io.Serializable {
	/** serial version UID */
	private static final long serialVersionUID = 1439365531437150528L;
	/**
	 * ^CX^v
	 * @serial ̃R[h̃^CX^v
	 */
	private final Timestamp timestamp;
	/**
	 * V[Yf[^Xg
	 * @serial ̃R[h̃V[Yf[^Xg
	 */
	private final DoubleList seriesList;
	/** V[Yf[^q */
	private transient DoubleIterator seriesIterator;

	/**
	 * RXgN^
	 * @param timestamp ^CX^v
	 * @param seriesList V[Yf[^Xg
	 */
	public LoggingData (Timestamp timestamp, DoubleList seriesList) {
		this.timestamp = timestamp;
		this.seriesList = seriesList;
	}

	/**
	 * R[h̃^CX^vԂ܂
	 * @return R[h̃^CX^v
	 */
	public Timestamp getTimestamp() {
		return timestamp;
	}

	/**
	 * ̃R[h̎wlԂ܂B
	 * @param column w
	 * @return ̃R[h̎wl
	 */
	public double getDouble(int column) {
		return seriesList.get(column);
	}

	/**
	 * V[Yf[^ԂA|C^ɐi߂܂B
	 * @return V[Yf[^̃CX^XB
	 */
	public double next() {
		createIterator();
		return seriesIterator.next();
	}

	/**
	 * ̃V[Yf[^݂΁Atrue Ԃ܂B
	 * @return ̃V[Yf[^݂΁Atrue 𑶍݂Ȃ false Ԃ܂B
	 */
	public boolean hasNext() {
		createIterator();
		return seriesIterator.hasNext();
	}

	/**
	 * V[Yf[^Xg̃|C^ŏɐݒ肵܂B
	 */
	public void first() {
		seriesIterator = seriesList.iterator();
	}

	/**
	 * ̃\bh̓T|[gĂ܂B
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}

	private void createIterator() {
		if (seriesIterator == null) {
			seriesIterator = seriesList.iterator();
		}
	}
	
	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 */
	public String toString() {
		return "timestamp=" + timestamp + ", seriesList=" + seriesList;
	}

	/**
	 * ̃R[h̃f[^̃XgԂ܂B
	 * @return ̃R[h̃f[^̃XgԂ܂B
	 */
	public DoubleList getList() {
		return new ArrayDoubleList(seriesList);
	}

}
