package org.F11.scada.applet.graph;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.awt.Color;
import java.awt.Insets;
import java.beans.PropertyChangeListener;

/**
 * XP[\̃f[^fEC^[tFCXłB
 */
public interface VerticallyScaleModel {

	/**
	 * PropertyChangeListener Xi[Xgɒǉ܂B
	 * @param listener ǉ PropertyChangeListener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener);

	/**
	 * PropertyChangeListener Xi[Xg폜܂B
	 * @param listener 폜 PropertyChangeListener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener);

	/**
	 * ڐ̕Ԃ܂B
	 * @return ڐ̕
	 */
	public int getScaleOneWidth();

	/**
	 * ڐ̍Ԃ܂B
	 * @return ڐ̍
	 */
	public int getScaleOneHeight();

	/**
	 * ڐ̑Ԃ܂B
	 * @return ڐ̑
	 */
	public int getScaleCount();

	/**
	 * XP[̍ŏlԂ܂B
	 * @return XP[̍ŏl
	 */
	public double getScaleMin();

	/**
	 * XP[̍őlԂ܂B
	 * @return XP[̍ől
	 */
	public double getScaleMax();

	/**
	 * XP[̍ŏlݒ肵܂B
	 * @param XP[̍ŏl
	 */
	// TODO StringɕύXH
	public void setScaleMin(double min);

	/**
	 * XP[̍őlݒ肵܂B
	 * @param XP[̍ől
	 */
	// TODO StringɕύXH
	public void setScaleMax(double max);

	/**
	 * XP[ڐ蕶̔zԂ܂B
	 * @return XP[ڐ蕶̔z
	 */
	public String[] getScaleStrings();

	/**
	 * XP[ڐ蕶̍ő啝Ԃ܂B
	 * @param isLeft XP[ǂ
	 * @return XP[ڐ蕶̍ő啝
	 */
	public int getScaleStringMaxWidth(boolean isLeft);

	/**
	 * XP[ڐ蕶̍ő卂Ԃ܂B
	 * @return XP[ڐ蕶̍ő卂
	 */
	public int getScaleStringMaxHeight();

	/**
	 * XP[ڐ蕶̐FԂ܂B
	 * @return XP[ڐ蕶̐F
	 */
	public Color getScaleStringColor();

	/**
	 * `GÃCZbcԂ܂
	 */
	public Insets getScaleInsets();

	/**
	 * XP[őXpύX̗L
	 * @return XP[őXpύXłꍇ true łȂꍇ false
	 */
	public boolean isMaxEnable();

	/**
	 * XP[ŏXpύX̗L
	 * @return XP[ŏXpύXłꍇ true łȂꍇ false
	 */
	public boolean isMinEnable();

	/**
	 * XP[őXpύX̗Lݒ肵܂B
	 * @param enable ύX\ɂꍇ trueAύXsɂꍇ false
	 */
	public void setMaxEnable(boolean enable);

	/**
	 * XP[ŏXpύX̗Lݒ肵܂B
	 * @param enable ύX\ɂꍇ trueAύXsɂꍇ false
	 */
	public void setMinEnable(boolean enable);

	/**
	 * XP[ɑΉV[YԂ܂B
	 * ΉV[Y݂Ȃꍇ-1Ԃ܂B
	 * 
	 * @return XP[ɑΉV[YԂ܂BΉV[Y݂Ȃꍇ-1Ԃ܂B
	 */
	public int getSeries();
	
	/**
	 * f[^voC_Ԃ܂
	 * @return f[^voC_Ԃ܂
	 */
	public String getDataProviderName();
	
	/**
	 * f[^z_Ԃ܂
	 * @return f[^z_Ԃ܂
	 */
	public String getDataHolderName();
}
