package org.F11.scada.applet.schedule;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import javax.swing.JComponent;

import org.F11.scada.applet.ClientConfiguration;
import org.F11.scada.applet.symbol.ColorFactory;

/**
 * Ԃo[CgNXɕ`悷R|[lgłB
 */
abstract class AbstractBarMatrix extends JComponent {
	/** f[^f̎Q */
	protected ScheduleRowModel model;
	/** On ̐F */
	protected Color onColor;
	/** Off ̐F */
	protected Color offColor;

	/** ̈̍ */
	static final int SCALE_HEIGHT = 20;
	/** o[̉̃}[W */
	static final int MARGIN_BOTTOM = 5;
	/** ̃}[W */
	static final int MARGIN_WIDTH = 10;
	/** 1̃|Cg */
	static final int SCALE_RATIO = 6;
	/** 1/1 */
	static final int SCALE_HOUR_RATIO = 6;
	/** 24 */
	static final int HOUR_COUNT = 24;

	/** o[̉ */
	static final int BAR_WIDTH = SCALE_RATIO * SCALE_HOUR_RATIO * HOUR_COUNT;
	/** o[̍ */
	static final int BAR_HEIGHT = 25;

	/**
	 * RXgN^
	 * @param model XPW[fEIuWFNg
	 */
	AbstractBarMatrix(ScheduleRowModel model) {
		super();
		this.model = model;
		init();
	}

	/**
	 * łB
	 */
	private void init() {
		setDoubleBuffered(true);
		setPreferredSize(getPreferredSize());
		setMaximumSize(getPreferredSize());
		setMinimumSize(getPreferredSize());

		ClientConfiguration configuration = new ClientConfiguration();
		onColor = ColorFactory.getColor(configuration.getString("barmatrix.oncolor", "RED"));
		offColor = ColorFactory.getColor(configuration.getString("barmatrix.offcolor", "LIME"));
	}

	/**
	 * TCYԂ܂B
	 * o[̃TCYɂAŒ蒷̃TCYԂ܂B
	 */
	public Dimension getPreferredSize() {
		return new Dimension(BAR_WIDTH + MARGIN_WIDTH * 2, BAR_HEIGHT + SCALE_HEIGHT + MARGIN_BOTTOM);
	}

	/**
	 * ̃R|[lg`悵܂B
	 */
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2d = (Graphics2D)g;

		// o[̓y`悵܂B
		g2d.setColor(Color.gray);
		g2d.fill(new Rectangle(MARGIN_WIDTH, SCALE_HEIGHT, BAR_WIDTH, BAR_HEIGHT));

		// On/Off ԃf[^`悵܂B
		paintTime(g2d);

		// o[̓y̘g`悵܂B
		g2d.setColor(Color.black);
		g2d.draw(new Rectangle(MARGIN_WIDTH, SCALE_HEIGHT, BAR_WIDTH, BAR_HEIGHT));

		// ڐ`悵܂B
		for (int i = MARGIN_WIDTH, hour = 0; i <= BAR_WIDTH + MARGIN_WIDTH; i += SCALE_RATIO) {
			if ((i - MARGIN_WIDTH) % (SCALE_RATIO * SCALE_HOUR_RATIO) == 0) {
				g2d.drawLine(i, SCALE_HEIGHT - 3, i, SCALE_HEIGHT);
				if (hour >= 10)
					g2d.drawString(String.valueOf(hour++), i - 6, SCALE_HEIGHT - 5);
				else
					g2d.drawString(String.valueOf(hour++), i - 3, SCALE_HEIGHT - 5);
			} else if ((i - MARGIN_WIDTH) % (SCALE_RATIO * SCALE_HOUR_RATIO / 2) == 0) {
				g2d.drawLine(i, SCALE_HEIGHT - 2, i, SCALE_HEIGHT);
			} else {
				g2d.drawLine(i, SCALE_HEIGHT - 1, i, SCALE_HEIGHT);
			}
		}
	}

	abstract void paintTime(Graphics2D g2d);
}