/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.schedule.point;

import java.rmi.RemoteException;

import javax.swing.table.TableModel;

import org.F11.scada.data.WifeDataSchedule;
import org.F11.scada.server.schedule.point.dto.SchedulePointDto;
import org.F11.scada.server.schedule.point.dto.SchedulePointRowDto;
import org.F11.scada.server.schedule.point.dto.ScheduleSearchDto;

/**
 * XPW[@ꗗ̃e[uf
 * 
 * @author maekawa
 * 
 */
public interface SchedulePointTableModel extends TableModel {
	/**
	 * Ńe[uf𐶐ȂAʂ́uR[h(count)vu݌ItZbg(offset)vuő匟R[h(limit)vԂ܂B
	 * 
	 * @param dto 
	 * @return ǏԂ܂B
	 */
	SchedulePointDto find(ScheduleSearchDto dto) throws RemoteException;

	/**
	 * Ńe[uf𐶐ȂAʂ́uR[h(count)vu݌ItZbg(offset)vuő匟R[h(limit)vԂ܂B
	 * 
	 * @param dto 
	 * @return ǏԂ܂B
	 */
	SchedulePointDto findByGroup(ScheduleSearchDto dto) throws RemoteException;

	/**
	 * AbstractTableModel#fireTableDataChanged̂܂܎s܂B
	 * 
	 */
	void fireTableDataChanged();

	/**
	 * sf[^Ԃ܂B
	 * 
	 * @param row s
	 * @return sf[^Ԃ܂B
	 */
	SchedulePointRowDto getSchedulePointRowDto(int row);

	/**
	 * Ώۍs̃f[^XV܂
	 * 
	 * @param dto XVf[^
	 * @param row XVf[^s
	 */
	void setSchedulePointRowDto(SchedulePointRowDto dto, int row);

	/**
	 * Ώۍs̃XPW[lԂ܂B
	 * @param row Ώۂ̍s
	 * @return Ώۍs̃XPW[lԂ܂B
	 */
	WifeDataSchedule getSeparateSchedule(int row);
}
