/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.symbol;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataReferencer;
import jp.gr.javacons.jim.DataReferencerOwner;
import jp.gr.javacons.jim.DataValueChangeEvent;
import jp.gr.javacons.jim.DataValueChangeListener;

import org.F11.scada.applet.ClientConfiguration;
import org.F11.scada.data.WifeData;
import org.apache.log4j.Logger;

import java.util.concurrent.CopyOnWriteArrayList;

/**
 * V{IuWFNg̊NXłB
 * 
 * @author Youhei Horikawa <hori@users.sourceforge.jp>
 */
public abstract class Symbol extends JLabel implements CompositeProperty,
		DataReferencerOwner, DataValueChangeListener, ReferencerOwnerSymbol {
	/** DataHolder^CvłB */
	private static final Class[][] WIFE_TYPE_INFO = new Class[][] { {
			DataHolder.class, WifeData.class } };

	/** _ŗp̃^C}[ł */
	private WifeTimer timer = WifeTimer.getInstance();
	/** _ŃtOłB */
	private boolean isBlink = false;
	/** vpeB̃ZbgłB */
	private List propertys = new CopyOnWriteArrayList();
	/** _ł̃Xi[NX */
	private ActionListener listener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			if (isBlink) {
				setVisible(timer.isShowTime());
			}
		}
	};

	private static boolean isCustomTipLocation;
	static {
		ClientConfiguration configuration = new ClientConfiguration();
		isCustomTipLocation = configuration.getBoolean(
				"xwife.applet.Applet.customTipLocation",
				false);
	}

	private static Logger logger = Logger.getLogger(Symbol.class);

	/**
	 * Constructor for Symbol.
	 * 
	 * @param property SymbolProperty IuWFNg
	 */
	public Symbol(SymbolProperty property) {
		super();

		/* _ł̎ */
		timer.addActionListener(listener);

		addCompositeProperty(property);
	}

	/**
	 * Constructor for Symbol.
	 */
	public Symbol() {
		this(null);
	}

	/**
	 * vpeBύX܂B TuNXupdatePropertyImpl\bhATuNXŗL̃vpeB[
	 * ̍XVs܂B̃\bh̓I[o[ChłȂ悤final錾Ă܂B <!-- Template Method
	 * Pattern -->
	 */
	public final void updateProperty() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				/** falseftHg */
				if ("true".equals(getProperty("blink"))) {
					isBlink = true;
				} else {
					isBlink = false;
				}

				String loc_x = getProperty("x");
				String loc_y = getProperty("y");
				if (loc_x != null && loc_y != null) {
					setLocation(Integer.parseInt(loc_x), Integer
							.parseInt(loc_y));
				}

				String toolTipText = getProperty("tooltiptext");
				if (toolTipText != null) {
					setToolTipText(toolTipText);
				}

				updatePropertyImpl();

				/** trueftHg */
				if ("false".equals(getProperty("visible"))) {
					setVisible(false);
				} else {
					setVisible(true);
				}
				revalidate();
			}
		});
	}

	/**
	 * TuNXŗL̃vpeB[̍XVs܂B
	 */
	protected abstract void updatePropertyImpl();

	/**
	 * vpeBݒ肵܂B
	 * 
	 * @see org.F11.scada.applet.symbol.CompositeProperty#addCompositeProperty(CompositeProperty)
	 * @param property R|Wbgp^[
	 */
	public void addCompositeProperty(CompositeProperty property) {
		if (property != null) {
			propertys.add(property);
		}
	}

	/**
	 * vpeB̃Zbgl擾܂B
	 * 
	 * @see org.F11.scada.applet.symbol.CompositeProperty#getProperty(String)
	 * @param key vpeB̃L[
	 */
	public String getProperty(String key) {
		ListIterator li = propertys.listIterator(propertys.size());
		while (li.hasPrevious()) {
			CompositeProperty prop = (CompositeProperty) li.previous();
			if (prop != null && prop.getProperty(key) != null)
				return prop.getProperty(key);
		}
		return null;
	}

	/**
	 * DataHolder^CvԂ܂B
	 * 
	 * @see jp.gr.javacons.jim.DataReferencerOwner#getReferableDataHolderTypeInfo(DataReferencer)
	 */
	public Class[][] getReferableDataHolderTypeInfo(DataReferencer dr) {
		return WIFE_TYPE_INFO;
	}

	/**
	 * f[^ύXCxg
	 * 
	 * @see jp.gr.javacons.jim.DataValueChangeListener#dataValueChanged(DataValueChangeEvent)
	 */
	public void dataValueChanged(DataValueChangeEvent evt) {
		Object o = evt.getSource();
		if (!(o instanceof DataHolder)) {
			return;
		}

		updateProperty();
	}

	/**
	 * eV{Managero^܂B
	 * 
	 * @since 1.1.1
	 */
	public void disConnect() {
		for (Iterator it = propertys.iterator(); it.hasNext();) {
			CompositeProperty cp = (CompositeProperty) it.next();
			if (cp instanceof BitRefer) {
				BitRefer br = (BitRefer) cp;
				br.disconnectReferencer(this);
			}
		}
		propertys.clear();
		timer.removeActionListener(listener);
	}

	/**
	 * _ŏԂԂ܂B
	 * 
	 * @return _ŏԂԂ܂
	 */
	public boolean isBlink() {
		return isBlink;
	}

	/**
	 * 
	 * @see javax.swing.JComponent#getToolTipLocation(java.awt.event.MouseEvent)
	 */
	public Point getToolTipLocation(MouseEvent event) {
		if (isCustomTipLocation) {
			Symbol symbol = (Symbol) event.getSource();
			Point p = new Point(event.getX() + 8, symbol.getHeight() / 2 + 32);
			return p;
		} else {
			return super.getToolTipLocation(event);
		}
	}

	public JToolTip createToolTip() {
		return new YellowToolTip(this);
	}
}
