/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/symbol/table/ColumnGroup.java,v 1.1.6.1 2005/08/11 07:46:35 frdm Exp $
 * $Revision: 1.1.6.1 $
 * $Date: 2005/08/11 07:46:35 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.applet.symbol.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/**
 * O[ve[uwb_̃GgNXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class ColumnGroup {
	/** e[uwb_[Z_[̎Q */
	private TableCellRenderer renderer;
	/** ColumnGroup  TableColumn IuWFNg̃Xg */
	private List groupList;
	/** wb_[ɕ\eLXg */
	private String text;
	/** wb_Ԃ̃}[W */
	private int margin;

	/**
	 * ftHg̃wb__[ŁAColumnGroupIuWFNg𐶐܂B
	 * ColumnGroup͓qɂ邱Ƃ\ŁA`悳wb_qɂȂ܂B
	 * @param text wb_ɕ\eLXg
	 */
	public ColumnGroup(String text) {
		this(null, text);
	}

	/**
	 * wb_̃_[w肵āAColumnGroupIuWFNg𐶐܂B
	 * ColumnGroup͓qɂ邱Ƃ\ŁA`悳wb_qɂȂ܂B
	 * @param renderer wb_̃_[IuWFNg
	 * @param text wb_ɕ\eLXg
	 */
	public ColumnGroup(TableCellRenderer renderer, String text) {
		if (renderer == null) {
			this.renderer = new DefaultTableCellRenderer() {
				private static final long serialVersionUID = 7153428198215003103L;

				public Component getTableCellRendererComponent(
						JTable table,
						Object value,
						boolean isSelected,
						boolean hasFocus,
						int row,
						int column) {
					JTableHeader header = table.getTableHeader();
					if (header != null) {
						setForeground(header.getForeground());
						setBackground(header.getBackground());
						setFont(header.getFont());
					}
					setHorizontalAlignment(JLabel.CENTER);
					setText((value == null) ? "" : value.toString());
					setBorder(UIManager.getBorder("TableHeader.cellBorder"));
					return this;
				}
			};
		} else {
			this.renderer = renderer;
		}
		this.text = text;
		groupList = new LinkedList();
	}

	/**
	 * ColumnGroupqɒǉ܂B
	 * @param obj ColumnGroupIuWFNg
	 */
	public void add(ColumnGroup obj) {
		if (obj == null) {
			throw new IllegalArgumentException("ColumnGroup is null Object.");
		}
		if (obj == this) {
			throw new IllegalArgumentException("ColumnGroup is `this' Object.");
		}
		groupList.add(obj);
	}

	/**
	 * TableColumnqɒǉ܂B
	 * @param obj TableColumnIuWFNg
	 */
	public void add(TableColumn obj) {
		if (obj == null) {
			throw new IllegalArgumentException("TableColumn is null Object.");
		}
		groupList.add(obj);
	}

	/**
	 * TableColumn܂ށAKwColumnGroup̃XgIuWFNgԂ܂B
	 * @param c TableColumn
	 * @param g ColumnGroups
	 * @return TableColumn݂ꍇAKwColumnGroup̃XgIuWFNgB݂Ȃꍇ null Ԃ܂B
	 */
	public List getColumnGroups(TableColumn c, List g) {
		g.add(this);
		if (groupList.contains(c)) {
			return g;
		}
		for (Iterator it = groupList.iterator(); it.hasNext();) {
			Object obj = it.next();
			if (obj instanceof ColumnGroup) {
				List g2 = new LinkedList(g);
				List groups =
					((ColumnGroup) obj).getColumnGroups(c, g2);
				if (groups != null) {
					return groups;
				}
			}
		}
		return null;
	}

	/**
	 * TableCellRendererIuWFNgԂ܂B
	 * @return TableCellRendererIuWFNg
	 */
	public TableCellRenderer getHeaderRenderer() {
		return renderer;
	}

	/**
	 * TableCellRendererݒ肵܂B
	 * @param renderer TableCellRendererIuWFNg
	 */
	public void setHeaderRenderer(TableCellRenderer renderer) {
		if (renderer != null) {
			this.renderer = renderer;
		}
	}

	/**
	 * wb_li^CgjԂ܂B
	 * @return wb_li^Cgj
	 */
	public Object getHeaderValue() {
		return text;
	}

	/**
	 * ̗̃TCYԂ܂B
	 * @param table wb_Ăe[u
	 * @return DimensionIuWFNg
	 */
	public Dimension getSize(JTable table) {
		Component comp =
			renderer.getTableCellRendererComponent(
				table,
				getHeaderValue(),
				false,
				false,
				-1,
				-1);
		int height = comp.getPreferredSize().height;
		int width = 0;
		for (Iterator it = groupList.iterator(); it.hasNext();) {
			Object obj = it.next();
			if (obj instanceof TableColumn) {
				TableColumn aColumn = (TableColumn) obj;
				width += aColumn.getWidth();
				width += margin;
			} else {
				width += ((ColumnGroup) obj).getSize(table).width;
			}
		}
		return new Dimension(width, height);
	}

	/**
	 * q̗wb_Ԃ̃}[Wݒ肵܂B
	 * @param margin q̗wb_Ԃ̃}[W
	 */
	public void setColumnMargin(int margin) {
		this.margin = margin;
		for (Iterator it = groupList.iterator(); it.hasNext();) {
			Object obj = it.next();
			if (obj instanceof ColumnGroup) {
				((ColumnGroup) obj).setColumnMargin(margin);
			}
		}
	}
	
	public List getGroupList() {
		return groupList;
	}
}
