/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 * @author hori
 */
public class TwoDaysSchedulePattern implements SchedulePattern, Serializable {
	static final long serialVersionUID = -4465547942929089419L;
	/** \CfbNX̒萔łB */
	public static final int TODAY = 0;
	/** \CfbNX̒萔łB */
	public static final int TOMORROW = 1;
	/** ڂ̃CfbNX`B */
	private final List indexs;
	/** ̃CX^X̃nbVR[hł */
	private transient volatile int hashCode;

	/**
	 * RXgN^
	 */
	public TwoDaysSchedulePattern() {
		indexs = new LinkedList();
		init();
	}

	private void init() {
		indexs.add(SchedulePatternItem.TODAY);
		indexs.add(SchedulePatternItem.TOMORROW);
	}

	/**
	 * ̃XPW[p^[̑Ԃ܂B
	 * @return XPW[p^[̑
	 */
	public int size() {
		return indexs.size();

	}

	/**
	 * ̍ڂɂCfbNXԂ܂B
	 * @param n ڂ̎
	 * @return ̍ڂɂCfbNX
	 */
	public int getDayIndex(int n) {
		checkIndex(n);
		return ((SchedulePatternItem)indexs.get(n)).getIndex();
	}

	/**
	 * ̍ڂɂCfbNXԂ܂B
	 * @param n ڂ̎
	 * @return ̍ڂɂCfbNX
	 */
	public String getDayIndexName(int n) {
		checkIndex(n);
		return ((SchedulePatternItem)indexs.get(n)).getIndexName();
	}

	/**
	 * Ŏw肳ꂽ̃CfbNXԂ܂B
	 * @param ̎ޔԍ(0 n܂܂)
	 */
	public int getSpecialDayOfIndex(int n) {
		throw new UnsupportedOperationException("Argument = " + n);
	}

	private void checkIndex(int n) {
		if (n < 0 || n >= indexs.size())
			throw new IllegalArgumentException("Argument = " + n);
	}

	public int getTopSize() {
		return 2;
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("indexs=");
		buffer.append(indexs.toString());
		return buffer.toString();
	}

	/**
	 * ̃IuWFNgƑ̃IuWFNgǂ܂B
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof TwoDaysSchedulePattern)) {
			return false;
		}

		TwoDaysSchedulePattern sp = (TwoDaysSchedulePattern)obj;

		return this.indexs.equals(sp.indexs);
	}

	/**
	 * ̃IuWFNg̃nbVR[hԂ܂B
	 */
	public int hashCode() {
		if (hashCode == 0) {
			int result = 17;
			result = 37 * result + indexs.hashCode();
			hashCode = result;
		}
		return hashCode;
	}

	/**
	 * ȊO\^CvZ[temunNXłB
	 * j
	 * @todo `@Ot@CŊOɏoH
	 */
	private final static class SchedulePatternItem implements Serializable {
		static final long serialVersionUID = -5213928260544704641L;
		static final SchedulePatternItem TODAY = new SchedulePatternItem(0, "");
		static final SchedulePatternItem TOMORROW = new SchedulePatternItem(1, "");

		private final int index;
		private final String indexName;

		private SchedulePatternItem(int index, String indexName) {
			this.index = index;
			this.indexName = indexName;
		}

		int getIndex() {
			return index;
		}

		String getIndexName() {
			return indexName;
		}

		static SchedulePatternItem valueOf(int index, String indexName) {
			return new SchedulePatternItem(index, indexName);
		}

		/**
		 * ̃IuWFNg̕\Ԃ܂B
		 */
		public String toString() {
			return "index=" + index + ",indexName=" + indexName;
		}

		/**
		 * ̃IuWFNgƑ̃IuWFNgǂ܂B
		 */
		public boolean equals(Object obj) {
			if (obj == this) {
				return true;
			}
			if (!(obj instanceof SchedulePatternItem)) {
				return false;
			}

			SchedulePatternItem sp = (SchedulePatternItem)obj;

			return this.index == sp.index && this.indexName.equals(sp.indexName);
		}

		/**
		 * ̃IuWFNg̃nbVR[hԂ܂B
		 */
		public int hashCode() {
			int result = 17;
			result = 37 * result + index;
			result = 37 * result + indexName.hashCode();
			return result;
		}
	}
}
