package org.F11.scada.security;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.util.Map;

/**
 * <p>ZLeB|V[ Map \NX𐶐t@Ng[NXłB
 * <p>createPolicyMap(String name) \bh Map IuWFNg𐶐܂B
 */
public abstract class PolicyMapFactory {
	/**
	 * w肳ꂽ Map NXŁA|V[ Map 𐶐܂B
	 * @param name NX
	 * @return |V[ Map
	 * @throws ClassNotFoundException NXȂꍇ
	 * @throws InstantiationException  Class  abstract NXAC^tF[XAzNXAv~eBu^A܂ void \ꍇANX null RXgN^ێȂꍇA邢̓CX^X̐ق̗RŎsꍇ
	 * @throws IllegalAccessException NX܂͂ null RXgN^ɃANZXłȂꍇ
	 */
	public static Map createPolicyMap(String name)
			throws ClassNotFoundException, InstantiationException, IllegalAccessException {
		Class cl = Class.forName(name);
		PolicyMapFactory pf = (PolicyMapFactory)cl.newInstance();
		return pf.createMap();
	}

	/**
	 * ۂɃ|V[`AMap CX^X𐶐܂B
	 * @return |V[ Map
	 */
	public abstract Map createMap();
}
