/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.server.autoprint.jasper.exportor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperExportManager;
import dori.jasper.engine.JasperPrint;

/**
 * PDFt@Co͂NXł
 * 
 * o̓NXvpeB[ out ɂ́At@Cw肵܂B
 * t@Cɂ'%'ň͂ނƂ {@link java.text.SimpleDateFormat}NX̓t/p^[gp邱Ƃł܂B
 * 
 * .
 * daily%yyyyMMdd%.pdf́A2004N41Ɏs邱Ƃdaily20040101.pdfƓWJ܂B
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class PdfExportor implements Exportor {
	/** o͐pX̃vpeB */
	public static final String PROPERTY_OUT = "out";
	/** ̃NX̃vpeB[ */
	private final Properties properties;

	/**
	 * ftHgRXgN^
	 */
	public PdfExportor() {
		this.properties = new Properties();
	}

	/**
	 * vpeB[ݒ肵܂B
	 * @param key vpeB[
	 * @param value vpeB[l
	 */
	public void setProperty(String key, String value) {
		this.properties.setProperty(key, value);
	}

	// Only in a test, it is used.
	String getOut() {
		String outPath = this.properties.getProperty(PROPERTY_OUT, "");
		return canonicalFile(outPath);
	}

	/**
	 * IuWFNg PDF t@Cɏo͂܂
	 * @param print IuWFNg
	 */
	public void export(JasperPrint print) throws JRException {
		JasperExportManager.exportReportToPdfFile(print, getOut());
	}
	
	private String canonicalFile(String out) {
		if (out.indexOf("%") < 0) {
			return out;
		}

		String[] s = out.split("\\%");
		String dateStr = new SimpleDateFormat(s[1]).format(new Date());
		return s[0] + dateStr + s[2];
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "properties=[" + properties + "]";
	}

}
