/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.communicater;

import java.util.LinkedList;

/**
 * @author hori
 */
/**
 * [hCgbNp^[ŃbNsNXłB
 * Ǎ݁A݂̓bNAǍݓmAݓmbN܂B
 * ҂̃Xbh́A݂D悵AɃbN҂ɓ̂D悳܂B
 * 
 * obj.lock();
 * try {
 * } finally {
 *   obj.unlock();
 * }
 */
public final class ReadWriteLock {
	/** [hbN */
	private boolean reading = false;
	/** CgbN */
	private boolean writing = false;
	/** ҂Xbh̃Xg */
	private LinkedList<Thread> waitingList = new LinkedList<Thread>();

	/**
	 * Ǎ݃bN擾
	 */
	public synchronized void readLock() throws InterruptedException {
		// ҂BݗD
		while (reading || writing || 0 < waitingList.size()) {
			wait();
		}
		reading = true;
	}

	/**
	 * Ǎ݃bN
	 */
	public synchronized void readUnlock() {
		reading = false;
		notifyAll();
	}

	/**
	 * ݃bN擾
	 */
	public synchronized void writeLock() throws InterruptedException {
		Thread th = Thread.currentThread();
		waitingList.addLast(th);
		try {
			// ҂B擪gȂ烍bN擾B
			while (reading || writing || waitingList.getFirst() != th) {
				wait();
			}
		} finally {
			// 荞݂Ŕꍇł̓o^폜B
			waitingList.remove(th);
		}
		writing = true;
	}

	/**
	 * ݃bN
	 */
	public synchronized void writeUnlock() {
		writing = false;
		notifyAll();
	}
}
