/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.converter;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import org.F11.scada.WifeException;
import org.F11.scada.WifeUtilities;
import org.F11.scada.server.communicater.Environment;
import org.F11.scada.server.event.WifeCommand;

/**
 * WifeʐMW[FINSR}h̎NXB
 */
public abstract class AbstractFINS_CV implements Converter {
	/** FINSR}hwb_ */
	private static final int FINS_COMMAND_HEADER_LENGTH = 14;

	/**  DM̃f[^\܂B */
	public static final Integer DM_AREA = new Integer(0);
	/**  IÕ[GA\܂B */
	public static final Integer CIO_AREA = new Integer(1);
	/**  ̊goN 0 ` C \܂B */
	public static final Integer EM0_AREA = new Integer(10);
	public static final Integer EM1_AREA = new Integer(11);
	public static final Integer EM2_AREA = new Integer(12);
	public static final Integer EM3_AREA = new Integer(13);
	public static final Integer EM4_AREA = new Integer(14);
	public static final Integer EM5_AREA = new Integer(15);
	public static final Integer EM6_AREA = new Integer(16);
	public static final Integer EM7_AREA = new Integer(17);
	public static final Integer EM8_AREA = new Integer(18);
	public static final Integer EM9_AREA = new Integer(19);
	public static final Integer EMA_AREA = new Integer(20);
	public static final Integer EMB_AREA = new Integer(21);
	public static final Integer EMC_AREA = new Integer(22);
	/** z PLCXe[^X\܂B */
	public static final Integer PLCST_AREA = new Integer(90);
	/** z PLCv\܂B */
	public static final Integer PLCTM_AREA = new Integer(91);

	/** ʂ̃}bv */
	private static final Map memoryModeMap;
	static {
		memoryModeMap = new HashMap();
		memoryModeMap.put(DM_AREA, new Byte((byte) 0x82));
		memoryModeMap.put(CIO_AREA, new Byte((byte) 0x80));
		memoryModeMap.put(EM0_AREA, new Byte((byte) 0x90));
		memoryModeMap.put(EM1_AREA, new Byte((byte) 0x91));
		memoryModeMap.put(EM2_AREA, new Byte((byte) 0x92));
		memoryModeMap.put(EM3_AREA, new Byte((byte) 0x93));
		memoryModeMap.put(EM4_AREA, new Byte((byte) 0x94));
		memoryModeMap.put(EM5_AREA, new Byte((byte) 0x95));
		memoryModeMap.put(EM6_AREA, new Byte((byte) 0x96));
		memoryModeMap.put(EM7_AREA, new Byte((byte) 0x97));
	}
	/** FINSʐMV[PVID */
	protected byte sid;

	/** FINSwb_f[^ */
	private byte[] head = { (byte) 0x80, (byte) 0x00, (byte) 0x02, (byte) 0x00,
			(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00 };

	/**
	 * WFINSR}hMpPbgőTCYԂ܂B
	 * 
	 * @return WFINSR}hMpPbgőTCYԂ܂B
	 */
	protected abstract int getReceiveSize();

	/**
	 * WFINSR}hMpPbgőTCYԂ܂B
	 * 
	 * @return WFINSR}hMpPbgőTCYԂ܂B
	 */
	protected abstract int getSendSize();

	/** ݒ肵AX|Xwb_ԂB */
	public byte[] setEnvironment(Environment device) {
		head[3] = (byte) device.getPlcNetNo();
		head[4] = (byte) device.getPlcNodeNo();
		head[5] = (byte) device.getPlcUnitNo();
		head[6] = (byte) device.getHostNetNo();
		head[7] = (byte) device.getHostAddress();

		byte[] resp = new byte[head.length];
		resp[0] = (byte) 0xc0;
		resp[1] = (byte) 0x00;
		resp[2] = (byte) 0x02;
		resp[3] = head[6];
		resp[4] = head[7];
		resp[5] = head[8];
		resp[6] = head[3];
		resp[7] = head[4];
		resp[8] = head[5];
		return resp;
	}

	/** Ǎ݃R}hݒ肷B */
	public void setReadCommand(WifeCommand commdef) throws WifeException {
		if (PLCST_AREA.intValue() == commdef.getMemoryMode()) {
			// PLCXe[^XǍ݃R}h
			finsCommand = STATREAD_FINSCOMMAND;
		} else if (PLCTM_AREA.intValue() == commdef.getMemoryMode()) {
			// vǍ݃R}h
			finsCommand = TIMEREAD_FINSCOMMAND;
		} else {
			// Ǎ݃R}h
			finsCommand = READ_FINSCOMMAND;
		}
		finsCommand.setCommand(commdef, null);
	}

	/** ݃R}hݒ肷B */
	public void setWriteCommand(WifeCommand commdef, byte[] data)
			throws WifeException {
		if (PLCTM_AREA.intValue() == commdef.getMemoryMode()) {
			// v݃R}h
			finsCommand = TIMEWRITE_FINSCOMMAND;
		} else {
			// ݃R}h
			finsCommand = WRITE_FINSCOMMAND;
		}
		finsCommand.setCommand(commdef, data);
	}

	/** R}h擾\H */
	public boolean hasCommand() {
		return finsCommand.hasCommand();
	}

	/** R}h쐬ÃR}h܂B */
	public void nextCommand(ByteBuffer sendBuffer) {
		sendBuffer.put(head);
		incrementSid();
		sendBuffer.put(sid);
		finsCommand.nextCommand(sendBuffer);
	}

	/** OsR}h쐬܂B */
	public void retryCommand(ByteBuffer sendBuffer) {
		sendBuffer.put(head);
		sendBuffer.put(sid);
		finsCommand.retryCommand(sendBuffer);
	}

	/** Mf[^ƎMf[^̐܂B */
	public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
		byte[] err = { 0, 0 };
		if (recvBuffer.remaining() < FINS_COMMAND_HEADER_LENGTH) {
			StringBuffer sb = new StringBuffer();
			sb.append("RecvData (");
			sb.append(WifeUtilities.toString(recvBuffer));
			sb.append(") is short!");
			return new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_RESPONCE_ERROR,
					sb.toString());
		}
		// wb_
		if (recvBuffer.get(9) != sid) {
			StringBuffer sb = new StringBuffer();
			sb.append("Head error: send ");
			sb.append(WifeUtilities.toString(head));
			byte[] s = new byte[1];
			s[0] = sid;
			sb.append(WifeUtilities.toString(s));
			sb.append(" recv ").append(
					WifeUtilities.toString(recvBuffer, 0, 10));
			return new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_RESPONCE_HEAD_ERROR,
					sb.toString());
		}
		// R}hR[h
		WifeException ec = finsCommand.checkCommandResponce(recvBuffer);
		if (ec != null) {
			return ec;
		}
		// IR[h
		if (recvBuffer.get(12) != (byte) 0x00
				|| (recvBuffer.get(13) & 0x3f) != 0x00) {
			err[0] = recvBuffer.get(12);
			err[1] = recvBuffer.get(13);
			StringBuffer sb = new StringBuffer();
			sb.append("End code error: ");
			sb.append(WifeUtilities.toString(err));
			return new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_RESPONCE_ENDCODE_ERROR,
					err,
					sb.toString());
		}
		// X|Xf[^
		if (finsCommand.getResponceLength() != recvBuffer.remaining()) {
			StringBuffer sb = new StringBuffer();
			sb.append("Expected length ").append(
					finsCommand.getResponceLength());
			sb.append(" != RecvData length ").append(recvBuffer.remaining());
			return new WifeException(
					WifeException.WIFE_ERROR,
					WifeException.WIFE_NET_RESPONCE_ERROR,
					sb.toString());
		}
		return null;
	}

	/** Mf[^f[^擾܂B */
	public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
		finsCommand.getResponceData(recvBuffer, recvData);
	}

	/** ʐM̍ő咷Ԃ܂B */
	public int getPacketMaxSize(WifeCommand commdef) {
		return getReceiveSize() / 2;
	}

	/**
	 * FINSʐMV[PVIDXV
	 */
	private void incrementSid() {
		sid++;
		if (127 < sid)
			sid = 0;
	}

	/**
	 * \Ԃ܂B
	 */
	public String toString() {
		return finsCommand.toString();
	}

	/**
	 * R}hϊwp[NX̃C^[tFCXłB
	 */
	private interface FinsCommand {
		/** R}hݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data)
				throws WifeException;

		/** R}h擾\H */
		public boolean hasCommand();

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer);

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer);

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength();

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer);

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData);
	}

	/**
	 * Ǎ݃R}hϊwp[NX̃CX^XłB
	 */
	private final FinsCommand READ_FINSCOMMAND = new FinsCommand() {
		/** PLC */
		private byte memoryMode;
		/** PLCAhX */
		private long memoryAddress;
		/** ׂPLCf[^̎coCg */
		private int restByteLength;
		/** PLCf[^oCg */
		private int thisByteLength;

		/** R}hݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data)
				throws WifeException {
			Byte mm = (Byte) memoryModeMap.get(new Integer(commdef
					.getMemoryMode()));
			if (mm == null) {
				throw new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_COMMAND_ERROR,
						"Not supported memory mode " + commdef.getMemoryMode());
			}
			this.memoryMode = mm.byteValue();

			this.memoryAddress = commdef.getMemoryAddress();
			this.restByteLength = commdef.getWordLength() * 2;
			this.thisByteLength = 0;
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			// foCXɈˑ钷𒴂Ă
			if (getReceiveSize() < restByteLength) {
				thisByteLength = getReceiveSize();
				restByteLength -= getReceiveSize();
			} else {
				thisByteLength = restByteLength;
				restByteLength = 0;
			}

			// PLCR}h
			sendBuffer.put((byte) 0x01);
			sendBuffer.put((byte) 0x01);
			// ʏR}h
			// PLC
			sendBuffer.put(memoryMode);
			// AhXA
			sendBuffer.put((byte) (memoryAddress / 0x100));
			sendBuffer.put((byte) (memoryAddress % 0x100));
			sendBuffer.put((byte) 0x00);
			sendBuffer.put((byte) ((thisByteLength / 2) / 0x100));
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			// ̃AhX
			memoryAddress += (thisByteLength / 2);
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			long addr = memoryAddress - (thisByteLength / 2);

			// PLCR}h
			sendBuffer.put((byte) 0x01);
			sendBuffer.put((byte) 0x01);
			// ʏR}h
			// PLC
			sendBuffer.put(memoryMode);
			// AhXA
			sendBuffer.put((byte) (addr / 0x100));
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) 0x00);
			sendBuffer.put((byte) ((thisByteLength / 2) / 0x100));
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
		}

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength() {
			return FINS_COMMAND_HEADER_LENGTH + thisByteLength;
		}

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
			// R}hR[h
			if ((byte) 0x01 != recvBuffer.get(10)
					|| (byte) 0x01 != recvBuffer.get(11)) {
				StringBuffer sb = new StringBuffer();
				sb.append("Command error: send 0101 recv ");
				sb.append(WifeUtilities.toString(recvBuffer, 10, 2));
				return new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_RESPONCE_CMND_ERROR,
						sb.toString());
			}
			return null;
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
			recvBuffer.position(FINS_COMMAND_HEADER_LENGTH);
			recvData.put(recvBuffer);
		}

		/**
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("ReadMode:").append("\n");
			s.append("memoryMode:").append(memoryMode).append("\n");
			s.append("memoryAddress:").append(memoryAddress).append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/**
	 * PLCXe[^XǍ݃R}hϊwp[NX̃CX^XłB
	 */
	private final FinsCommand STATREAD_FINSCOMMAND = new FinsCommand() {
		/** PLCAhX */
		private long memoryAddress;
		/** ׂPLCf[^̎coCg */
		private int restByteLength;
		/** PLCf[^oCg */
		private int thisByteLength;

		/** vꂽf[^oCg */
		// private int rreqByteLength;
		/** R}h̃l^ݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data) {
			this.memoryAddress = commdef.getMemoryAddress();
			this.restByteLength = 13 * 2;
			// this.rreqByteLength = commdef.getWordLength() * 2;
			this.thisByteLength = 0;
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			// foCXɈˑ钷𒴂Ă
			if (getReceiveSize() < restByteLength) {
				thisByteLength = getReceiveSize();
				restByteLength -= getReceiveSize();
			} else {
				thisByteLength = restByteLength;
				restByteLength = 0;
			}

			// PLCR}h
			sendBuffer.put((byte) 0x06);
			sendBuffer.put((byte) 0x01);
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			// PLCR}h
			sendBuffer.put((byte) 0x06);
			sendBuffer.put((byte) 0x01);
		}

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength() {
			return FINS_COMMAND_HEADER_LENGTH + thisByteLength;
		}

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
			// R}hR[h
			if ((byte) 0x06 != recvBuffer.get(10)
					|| (byte) 0x01 != recvBuffer.get(11)) {
				StringBuffer sb = new StringBuffer();
				sb.append("Command error: send 0601 recv ");
				sb.append(WifeUtilities.toString(recvBuffer, 10, 2));
				return new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_RESPONCE_CMND_ERROR,
						sb.toString());
			}
			return null;
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
			recvBuffer.position(FINS_COMMAND_HEADER_LENGTH
					+ ((int) memoryAddress * 2));
			recvData.put(recvBuffer);
		}

		/**
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("StatusReadMode:").append("\n");
			s.append("memoryAddress:").append(memoryAddress).append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/**
	 * ݃R}hϊwp[NX̃CX^XłB
	 */
	private final FinsCommand WRITE_FINSCOMMAND = new FinsCommand() {
		/** PLC */
		private byte memoryMode;
		/** PLCAhX */
		private long memoryAddress;
		/** ݃f[^ */
		private byte[] writeData;
		/** ݃f[^ʒu */
		private int writePos;
		/** ׂPLCf[^̎coCg */
		private int restByteLength;
		/** PLCf[^oCg */
		private int thisByteLength;

		/** R}h̃l^ݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data)
				throws WifeException {
			Byte mm = (Byte) memoryModeMap.get(new Integer(commdef
					.getMemoryMode()));
			if (mm == null) {
				throw new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_COMMAND_ERROR,
						"Not supported memory mode " + commdef.getMemoryMode());
			}
			this.memoryMode = mm.byteValue();

			this.memoryAddress = commdef.getMemoryAddress();
			this.writeData = data;
			this.writePos = 0;
			this.restByteLength = commdef.getWordLength() * 2;
			this.thisByteLength = 0;
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			// foCXɈˑ钷𒴂Ă
			if (getSendSize() < restByteLength) {
				thisByteLength = getSendSize();
				restByteLength -= getSendSize();
			} else {
				thisByteLength = restByteLength;
				restByteLength = 0;
			}

			// PLCR}h
			sendBuffer.put((byte) 0x01);
			sendBuffer.put((byte) 0x02);
			// PLC
			sendBuffer.put(memoryMode);
			// AhXA
			sendBuffer.put((byte) (memoryAddress / 0x100));
			sendBuffer.put((byte) (memoryAddress % 0x100));
			sendBuffer.put((byte) 0x00);
			sendBuffer.put((byte) ((thisByteLength / 2) / 0x100));
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			// ݃f[^
			sendBuffer.put(writeData, writePos, thisByteLength);

			// ̃AhX
			memoryAddress += (thisByteLength / 2);
			writePos += thisByteLength;
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			long addr = memoryAddress - (thisByteLength / 2);
			int pos = writePos - thisByteLength;

			// PLCR}h
			sendBuffer.put((byte) 0x01);
			sendBuffer.put((byte) 0x02);
			// PLC
			sendBuffer.put(memoryMode);
			// AhXA
			sendBuffer.put((byte) (addr / 0x100));
			sendBuffer.put((byte) (addr % 0x100));
			sendBuffer.put((byte) 0x00);
			sendBuffer.put((byte) ((thisByteLength / 2) / 0x100));
			sendBuffer.put((byte) ((thisByteLength / 2) % 0x100));
			// ݃f[^
			sendBuffer.put(writeData, pos, thisByteLength);
		}

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength() {
			return FINS_COMMAND_HEADER_LENGTH;
		}

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
			// R}hR[h
			if ((byte) 0x01 != recvBuffer.get(10)
					|| (byte) 0x02 != recvBuffer.get(11)) {
				StringBuffer sb = new StringBuffer();
				sb.append("Command error: send 0102 recv ");
				sb.append(WifeUtilities.toString(recvBuffer, 10, 2));
				return new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_RESPONCE_CMND_ERROR,
						sb.toString());
			}
			return null;
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
		}

		/**
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("WriteMode:").append("\n");
			s.append("memoryMode:").append(memoryMode).append("\n");
			s.append("memoryAddress:").append(memoryAddress).append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/**
	 * vǍ݃R}hϊwp[NX̃CX^XłB
	 */
	private final FinsCommand TIMEREAD_FINSCOMMAND = new FinsCommand() {
		/** ׂPLCf[^̎coCg */
		private int restByteLength;
		/** PLCf[^oCg */
		private int thisByteLength;

		/** R}h̃l^ݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data) {
			this.restByteLength = 7;
			this.thisByteLength = 0;
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			thisByteLength = restByteLength;
			restByteLength = 0;

			// PLCR}h
			sendBuffer.put((byte) 0x07);
			sendBuffer.put((byte) 0x01);
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {
			// PLCR}h
			sendBuffer.put((byte) 0x07);
			sendBuffer.put((byte) 0x01);
		}

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength() {
			return FINS_COMMAND_HEADER_LENGTH + thisByteLength;
		}

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
			// R}hR[h
			if ((byte) 0x07 != recvBuffer.get(10)
					|| (byte) 0x01 != recvBuffer.get(11)) {
				StringBuffer sb = new StringBuffer();
				sb.append("Command error: send 0701 recv ");
				sb.append(WifeUtilities.toString(recvBuffer, 10, 2));
				return new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_RESPONCE_CMND_ERROR,
						sb.toString());
			}
			return null;
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
			byte[] data = new byte[8 * 2];
			Arrays.fill(data, (byte) 0);
			Calendar cal = new GregorianCalendar();
			cal.setTimeInMillis(System.currentTimeMillis());
			int yh = cal.get(Calendar.YEAR) / 100;
			recvData.put((byte) ((yh / 10) * 16 + (yh % 10)));
			recvData.put(recvBuffer.get(14)); // N
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(15)); // 
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(16)); // 
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(20)); // j
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(17)); // 
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(18)); // 
			recvData.put((byte) 0x00);
			recvData.put(recvBuffer.get(19)); // b
			recvData.put((byte) 0x00);
			recvData.put((byte) 0x01); // tO
		}

		/**
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("TimeReadMode:").append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/**
	 * v݃R}hϊwp[NX̃CX^XłB
	 */
	private final FinsCommand TIMEWRITE_FINSCOMMAND = new FinsCommand() {
		/** ݃f[^ */
		private byte[] writeData;
		/** ׂPLCf[^̎coCg */
		private int restByteLength;
		/** PLCf[^oCg */
		private int thisByteLength;

		/** R}h̃l^ݒ肷B */
		public void setCommand(WifeCommand commdef, byte[] data) {
			this.writeData = data;
			this.restByteLength = 7;
			this.thisByteLength = 0;
		}

		/** R}h擾\H */
		public boolean hasCommand() {
			return 0 < restByteLength;
		}

		/** R}h쐬ÃR}h܂B */
		public void nextCommand(ByteBuffer sendBuffer) {
			thisByteLength = restByteLength;
			restByteLength = 0;

			// PLCR}h
			sendBuffer.put((byte) 0x07);
			sendBuffer.put((byte) 0x02);
			// ݃f[^
			sendBuffer.put(writeData[1]); // N
			sendBuffer.put(writeData[3]); // 
			sendBuffer.put(writeData[5]); // 
			sendBuffer.put(writeData[9]); // 
			sendBuffer.put(writeData[11]); // 
			sendBuffer.put(writeData[13]); // b
			sendBuffer.put(writeData[7]); // j
		}

		/** OsR}h쐬܂B */
		public void retryCommand(ByteBuffer sendBuffer) {

			// PLCR}h
			sendBuffer.put((byte) 0x07);
			sendBuffer.put((byte) 0x02);
			// ݃f[^
			sendBuffer.put(writeData[1]); // N
			sendBuffer.put(writeData[3]); // 
			sendBuffer.put(writeData[5]); // 
			sendBuffer.put(writeData[9]); // 
			sendBuffer.put(writeData[11]); // 
			sendBuffer.put(writeData[13]); // b
			sendBuffer.put(writeData[7]); // j
		}

		/** R}h烌X|Xf[^̃oCg擾܂B */
		public int getResponceLength() {
			return FINS_COMMAND_HEADER_LENGTH;
		}

		/** Mf[^ƎMf[^̐܂B */
		public WifeException checkCommandResponce(ByteBuffer recvBuffer) {
			// R}hR[h
			if ((byte) 0x07 != recvBuffer.get(10)
					|| (byte) 0x02 != recvBuffer.get(11)) {
				StringBuffer sb = new StringBuffer();
				sb.append("Command error: send 0702 recv ");
				sb.append(WifeUtilities.toString(recvBuffer, 10, 2));
				return new WifeException(
						WifeException.WIFE_ERROR,
						WifeException.WIFE_NET_RESPONCE_CMND_ERROR,
						sb.toString());
			}
			return null;
		}

		/** Mf[^f[^擾܂B */
		public void getResponceData(ByteBuffer recvBuffer, ByteBuffer recvData) {
		}

		/**
		 * ̃CX^X̕\Ԃ܂B
		 */
		public String toString() {
			StringBuffer s = new StringBuffer();
			s.append("TimeWriteMode:").append("\n");
			s.append("restByteLength:").append(restByteLength).append("\n");
			s.append("thisByteLength:").append(thisByteLength).append("\n");
			return s.toString();
		}
	};

	/** R}hϊwp[NX */
	private FinsCommand finsCommand = READ_FINSCOMMAND;
}
