/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.frame;

import java.util.Timer;
import java.util.TimerTask;

/**
 * ^CAEgPage폜NXłB
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class PageTimeout {
	/** ftHg̃^CAEg(10) */
	private static final long DEFAULT_TIMEOUT = 1000L * 60L * 10L;

	/** ^CAEg */
	private long timeout;

	/** ^C}[ */
	private final Timer timer;

	/**
	 * ftHg̃^CAEg(10)Ń^C}[܂B
	 */
	public PageTimeout() {
		this(DEFAULT_TIMEOUT);
	}

	/**
	 * Ń^CAEgԎw肵āA^C}[܂B
	 * 
	 * @param timeout ^CAEg
	 */
	public PageTimeout(long timeout) {
		timer = new Timer();
		this.timeout = timeout;
	}

	/**
	 * ̃\[g}bvΏۂɃ^CAEg̃R[h폜܂B
	 */
	public void schedule(JimRegister register) {
		timer.schedule(new PageRemoveTask(register, timeout), 0, (timeout / 2));
	}

	static class PageRemoveTask extends TimerTask {
		private JimRegister register;

		private long timeout;

		PageRemoveTask(JimRegister register, long timeout) {
			this.register = register;
			this.timeout = timeout;
		}

		public void run() {
			removePage();
		}

		private void removePage() {
			long now = System.currentTimeMillis();
			long current = now - timeout;
			register.removePages(current);
		}
	}
}
